/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.base.record.RecordLib;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexTestLib;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import java.util.List;
import org.junit.After;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public abstract class TestRangeIndex
extends BaseTest {
    RangeIndex rIndex = null;

    @After
    public void afterTest() {
        if (this.rIndex != null) {
            this.rIndex.close();
        }
        this.rIndex = null;
    }

    protected RangeIndex makeRangeIndex(int order) {
        return this.makeRangeIndex(order, order);
    }

    protected abstract RangeIndex makeRangeIndex(int var1, int var2);

    @Test
    public void tree_ins_0_0() {
        int[] keys = new int[]{};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertTrue((boolean)this.rIndex.isEmpty());
        TestRangeIndex.assertNull((Object)this.rIndex.minKey());
        TestRangeIndex.assertNull((Object)this.rIndex.maxKey());
    }

    @Test
    public void tree_ins_0_1() {
        int[] keys = new int[]{0, 1, 2};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertFalse((boolean)this.rIndex.isEmpty());
        TestRangeIndex.assertEquals((long)0L, (long)RecordLib.r(this.rIndex.minKey()));
        TestRangeIndex.assertEquals((long)2L, (long)RecordLib.r(this.rIndex.maxKey()));
    }

    @Test
    public void tree_ins_2_01() {
        int[] keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertEquals((long)0L, (long)RecordLib.r(this.rIndex.minKey()));
        TestRangeIndex.assertEquals((long)9L, (long)RecordLib.r(this.rIndex.maxKey()));
    }

    @Test
    public void tree_ins_2_02() {
        int[] keys = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertEquals((long)0L, (long)RecordLib.r(this.rIndex.minKey()));
        TestRangeIndex.assertEquals((long)9L, (long)RecordLib.r(this.rIndex.maxKey()));
    }

    @Test
    public void tree_ins_2_03() {
        int[] keys = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertEquals((long)0L, (long)RecordLib.r(this.rIndex.minKey()));
        TestRangeIndex.assertEquals((long)9L, (long)RecordLib.r(this.rIndex.maxKey()));
    }

    @Test
    public void tree_ins_2_04() {
        int[] keys = new int[]{0, 9, 2, 7, 4, 5, 6, 3, 8, 1};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertEquals((long)0L, (long)RecordLib.r(this.rIndex.minKey()));
        TestRangeIndex.assertEquals((long)9L, (long)RecordLib.r(this.rIndex.maxKey()));
    }

    @Test
    public void tree_ins_2_05() {
        int[] keys = new int[]{0, 18, 4, 14, 8, 10, 12, 6, 16, 2};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsert((Index)this.rIndex, keys);
        TestRangeIndex.assertFalse((boolean)this.rIndex.contains(RecordLib.r(1)));
        TestRangeIndex.assertFalse((boolean)this.rIndex.contains(RecordLib.r(999)));
        TestRangeIndex.assertFalse((boolean)this.rIndex.contains(RecordLib.r(-9)));
        TestRangeIndex.assertFalse((boolean)this.rIndex.contains(RecordLib.r(7)));
        TestRangeIndex.assertEquals((long)0L, (long)RecordLib.r(this.rIndex.minKey()));
        TestRangeIndex.assertEquals((long)18L, (long)RecordLib.r(this.rIndex.maxKey()));
    }

    @Test
    public void tree_del_0_1() {
        int[] keys1 = new int[]{0, 1, 2};
        int[] keys2 = new int[]{0, 1, 2};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_0_2() {
        int[] keys1 = new int[]{0, 1, 2};
        int[] keys2 = new int[]{2, 1, 0};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_0_3() {
        int[] keys1 = new int[]{0, 1, 2};
        int[] keys2 = new int[]{1, 0, 2};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_01() {
        int[] keys1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] keys2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_02() {
        int[] keys1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] keys2 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_03() {
        int[] keys1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] keys2 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_04() {
        int[] keys1 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        int[] keys2 = new int[]{0, 9, 2, 7, 4, 5, 6, 3, 8, 1};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_05() {
        int[] keys1 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        int[] keys2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_06() {
        int[] keys1 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        int[] keys2 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_07() {
        int[] keys1 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        int[] keys2 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_08() {
        int[] keys1 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        int[] keys2 = new int[]{0, 9, 2, 7, 4, 5, 6, 3, 8, 1};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_09() {
        int[] keys1 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        int[] keys2 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_10() {
        int[] keys1 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        int[] keys2 = new int[]{9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_11() {
        int[] keys1 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        int[] keys2 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_del_2_12() {
        int[] keys1 = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        int[] keys2 = new int[]{0, 9, 2, 7, 4, 5, 6, 3, 8, 1};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.testInsertDelete((Index)this.rIndex, keys1, keys2);
    }

    @Test
    public void tree_iter_2_01() {
        int[] keys = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(4), RecordLib.r(6)));
        List<Integer> expected = RecordLib.toIntList(4, 5);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_02() {
        int[] keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(4), RecordLib.r(7)));
        List<Integer> expected = RecordLib.toIntList(4, 5, 6);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_03() {
        int[] keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(4), null));
        List<Integer> expected = RecordLib.toIntList(4, 5, 6, 7, 8, 9);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_04() {
        int[] keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(null, null));
        List<Integer> expected = RecordLib.toIntList(keys);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_05() {
        int[] keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(null, RecordLib.r(4)));
        List<Integer> expected = RecordLib.toIntList(0, 1, 2, 3);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_07() {
        int[] keys = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(null, RecordLib.r(99)));
        List<Integer> expected = RecordLib.toIntList(keys);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_08() {
        int[] keys = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(0), RecordLib.r(99)));
        List<Integer> expected = RecordLib.toIntList(keys);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_2_09() {
        int[] keys = new int[]{1, 2, 3, 4, 7, 8, 9, 10, 11};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(5), RecordLib.r(7)));
        List<Integer> expected = RecordLib.toIntList(new int[0]);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_0_01() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(5);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(2), RecordLib.r(4)));
        List<Integer> expected = RecordLib.toIntList(2, 3);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_0_02() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(5);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(null, null));
        List<Integer> expected = RecordLib.toIntList(keys);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_0_03() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(5);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(5), null));
        List<Integer> expected = RecordLib.toIntList(5);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_0_04() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(5);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(0), RecordLib.r(0)));
        List<Integer> expected = RecordLib.toIntList(new int[0]);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_iter_0_05() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(5);
        IndexTestLib.add((Index)this.rIndex, keys);
        List<Integer> x = RecordLib.toIntList(this.rIndex.iterator(RecordLib.r(1), RecordLib.r(0)));
        List<Integer> expected = RecordLib.toIntList(new int[0]);
        TestRangeIndex.assertEquals(expected, x);
    }

    @Test
    public void tree_ret_1() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        boolean b = this.rIndex.add(RecordLib.intToRecord(3));
        TestRangeIndex.assertFalse((boolean)b);
        b = this.rIndex.add(RecordLib.intToRecord(9));
        TestRangeIndex.assertTrue((boolean)b);
    }

    @Test
    public void tree_ret_2() {
        int[] keys = new int[]{1, 2, 3, 4, 5};
        this.rIndex = this.makeRangeIndex(2);
        IndexTestLib.add((Index)this.rIndex, keys);
        boolean b = this.rIndex.delete(RecordLib.intToRecord(9));
        TestRangeIndex.assertFalse((boolean)b);
        b = this.rIndex.add(RecordLib.intToRecord(1));
        TestRangeIndex.assertFalse((boolean)b);
    }

    @Test
    public void tree_2_N() {
        for (int i = 0; i < 10; ++i) {
            IndexTestLib.randTest((Index)this.makeRangeIndex(2), 999, 20);
        }
    }

    @Test
    public void tree_3_N() {
        for (int i = 0; i < 10; ++i) {
            IndexTestLib.randTest((Index)this.makeRangeIndex(3), 9999, 100);
        }
    }
}

