/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordLib;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexMaker;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.junit.Assert;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.ListUtils;
import org.openjena.atlas.lib.RandomLib;
import org.openjena.atlas.test.Gen;

public class IndexTestLib {
    public static Index buildIndex(IndexMaker maker, int[] keys) {
        Index index = maker.makeIndex();
        IndexTestLib.add(index, keys);
        return index;
    }

    public static void testIteration(RangeIndex index, int[] keys, int numIterations) {
        TreeSet<Integer> x = new TreeSet<Integer>();
        for (int v : keys) {
            x.add(v);
        }
        for (int i = 0; i < numIterations; ++i) {
            int hi;
            int lo = RandomLib.random.nextInt(keys.length);
            if (lo > (hi = RandomLib.random.nextInt(keys.length))) {
                int t = lo;
                lo = hi;
                hi = t;
            }
            if (lo != 0 && (double)RandomLib.random.nextFloat() < 0.5) {
                --lo;
            }
            if ((double)RandomLib.random.nextFloat() < 0.5) {
                ++hi;
            }
            List<Integer> slice = RecordLib.r(index.iterator(RecordLib.r(lo), RecordLib.r(hi)));
            ArrayList<Integer> expected = new ArrayList<Integer>(keys.length);
            for (Integer ii : x.subSet(lo, hi)) {
                expected.add(ii);
            }
            Assert.assertEquals((String)String.format("(%d,%d)", lo, hi), expected, slice);
        }
    }

    public static void randTest(Index index, int maxValue, int numKeys) {
        if (numKeys >= 5000) {
            System.err.printf("Warning: too many keys\n", new Object[0]);
        }
        int[] keys1 = Gen.rand((int)numKeys, (int)0, (int)maxValue);
        int[] keys2 = Gen.permute((int[])keys1, (int)(4 * numKeys));
        try {
            IndexTestLib.testInsert(index, keys1);
            IndexTestLib.testIndexContents(index, keys2);
            if (index instanceof RangeIndex) {
                IndexTestLib.testIteration((RangeIndex)index, keys1, 10);
            }
            IndexTestLib.testDelete(index, keys2);
            index.close();
        }
        catch (RuntimeException ex) {
            System.err.printf("Index : %s\n", index.getClass().getName());
            System.err.printf("int[] keys1 = {%s} ;\n", Gen.strings((int[])keys1));
            System.err.printf("int[] keys2 = {%s}; \n", Gen.strings((int[])keys2));
            throw ex;
        }
    }

    public static void testInsert(Index index, int[] keys) {
        IndexTestLib.add(index, keys);
        IndexTestLib.testIndexContents(index, keys);
    }

    public static Index testInsert(IndexMaker maker, int[] keys) {
        Index index = maker.makeIndex();
        IndexTestLib.testInsert(index, keys);
        return index;
    }

    public static void testInsertDelete(Index index, int[] buildKeys, int[] deleteKeys) {
        IndexTestLib.testInsert(index, buildKeys);
        IndexTestLib.testDelete(index, deleteKeys);
    }

    public static void testDelete(Index index, int[] vals) {
        long size1 = index.size();
        long size1a = index.sessionTripleCount();
        Assert.assertEquals((long)size1, (long)size1a);
        int count = 0;
        count = IndexTestLib.delete(index, vals);
        List<Record> x = RecordLib.intToRecord(vals, 4);
        for (Record r : x) {
            boolean b = index.delete(r);
            if (!b) continue;
            ++count;
        }
        for (Record r : x) {
            BaseTest.assertFalse((boolean)index.contains(r));
        }
        long size2 = index.size();
        long size2a = index.sessionTripleCount();
        Assert.assertEquals((long)(size1 - (long)count), (long)size2);
        Assert.assertEquals((long)size2, (long)size2a);
    }

    public static int delete(Index index, int[] vals) {
        int count = 0;
        for (int v : vals) {
            boolean b = index.delete(RecordLib.r(v));
            if (!b) continue;
            ++count;
        }
        return count;
    }

    public static void add(Index index, int[] vals) {
        List<Record> x = RecordLib.intToRecord(vals, 4);
        for (Record r : x) {
            index.add(r);
        }
    }

    public static void testIndexContents(Index index, int[] records) {
        List<Integer> x = RecordLib.toIntList(index.iterator());
        List y = ListUtils.unique((List)ListUtils.asList((int[])records));
        Assert.assertEquals((String)"Expected records size and tree size different", (long)y.size(), (long)index.sessionTripleCount());
        Assert.assertEquals((String)"Expected records size and iteration over all keys are of different sizes", (long)y.size(), (long)x.size());
        if (index instanceof RangeIndex) {
            for (int i = 0; i < x.size() - 2; ++i) {
                if (x.get(i) <= x.get(i + 1)) continue;
                Assert.fail((String)("check failed: " + Gen.strings((int[])records)));
                return;
            }
        }
        Iterator i$ = y.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            Record rec = RecordLib.intToRecord(k);
            Record r2 = index.find(rec);
            Assert.assertNotNull((String)("Finding " + rec), (Object)r2);
        }
    }
}

