/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph.basics;

import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.graph.basics.FactoryGraphTDB;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBPlusTree;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBTree;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;

class GraphTDBFactoryTesting {
    GraphTDBFactoryTesting() {
    }

    public static GraphTriplesTDB createBTree(Location location) {
        IndexFactoryBTree idxFactory = new IndexFactoryBTree(1024);
        IndexBuilder builder = new IndexBuilder((IndexFactory)idxFactory, (IndexRangeFactory)idxFactory);
        return FactoryGraphTDB.createGraph(builder, location);
    }

    public static GraphTriplesTDB createBPlusTree(Location location) {
        IndexFactoryBPlusTree idxFactory = new IndexFactoryBPlusTree(1024);
        IndexBuilder builder = new IndexBuilder((IndexFactory)idxFactory, (IndexRangeFactory)idxFactory);
        return FactoryGraphTDB.createGraph(builder, location);
    }

    public static GraphTriplesTDB createBPlusTreeMem() {
        IndexFactoryBPlusTree idxFactory = new IndexFactoryBPlusTree(500);
        IndexBuilder builder = new IndexBuilder((IndexFactory)idxFactory, (IndexRangeFactory)idxFactory);
        return FactoryGraphTDB.createGraphMem(builder);
    }

    public static GraphTriplesTDB createBTreeMem() {
        IndexFactoryBTree idxFactory = new IndexFactoryBTree(500);
        IndexBuilder builder = new IndexBuilder((IndexFactory)idxFactory, (IndexRangeFactory)idxFactory);
        return FactoryGraphTDB.createGraphMem(builder);
    }
}

