/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph.basics;

import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTableFactory;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicy;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicyMRSW;
import com.hp.hpl.jena.tdb.sys.Names;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.openjena.atlas.lib.ColumnMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FactoryGraphTDB {
    private static Logger log = LoggerFactory.getLogger(FactoryGraphTDB.class);
    public static final RecordFactory indexRecordTripleFactory = new RecordFactory(24, 0);
    public static final RecordFactory indexRecordQuadFactory = new RecordFactory(32, 0);
    public static final RecordFactory nodeRecordFactory = new RecordFactory(16, 8);

    FactoryGraphTDB() {
    }

    public static GraphTriplesTDB createGraph(IndexBuilder indexBuilder, Location location) {
        DatasetGraphTDB ds = FactoryGraphTDB._createDatasetGraph(indexBuilder, location, Names.tripleIndexes, Names.quadIndexes);
        return (GraphTriplesTDB)ds.getDefaultGraph();
    }

    public static GraphTriplesTDB createGraphMem(IndexBuilder indexBuilder) {
        return FactoryGraphTDB.createGraph(indexBuilder, Location.mem());
    }

    private static TupleIndex[] indexes(IndexBuilder indexBuilder, RecordFactory recordFactory, Location location, String primary, String ... descs) {
        TupleIndex[] indexes = new TupleIndex[descs.length];
        int i = 0;
        for (String desc : descs) {
            indexes[i] = FactoryGraphTDB.createTupleIndex(indexBuilder, recordFactory, location, primary, desc);
            ++i;
        }
        return indexes;
    }

    private static TripleTable createTripleTableMem(ConcurrencyPolicy policy) {
        NodeTable nodeTable = NodeTableFactory.createMem((IndexBuilder)IndexBuilder.mem());
        return FactoryGraphTDB.createTripleTable(IndexBuilder.mem(), nodeTable, Location.mem(), Names.tripleIndexes, policy);
    }

    private static TripleTable createTripleTable(IndexBuilder indexBuilder, NodeTable nodeTable, Location location, String[] descs, ConcurrencyPolicy policy) {
        TupleIndex[] indexes = FactoryGraphTDB.indexes(indexBuilder, indexRecordTripleFactory, location, "SPO", descs);
        return new TripleTable(indexes, nodeTable, policy);
    }

    private static QuadTable createQuadTableMem(ConcurrencyPolicy policy) {
        NodeTable nodeTable = NodeTableFactory.createMem((IndexBuilder)IndexBuilder.mem());
        return FactoryGraphTDB.createQuadTable(IndexBuilder.mem(), nodeTable, null, Names.tripleIndexes, policy);
    }

    private static QuadTable createQuadTable(IndexBuilder indexBuilder, NodeTable nodeTable, Location location, String[] descs, ConcurrencyPolicy policy) {
        TupleIndex[] indexes = FactoryGraphTDB.indexes(indexBuilder, indexRecordQuadFactory, location, "GSPO", descs);
        return new QuadTable(indexes, nodeTable, policy);
    }

    private static DatasetGraphTDB _createDatasetGraph(IndexBuilder indexBuilder, Location location, String[] graphIndexDesc, String[] quadIndexDesc) {
        ConcurrencyPolicyMRSW policy = new ConcurrencyPolicyMRSW();
        NodeTable nodeTable = NodeTableFactory.create((IndexBuilder)indexBuilder, (Location)location);
        TripleTable triples = FactoryGraphTDB.createTripleTable(indexBuilder, nodeTable, location, graphIndexDesc, (ConcurrencyPolicy)policy);
        QuadTable quads = FactoryGraphTDB.createQuadTable(indexBuilder, nodeTable, location, quadIndexDesc, (ConcurrencyPolicy)policy);
        DatasetPrefixesTDB prefixes = DatasetPrefixesTDB.create((IndexBuilder)indexBuilder, (Location)location, (ConcurrencyPolicy)policy);
        return new DatasetGraphTDB(triples, quads, (DatasetPrefixStorage)prefixes, FactoryGraphTDB.chooseOptimizer(location), location, null);
    }

    private static TupleIndex createTupleIndex(IndexBuilder indexBuilder, RecordFactory recordFactory, Location location, String primary, String desc) {
        FileSet fileset = new FileSet(location, desc);
        RangeIndex rIdx1 = indexBuilder.newRangeIndex(fileset, recordFactory);
        TupleIndexRecord tupleIndex = new TupleIndexRecord(desc.length(), new ColumnMap(primary, desc), recordFactory, rIdx1);
        return tupleIndex;
    }

    private static ReorderTransformation chooseOptimizer(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted((String)location.getPath("stats.opt"));
                TDB.logInfo.info("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            TDB.logInfo.info("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            TDB.logInfo.info("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultOptimizer;
        }
        if (reorder == null) {
            TDB.logInfo.warn("No BGP optimizer");
        }
        return reorder;
    }
}

