/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.graph.AbstractTestPrefixMapping2;
import com.hp.hpl.jena.tdb.ConfigTest;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.store.DatasetPrefixesTDB;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicy;
import com.hp.hpl.jena.tdb.sys.ConcurrencyPolicyMRSW;
import java.util.Map;
import org.junit.Test;
import org.openjena.atlas.lib.FileOps;

public class TestPrefixMappingTDB
extends AbstractTestPrefixMapping2 {
    static DatasetPrefixesTDB last = null;

    protected PrefixMapping create() {
        last = DatasetPrefixesTDB.testing();
        return this.view();
    }

    protected PrefixMapping view() {
        return last.getPrefixMapping();
    }

    @Test
    public void multiple1() {
        DatasetPrefixesTDB prefixes = DatasetPrefixesTDB.testing();
        PrefixMapping pmap1 = prefixes.getPrefixMapping();
        PrefixMapping pmap2 = prefixes.getPrefixMapping("http://graph/");
        pmap1.setNsPrefix("x", "http://foo/");
        TestPrefixMappingTDB.assertNull((Object)pmap2.getNsPrefixURI("x"));
        TestPrefixMappingTDB.assertNotNull((Object)pmap1.getNsPrefixURI("x"));
    }

    @Test
    public void multiple2() {
        DatasetPrefixesTDB prefixes = DatasetPrefixesTDB.testing();
        PrefixMapping pmap1 = prefixes.getPrefixMapping("http://graph/");
        PrefixMapping pmap2 = prefixes.getPrefixMapping("http://graph/");
        pmap1.setNsPrefix("x", "http://foo/");
        TestPrefixMappingTDB.assertNotNull((Object)pmap2.getNsPrefixURI("x"));
        TestPrefixMappingTDB.assertNotNull((Object)pmap1.getNsPrefixURI("x"));
    }

    @Test
    public void persistent1() {
        String dir = ConfigTest.getTestingDir();
        FileOps.clearDirectory((String)dir);
        DatasetPrefixesTDB prefixes = DatasetPrefixesTDB.create((Location)new Location(dir), (ConcurrencyPolicy)new ConcurrencyPolicyMRSW());
        PrefixMapping pmap1 = prefixes.getPrefixMapping();
        String x = pmap1.getNsPrefixURI("x");
        TestPrefixMappingTDB.assertNull((Object)x);
        prefixes.close();
    }

    @Test
    public void persistent2() {
        String dir = ConfigTest.getTestingDir();
        FileOps.clearDirectory((String)dir);
        DatasetPrefixesTDB prefixes = DatasetPrefixesTDB.create((Location)new Location(dir), (ConcurrencyPolicy)new ConcurrencyPolicyMRSW());
        PrefixMapping pmap1 = prefixes.getPrefixMapping();
        pmap1.setNsPrefix("x", "http://foo/");
        prefixes.close();
        prefixes = DatasetPrefixesTDB.create((Location)new Location(dir), (ConcurrencyPolicy)new ConcurrencyPolicyMRSW());
        TestPrefixMappingTDB.assertEquals((Object)"http://foo/", (Object)pmap1.getNsPrefixURI("x"));
        prefixes.close();
    }

    @Test
    public void persistent3() {
        String DB = ConfigTest.getTestingDirDB();
        FileOps.clearDirectory((String)DB);
        Graph graph = TDBFactory.createGraph((String)DB);
        PrefixMapping pm = graph.getPrefixMapping();
        pm.setNsPrefix("test", "http://test");
        graph.close();
        graph = TDBFactory.createGraph((String)DB);
        pm = graph.getPrefixMapping();
        Map map = pm.getNsPrefixMap();
        TestPrefixMappingTDB.assertEquals((long)1L, (long)map.size());
        String ns = pm.getNsPrefixURI("test");
        TestPrefixMappingTDB.assertEquals((Object)"http://test", (Object)ns);
        graph.close();
    }
}

