/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.ConfigTest;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.StringFile;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.FileOps;

public class TestStringFile
extends BaseTest {
    StringFile f = null;

    @Before
    public void setup() {
        String dir = ConfigTest.getTestingDir();
        FileOps.clearDirectory((String)dir);
        Location loc = new Location(dir);
        this.f = FileFactory.createStringFileDisk((String)loc.getPath("xyz", "node"));
    }

    @After
    public void teardown() {
        this.f.close();
        this.f = null;
    }

    @Test
    public void object_file_1() {
        String x1 = "abbbbbbc";
        String x2 = "\u5b6b\u5b50\u5175\u6cd5";
        long id1 = this.f.write(x1);
        long id2 = this.f.write(x2);
        TestStringFile.assertNotEquals((String)"Node Ids", (Object)id1, (Object)id2);
        this.test(id2, x2);
        this.test(id1, x1);
        this.test(0L, x1);
    }

    @Test
    public void object_file_2() {
        String x1 = "abbbbbbc";
        String x2 = "\u5b6b\u5b50\u5175\u6cd5";
        long id1 = this.f.write(x1);
        this.f.flush();
        long id2 = this.f.write(x2);
        TestStringFile.assertNotEquals((String)"Node Ids", (Object)id1, (Object)id2);
        String z = this.f.read(id2);
        this.test(id2, x2);
        this.test(id1, x1);
        this.test(0L, x1);
    }

    @Test
    public void object_file_3() {
        String x1 = "abbbbbbc";
        String x2 = "\u5b6b\u5b50\u5175\u6cd5";
        long id1 = this.f.write(x1);
        long id2 = this.f.write(x2);
        this.f.flush();
        TestStringFile.assertNotEquals((String)"Node Ids", (Object)id1, (Object)id2);
        this.test(id2, x2);
        this.test(id1, x1);
        this.test(0L, x1);
    }

    @Test
    public void object_file_4() {
        String x1 = "abbbbbbc";
        String x2 = "\u5b6b\u5b50\u5175\u6cd5";
        long id1 = this.f.write(x1);
        this.f.flush();
        long id2 = this.f.write(x2);
        this.f.flush();
        TestStringFile.assertNotEquals((String)"Node Ids", (Object)id1, (Object)id2);
        this.test(id2, x2);
        this.test(id1, x1);
        this.test(0L, x1);
    }

    private void test(long id, String x) {
        String y = this.f.read(id);
        TestStringFile.assertEquals((Object)x, (Object)y);
    }
}

