/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.ConfigTest;
import com.hp.hpl.jena.tdb.base.file.MetaFile;
import java.io.File;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class TestMetaFile
extends BaseTest {
    static String testfile = ConfigTest.getTestingDir() + "/file";
    static String testfileMeta = ConfigTest.getTestingDir() + "/file." + "info";

    @Before
    public void before() {
        File f = new File(testfileMeta);
        f.delete();
    }

    @Test
    public void meta1() {
        TestMetaFile.clear();
        MetaFile f = new MetaFile("META", testfile);
        TestMetaFile.assertFalse((boolean)new File(testfileMeta).exists());
        f.setProperty("key", "value");
        f.flush();
        TestMetaFile.assertTrue((boolean)new File(f.getFilename()).exists());
    }

    @Test
    public void meta2() {
        TestMetaFile.clear();
        MetaFile f = new MetaFile("META", testfile);
        f.setProperty("test.value1", "1");
        f.flush();
        MetaFile f2 = new MetaFile("META", testfile);
        TestMetaFile.assertEquals((Object)"1", (Object)f2.getProperty("test.value1"));
        TestMetaFile.assertNull((Object)f2.getProperty("test.value.other"));
    }

    @AfterClass
    public static void afterClass() {
        TestMetaFile.clear();
    }

    private static void clear() {
        File f = new File(testfileMeta);
        f.delete();
    }
}

