/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.buffer;

import com.hp.hpl.jena.tdb.base.buffer.BufferBase;
import com.hp.hpl.jena.tdb.base.buffer.BufferException;
import com.hp.hpl.jena.tdb.base.buffer.PtrBuffer;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.nio.ByteBuffer;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class TestPtrBuffer
extends BaseTest {
    @BeforeClass
    public static void before() {
        SystemTDB.NullOut = true;
    }

    @Test
    public void ptrbuffer01() {
        PtrBuffer pb = TestPtrBuffer.make(4);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
    }

    @Test
    public void ptrbuffer03() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftUp(0);
        pb.set(0, 99);
        TestPtrBuffer.contains(pb, 99, 2, 4, 6, 8);
        pb.shiftDown(0);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
    }

    @Test
    public void ptrbuffer04() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftDown(0);
        TestPtrBuffer.contains(pb, 4, 6, 8);
        pb.shiftUp(0);
        pb.set(0, 1);
        TestPtrBuffer.contains(pb, 1, 4, 6, 8);
    }

    @Test
    public void ptrbuffer05() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftUp(2);
        pb.set(2, 0);
        TestPtrBuffer.contains(pb, 2, 4, 0, 6, 8);
        pb.shiftDown(2);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
    }

    @Test
    public void ptrbuffer06() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftDown(2);
        TestPtrBuffer.contains(pb, 2, 4, 8);
        pb.shiftUp(2);
        TestPtrBuffer.assertTrue((boolean)pb.isClear(2));
        TestPtrBuffer.contains(pb, 2, 4, -1, 8);
    }

    @Test
    public void ptrbuffer07() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftUp(3);
        pb.set(3, 1);
        TestPtrBuffer.contains(pb, 2, 4, 6, 1, 8);
        pb.shiftDown(3);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
    }

    @Test
    public void ptrbuffer08() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftDown(3);
        TestPtrBuffer.contains(pb, 2, 4, 6);
        pb.shiftUp(2);
        TestPtrBuffer.contains(pb, 2, 4, -1, 6);
    }

    @Test(expected=BufferException.class)
    public void ptrbuffer09() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftDown(4);
    }

    @Test(expected=BufferException.class)
    public void ptrbuffer10() {
        PtrBuffer pb = TestPtrBuffer.make(4, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.shiftUp(4);
    }

    @Test(expected=BufferException.class)
    public void ptrbuffer11() {
        PtrBuffer pb = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8, 10);
        pb.add(12);
    }

    @Test
    public void ptrbuffer12() {
        PtrBuffer pb = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8, 10);
        PtrBuffer pb2 = pb.duplicate();
        pb2.set(1, 99);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8, 10);
        TestPtrBuffer.contains(pb2, 2, 99, 6, 8, 10);
    }

    @Test
    public void ptrbuffer13() {
        PtrBuffer pb = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8, 10);
        pb.clear(1, 3);
        TestPtrBuffer.contains(pb, 2, -1, -1, -1, 10);
    }

    @Test
    public void ptrbuffer14() {
        PtrBuffer pb = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8, 10);
        PtrBuffer pb2 = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb2, 2, 4, 6, 8, 10);
        pb.copy(0, (BufferBase)pb2, 1, 4);
        TestPtrBuffer.contains(pb2, 2, 2, 4, 6, 8);
    }

    @Test
    public void ptrbuffer15() {
        PtrBuffer pb = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb, 2, 4, 6, 8, 10);
        pb.removeTop();
        TestPtrBuffer.contains(pb, 2, 4, 6, 8);
        pb.remove(1);
        TestPtrBuffer.contains(pb, 2, 6, 8);
        pb.remove(2);
        TestPtrBuffer.contains(pb, 2, 6);
        pb.remove(0);
        TestPtrBuffer.contains(pb, 6);
        pb.remove(0);
        TestPtrBuffer.contains(pb, new int[0]);
    }

    @Test
    public void ptrbuffer20() {
        PtrBuffer pb1 = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb1, 2, 4, 6, 8, 10);
        PtrBuffer pb2 = TestPtrBuffer.make(0, 5);
        TestPtrBuffer.contains(pb2, new int[0]);
        pb1.shiftRight((BufferBase)pb2);
        TestPtrBuffer.contains(pb1, 2, 4, 6, 8);
        TestPtrBuffer.contains(pb2, 10);
    }

    @Test
    public void ptrbuffer21() {
        PtrBuffer pb1 = TestPtrBuffer.make(3, 5);
        TestPtrBuffer.contains(pb1, 2, 4, 6);
        PtrBuffer pb2 = TestPtrBuffer.make(0, 5);
        TestPtrBuffer.contains(pb2, new int[0]);
        pb1.shiftRight((BufferBase)pb2);
        TestPtrBuffer.contains(pb1, 2, 4);
        TestPtrBuffer.contains(pb2, 6);
    }

    @Test
    public void ptrbuffer22() {
        PtrBuffer pb1 = TestPtrBuffer.make(3, 5);
        TestPtrBuffer.contains(pb1, 2, 4, 6);
        PtrBuffer pb2 = TestPtrBuffer.make(2, 5);
        TestPtrBuffer.contains(pb2, 2, 4);
        pb1.shiftRight((BufferBase)pb2);
        TestPtrBuffer.contains(pb1, 2, 4);
        TestPtrBuffer.contains(pb2, 6, 2, 4);
    }

    @Test
    public void ptrbuffer24() {
        PtrBuffer pb1 = TestPtrBuffer.make(0, 5);
        TestPtrBuffer.contains(pb1, new int[0]);
        PtrBuffer pb2 = TestPtrBuffer.make(5, 5);
        TestPtrBuffer.contains(pb2, 2, 4, 6, 8, 10);
        pb1.shiftLeft((BufferBase)pb2);
        TestPtrBuffer.contains(pb1, 2);
        TestPtrBuffer.contains(pb2, 4, 6, 8, 10);
    }

    @Test
    public void ptrbuffer25() {
        PtrBuffer pb1 = TestPtrBuffer.make(0, 5);
        TestPtrBuffer.contains(pb1, new int[0]);
        PtrBuffer pb2 = TestPtrBuffer.make(3, 5);
        TestPtrBuffer.contains(pb2, 2, 4, 6);
        pb1.shiftLeft((BufferBase)pb2);
        TestPtrBuffer.contains(pb1, 2);
        TestPtrBuffer.contains(pb2, 4, 6);
    }

    @Test
    public void ptrbuffer26() {
        PtrBuffer pb1 = TestPtrBuffer.make(2, 5);
        TestPtrBuffer.contains(pb1, 2, 4);
        PtrBuffer pb2 = TestPtrBuffer.make(3, 5);
        TestPtrBuffer.contains(pb2, 2, 4, 6);
        pb1.shiftLeft((BufferBase)pb2);
        TestPtrBuffer.contains(pb1, 2, 4, 2);
        TestPtrBuffer.contains(pb2, 4, 6);
    }

    @Test
    public void ptrbuffer27() {
        PtrBuffer pb1 = TestPtrBuffer.make(2, 4);
        PtrBuffer pb2 = TestPtrBuffer.make(2, 4);
        pb1.copyToTop((BufferBase)pb2);
        TestPtrBuffer.contains(pb2, 2, 4, 2, 4);
    }

    @Test
    public void ptrbuffer28() {
        PtrBuffer pb1 = TestPtrBuffer.make(0, 5);
        PtrBuffer pb2 = TestPtrBuffer.make(2, 4);
        pb1.copyToTop((BufferBase)pb2);
        TestPtrBuffer.contains(pb2, 2, 4);
    }

    @Test
    public void ptrbuffer29() {
        PtrBuffer pb1 = TestPtrBuffer.make(0, 5);
        PtrBuffer pb2 = TestPtrBuffer.make(2, 4);
        pb2.copyToTop((BufferBase)pb1);
        TestPtrBuffer.contains(pb1, 2, 4);
    }

    private static void contains(PtrBuffer pb, int ... vals) {
        TestPtrBuffer.assertEquals((String)"Length mismatch: ", (long)vals.length, (long)pb.size());
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == -1) {
                TestPtrBuffer.assertTrue((boolean)pb.isClear(i));
                continue;
            }
            TestPtrBuffer.assertEquals((String)"Value mismatch: ", (long)vals[i], (long)pb.get(i));
        }
    }

    private static PtrBuffer make(int n) {
        return TestPtrBuffer.make(n, n);
    }

    private static PtrBuffer make(int n, int len) {
        ByteBuffer bb = ByteBuffer.allocate(4 * len);
        PtrBuffer pb = new PtrBuffer(bb, 0);
        for (int i = 0; i < n; ++i) {
            pb.add(2 + 2 * i);
        }
        return pb;
    }
}

