/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import java.nio.ByteBuffer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.ByteBufferLib;

public abstract class AbstractTestBlockMgr
extends BaseTest {
    public static final int BlkSize = 256;
    protected BlockMgr blockMgr = null;

    @Before
    public void before() {
        this.blockMgr = this.make();
    }

    @After
    public void after() {
        if (this.blockMgr != null) {
            this.blockMgr.close();
        }
    }

    @Test
    public void file01() {
        int id = this.blockMgr.allocateId();
        ByteBuffer bb = this.blockMgr.allocateBuffer(id);
        ByteBufferLib.fill((ByteBuffer)bb, (byte)1);
        this.blockMgr.put(id, bb);
    }

    @Test
    public void file02() {
        int id = this.blockMgr.allocateId();
        ByteBuffer bb = this.blockMgr.allocateBuffer(id);
        ByteBufferLib.fill((ByteBuffer)bb, (byte)1);
        this.blockMgr.put(id, bb);
        ByteBuffer bb2 = this.blockMgr.get(id);
        AbstractTestBlockMgr.assertEquals((long)bb2.capacity(), (long)256L);
        AbstractTestBlockMgr.assertEquals((long)bb2.get(0), (long)1L);
        AbstractTestBlockMgr.assertEquals((long)bb2.get(255), (long)1L);
    }

    @Test
    public void file03() {
        int id = this.blockMgr.allocateId();
        ByteBuffer bb = this.blockMgr.allocateBuffer(id);
        ByteBufferLib.fill((ByteBuffer)bb, (byte)2);
        this.blockMgr.put(id, bb);
        ByteBuffer bb2 = this.blockMgr.get(id);
        AbstractTestBlockMgr.assertEquals((long)bb2.capacity(), (long)256L);
        AbstractTestBlockMgr.assertEquals((long)bb2.get(0), (long)2L);
        AbstractTestBlockMgr.assertEquals((long)bb2.get(255), (long)2L);
    }

    @Test
    public void multiAccess01() {
        int id1 = this.blockMgr.allocateId();
        int id2 = this.blockMgr.allocateId();
        ByteBuffer bb1 = this.blockMgr.allocateBuffer(id1);
        ByteBuffer bb2 = this.blockMgr.allocateBuffer(id2);
        ByteBufferLib.fill((ByteBuffer)bb1, (byte)1);
        ByteBufferLib.fill((ByteBuffer)bb2, (byte)2);
        this.blockMgr.put(id1, bb1);
        this.blockMgr.put(id2, bb2);
        ByteBuffer bb_1 = this.blockMgr.get(id1);
        ByteBuffer bb_2 = this.blockMgr.get(id2);
        AbstractTestBlockMgr.contains(bb_1, (byte)1);
        AbstractTestBlockMgr.contains(bb_2, (byte)2);
    }

    protected abstract BlockMgr make();

    protected static void contains(ByteBuffer bb, byte fillValue) {
        for (int i = 0; i < bb.limit(); ++i) {
            AbstractTestBlockMgr.assertEquals((String)("Index: " + i), (long)bb.get(i), (long)fillValue);
        }
    }
}

