/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.assembler;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssemblerVocab;
import com.hp.hpl.jena.tdb.ConfigTest;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.FileOps;

public class TestTDBAssembler
extends BaseTest {
    static final String dirAssem = "testing/Assembler";
    static final String dirDB = ConfigTest.getTestingDir() + "/DB";

    @BeforeClass
    public static void beforeClass() {
        FileOps.ensureDir((String)dirDB);
    }

    @Before
    public void before() {
        FileOps.clearDirectory((String)dirDB);
    }

    @AfterClass
    public static void afterClass() {
        FileOps.clearDirectory((String)dirDB);
    }

    @Test
    public void createDatasetDirect() {
        String f = "testing/Assembler/tdb-dataset.ttl";
        Object thing = AssemblerUtils.build((String)f, (Resource)VocabTDB.tDatasetTDB);
        TestTDBAssembler.assertTrue((boolean)(thing instanceof Dataset));
        Dataset ds = (Dataset)thing;
        ds.asDatasetGraph();
        TestTDBAssembler.assertTrue((boolean)(((Dataset)thing).asDatasetGraph() instanceof DatasetGraphTDB));
        ds.close();
    }

    @Test
    public void createDatasetEmbed() {
        String f = "testing/Assembler/tdb-dataset-embed.ttl";
        Object thing = AssemblerUtils.build((String)f, (Resource)DatasetAssemblerVocab.tDataset);
        TestTDBAssembler.assertTrue((boolean)(thing instanceof Dataset));
        Dataset ds = (Dataset)thing;
        TestTDBAssembler.assertTrue((boolean)(ds.asDatasetGraph() instanceof DatasetGraphTDB));
        ds.close();
    }

    @Test
    public void createGraphDirect() {
        TestTDBAssembler.testGraph("testing/Assembler/tdb-graph.ttl", false);
    }

    @Test
    public void createGraphEmbed() {
        String f = "testing/Assembler/tdb-graph-embed.ttl";
        Object thing = null;
        try {
            thing = AssemblerUtils.build((String)f, (Resource)JA.Model);
        }
        catch (AssemblerException e) {
            e.getCause().printStackTrace(System.err);
            throw e;
        }
        TestTDBAssembler.assertTrue((boolean)(thing instanceof Model));
        Graph graph = ((Model)thing).getGraph();
        TestTDBAssembler.assertTrue((boolean)(graph instanceof GraphTDB));
        TestTDBAssembler.assertTrue((boolean)(graph instanceof GraphTriplesTDB));
        TestTDBAssembler.assertFalse((boolean)(graph instanceof GraphNamedTDB));
        DatasetGraphTDB ds = ((GraphTDBBase)graph).getDataset();
        if (ds != null) {
            ds.close();
        }
    }

    @Test
    public void createNamedGraph1() {
        TestTDBAssembler.testGraph("testing/Assembler/tdb-named-graph-1.ttl", true);
    }

    @Test
    public void createNamedGraph2() {
        TestTDBAssembler.testGraph("testing/Assembler/tdb-named-graph-2.ttl", true);
    }

    @Test
    public void createNamedGraphViaDataset() {
        TestTDBAssembler.testGraph("testing/Assembler/tdb-graph-ref-dataset.ttl", false);
    }

    private static void testGraph(String assemblerFile, boolean named) {
        Object thing = null;
        try {
            thing = AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tGraphTDB);
        }
        catch (AssemblerException e) {
            e.getCause().printStackTrace(System.err);
            throw e;
        }
        TestTDBAssembler.assertTrue((boolean)(thing instanceof Model));
        Graph graph = ((Model)thing).getGraph();
        TestTDBAssembler.assertTrue((boolean)(graph instanceof GraphTDB));
        if (named) {
            TestTDBAssembler.assertFalse((boolean)(graph instanceof GraphTriplesTDB));
            TestTDBAssembler.assertTrue((boolean)(graph instanceof GraphNamedTDB));
        } else {
            TestTDBAssembler.assertTrue((boolean)(graph instanceof GraphTriplesTDB));
            TestTDBAssembler.assertFalse((boolean)(graph instanceof GraphNamedTDB));
        }
        DatasetGraphTDB ds = ((GraphTDBBase)graph).getDataset();
        if (ds != null) {
            ds.close();
        }
    }
}

