/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader;

import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.store.bulkloader.BuilderSecondaryIndexes;
import com.hp.hpl.jena.tdb.store.bulkloader.LoadMonitor;
import com.hp.hpl.jena.tdb.store.bulkloader.LoaderNodeTupleTable;

class BuilderSecondaryIndexesInterleaved
implements BuilderSecondaryIndexes {
    private LoadMonitor monitor;

    BuilderSecondaryIndexesInterleaved(LoadMonitor monitor) {
        this.monitor = monitor;
    }

    public void createSecondaryIndexes(TupleIndex primaryIndex, TupleIndex[] secondaryIndexes) {
        Timer timer = new Timer();
        timer.startTimer();
        long time1 = timer.readTimer();
        LoaderNodeTupleTable.copyIndex(primaryIndex.all(), secondaryIndexes, "All", this.monitor);
        long time2 = timer.readTimer();
        this.monitor.print("Time for all indexes: %.2fs\n", (double)(time2 - time1) / 1000.0);
    }
}

