/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.migrate.A2;
import com.hp.hpl.jena.tdb.migrate.DynamicDatasets;
import com.hp.hpl.jena.tdb.migrate.NodeUtils2;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.Set;

public class QueryEngineTDB
extends QueryEngineMain {
    private Binding initialInput;
    private static final boolean DynamicDatasetByRewrite = false;
    private boolean doingDynamicDatasetBySpecialDataset = false;
    private static QueryEngineFactory factory = new QueryEngineFactoryTDB();

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory((QueryEngineFactory)factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory((QueryEngineFactory)factory);
    }

    protected QueryEngineTDB(Op op, DatasetGraphTDB dataset, Binding input, Context context) {
        super(op, (DatasetGraph)dataset, input, context);
        this.initialInput = input;
    }

    protected QueryEngineTDB(Query query2, DatasetGraphTDB dataset, Binding input, Context context) {
        super(query2, (DatasetGraph)dataset, input, context);
        if (query2.hasDatasetDescription()) {
            this.doingDynamicDatasetBySpecialDataset = true;
            DatasetGraph dsg = this.dataset;
            this.dataset = dsg = DynamicDatasets.dynamicDataset(query2, dsg, this.context.isTrue(TDB.symUnionDefaultGraph));
        }
        this.initialInput = input;
    }

    protected Op modifyOp(Op op) {
        op = Substitute.substitute((Op)op, (Binding)this.initialInput);
        op = super.modifyOp(op);
        if (!this.doingDynamicDatasetBySpecialDataset) {
            op = Algebra.toQuadForm((Op)op);
        }
        this.setOp(op);
        return op;
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context) {
        if (context.isTrue(TDB.symUnionDefaultGraph) && !this.doingDynamicDatasetBySpecialDataset) {
            op = A2.unionDefaultGraphQuads(op);
            DatasetGraphTDB ds = ((DatasetGraphTDB)dsg).duplicate();
            ds.setEffectiveDefaultGraph(new GraphNamedTDB(ds, Quad.unionGraph));
            dsg = ds;
        }
        return super.eval(op, dsg, input, context);
    }

    public long getMillis() {
        return -1L;
    }

    private static void dynamicDatasetQE(Query query2, Context context) {
        if (query2.hasDatasetDescription()) {
            Set<Node> defaultGraphs = NodeUtils2.convertToNodes(query2.getGraphURIs());
            Set<Node> namedGraphs = NodeUtils2.convertToNodes(query2.getNamedGraphURIs());
            context.set(SystemTDB.symDatasetDefaultGraphs, defaultGraphs);
            context.set(SystemTDB.symDatasetNamedGraphs, namedGraphs);
        }
    }

    private static class QueryEngineFactoryTDB
    implements QueryEngineFactory {
        private QueryEngineFactoryTDB() {
        }

        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphTDB;
        }

        public Plan create(Query query2, DatasetGraph ds, Binding input, Context context) {
            DatasetGraphTDB dataset = (DatasetGraphTDB)ds;
            QueryEngineTDB.dynamicDatasetQE(query2, context);
            QueryEngineTDB engine = new QueryEngineTDB(query2, dataset, input, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return dataset instanceof DatasetGraphTDB;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineTDB engine = new QueryEngineTDB(op, (DatasetGraphTDB)dataset, binding, context);
            return engine.getPlan();
        }
    }
}

