/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.tdb.base.buffer.PtrBuffer;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.btree.BTree;
import com.hp.hpl.jena.tdb.index.btree.BTreeException;
import com.hp.hpl.jena.tdb.index.btree.BTreePageMgr;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;
import com.hp.hpl.jena.tdb.index.btree.BTreeRangeIterator;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeNode {
    private static Logger log = LoggerFactory.getLogger(BTreeNode.class);
    BTree bTree;
    BTreeParams bTreeParams;
    BTreePageMgr pageMgr;
    ByteBuffer byteBuffer;
    boolean isLeaf;
    int count;
    int id;
    int parent;
    RecordBuffer records;
    PtrBuffer ptrs;
    static final boolean DUP_CHECK = false;

    private BTreeNode create(int parent, boolean asLeaf) {
        BTreeNode n = this.pageMgr.create(parent, asLeaf);
        return n;
    }

    BTreeNode(BTree bTree, int id, ByteBuffer bb) {
        this.id = id;
        if (bTree == null) {
            System.err.println("NULL btree");
        }
        this.bTree = bTree;
        this.bTreeParams = bTree.getParams();
        this.pageMgr = bTree.getPageMgr();
        this.byteBuffer = bb;
        this.count = -1;
    }

    private BTreeNode getNode(int idx) {
        int ptr = this.ptrs.get(idx);
        return this.pageMgr.get(ptr, this.id);
    }

    public final int getCount() {
        return this.count;
    }

    public int getId() {
        return this.id;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public Record search(Record rec) {
        if (BTreeParams.CheckingNode) {
            this.internalCheckNodeDeep();
        }
        if (this.id != 0) {
            throw new BTreeException("Search not starting from the root: " + this);
        }
        return this._search(rec);
    }

    public Record insert(Record record) {
        if (BTreeNode.logging()) {
            log.debug(String.format("** insert(%s) / start", record));
            if (BTreeParams.DumpTree) {
                this.dump();
            }
        }
        Object x = null;
        if (!this.isRoot()) {
            throw new BTreeException("Insert begins but this is not the root");
        }
        if (this.isFull()) {
            this.splitRoot();
        }
        Record result = this.insertNonFull(record);
        this.internalCheckNodeDeep();
        if (BTreeNode.logging()) {
            log.debug(String.format("** insert(%s) / finish", record));
            if (BTreeParams.DumpTree) {
                this.dump();
            }
        }
        return result;
    }

    public Record delete(Record rec) {
        if (BTreeNode.logging()) {
            log.debug(String.format("** delete(%s) / start", rec));
            if (BTreeParams.DumpTree) {
                this.dump();
            }
        }
        if (!this.isRoot()) {
            throw new BTreeException("Delete begins but this is not the root");
        }
        Record v = this._delete(rec);
        if (!this.isLeaf && this.count == 0) {
            this.reduceRoot();
        }
        this.internalCheckNodeDeep();
        if (BTreeNode.logging()) {
            log.debug(String.format("** delete(%s) / finish", rec));
            if (BTreeParams.DumpTree) {
                this.dump();
            }
        }
        return v;
    }

    public Record maxRecord() {
        BTreeNode n;
        if (BTreeNode.logging()) {
            log.debug("maxRecord");
        }
        if ((n = this.maxNode()) == null) {
            return null;
        }
        return n.records.get(n.count - 1);
    }

    public Record minRecord() {
        BTreeNode n;
        if (BTreeNode.logging()) {
            log.debug("minRecord");
        }
        if ((n = this.minNode()) == null) {
            return null;
        }
        return n.records.get(0);
    }

    public long sizeByCounting() {
        long x = this.count;
        if (!this.isLeaf) {
            for (int i = 0; i <= this.count; ++i) {
                BTreeNode n = this.getNode(i);
                x += n.sizeByCounting();
            }
        }
        return x;
    }

    private Record _search(Record rec) {
        int x = this.findSlot(rec);
        if (x >= 0) {
            return this.records.get(x);
        }
        if (this.isLeaf) {
            return null;
        }
        x = -(x + 1);
        BTreeNode n = this.getNode(x);
        return n._search(rec);
    }

    private BTreeNode minNode() {
        BTreeNode n = this;
        while (!n.isLeaf) {
            n = n.getNode(0);
        }
        if (n.count == 0) {
            return null;
        }
        return n;
    }

    private BTreeNode maxNode() {
        BTreeNode n = this;
        while (!n.isLeaf) {
            n = n.getNode(n.count);
        }
        if (n.count == 0) {
            return null;
        }
        return n;
    }

    private Record insertNonFull(Record record) {
        int i;
        if (BTreeParams.CheckingNode) {
            this.internalCheckNode();
        }
        if ((i = this.findSlot(record)) >= 0) {
            return this.updateExisting(i, record);
        }
        i = -(i + 1);
        if (this.isLeaf) {
            if (BTreeParams.CheckingNode && this.isFull()) {
                this.error("Node is full", new Object[0]);
            }
            this.records.add(i, record);
            ++this.count;
            this.pageMgr.put(this);
            return null;
        }
        BTreeNode n = this.getNode(i);
        if (n.isFull()) {
            this.split(i, n);
            int cmp = Record.compareByKey(record, this.records.get(i));
            if (cmp == 0) {
                return this.updateExisting(i, record);
            }
            if (cmp > 0) {
                n = this.getNode(++i);
            }
            if (BTreeParams.CheckingNode) {
                n.internalCheckNodeDeep();
            }
        }
        return n.insertNonFull(record);
    }

    private Record updateExisting(int i, Record record) {
        Record r = this.records.get(i);
        if (record.hasSeparateValue() && !r.equals(record)) {
            this.records.set(i, record);
            this.pageMgr.put(this);
        }
        return r;
    }

    private void split(int idx, BTreeNode y) {
        if (BTreeNode.logging()) {
            log.debug(String.format("Split(Parent %d[%d], Node %d)", this.id, idx, y.id));
        }
        this.internalCheckNode();
        if (BTreeParams.CheckingNode) {
            if (y.id == 0) {
                this.error("Splitting root in non-root split routine", new Object[0]);
            }
            if (y.count != this.maxRecords()) {
                this.error("Node is not full (by count)", new Object[0]);
            }
            if (this.ptrs.get(idx) != y.id) {
                this.error("Node to be split isn't in right place", new Object[0]);
            }
        }
        int ix = this.bTreeParams.SplitIndex;
        Record split = y.records.get(ix);
        if (BTreeNode.logging()) {
            log.debug(String.format("** Split: Parent: %d[%d]", this.id, idx));
            log.debug(String.format("** Split: %d=(%s) in node %d", ix, split, y.id));
            log.debug("split >>   " + this);
            log.debug("split >>   " + y);
        }
        BTreeNode z = this.create(this.id, y.isLeaf);
        int maxRec = this.maxRecords();
        y.records.copy(ix + 1, z.records, 0, maxRec - (ix + 1));
        y.records.clear(ix, maxRec - ix);
        y.records.setSize(ix);
        if (!y.isLeaf) {
            y.ptrs.copy(ix + 1, z.ptrs, 0, this.bTreeParams.MaxPtr - (ix + 1));
            y.ptrs.clear(ix + 1, this.bTreeParams.MaxPtr - (ix + 1));
            y.ptrs.setSize(ix + 1);
        }
        y.count = ix;
        y.internalCheckNode();
        z.count = maxRec - (ix + 1);
        z.internalCheckNode();
        this.shuffleUp(idx);
        this.records.set(idx, split);
        this.ptrs.set(idx + 1, z.id);
        if (BTreeParams.DumpTree && BTreeNode.logging()) {
            log.debug("split <<   " + this);
            log.debug("split <<   " + y);
            log.debug("split <<   " + z);
        }
        this.pageMgr.put(y);
        this.pageMgr.put(z);
        this.pageMgr.put(this);
    }

    private void splitRoot() {
        if (BTreeParams.CheckingNode && this.id != 0) {
            this.error("Not root: %d (root is id zero)", this.id);
        }
        this.internalCheckNode();
        Record rec = this.records.get(this.bTreeParams.SplitIndex);
        if (BTreeParams.DumpTree && BTreeNode.logging()) {
            log.debug(String.format("** Split root %d (%s)", this.bTreeParams.SplitIndex, rec));
            log.debug("splitRoot >>   " + this);
        }
        BTreeNode left = this.create(this.id, this.isLeaf);
        BTreeNode right = this.create(this.id, this.isLeaf);
        this.records.copy(0, left.records, 0, this.bTreeParams.SplitIndex);
        if (!this.isLeaf) {
            this.ptrs.copy(0, left.ptrs, 0, this.bTreeParams.SplitIndex + 1);
        }
        left.count = this.bTreeParams.SplitIndex;
        this.records.copy(this.bTreeParams.SplitIndex + 1, right.records, 0, this.maxRecords() - (this.bTreeParams.SplitIndex + 1));
        if (!this.isLeaf) {
            this.ptrs.copy(this.bTreeParams.SplitIndex + 1, right.ptrs, 0, this.bTreeParams.MaxPtr - (this.bTreeParams.SplitIndex + 1));
        }
        right.count = this.maxRecords() - (this.bTreeParams.SplitIndex + 1);
        BTreePageMgr.formatForRoot(this, false);
        this.count = 1;
        this.records.add(0, rec);
        this.ptrs.add(left.id);
        this.ptrs.add(right.id);
        if (BTreeNode.logging()) {
            log.debug("splitRoot <<   " + this);
            log.debug("splitRoot <<   " + left);
            log.debug("splitRoot <<   " + right);
        }
        if (BTreeParams.CheckingNode) {
            this.internalCheckNode();
            left.internalCheckNode();
            right.internalCheckNode();
        }
        this.pageMgr.put(left);
        this.pageMgr.put(right);
        this.pageMgr.put(this);
    }

    private Record _delete(Record rec) {
        int x;
        this.internalCheckNode();
        if (BTreeNode.logging()) {
            log.debug(String.format("_delete(%s) : %s", rec, this));
        }
        if ((x = this.findSlot(rec)) >= 0) {
            Record r = this.records.get(x);
            if (this.isLeaf) {
                this.deleteFromLeaf(x);
            } else {
                this.deleteFromInternal(rec, x);
            }
            return r;
        }
        if (BTreeNode.logging()) {
            log.debug("Record not found");
        }
        if (this.isLeaf) {
            if (BTreeNode.logging()) {
                log.debug("No such record");
            }
            return Record.NO_REC;
        }
        x = -(x + 1);
        BTreeNode n = this.getNode(x);
        if (n.count == this.bTreeParams.MinRec) {
            n = this.rebalance(n, x);
            this.internalCheckNode();
            n.internalCheckNode();
        }
        return n._delete(rec);
    }

    private void reduceRoot() {
        if (BTreeNode.logging()) {
            log.debug(String.format("reduceRoot >> %s", this));
        }
        if (BTreeParams.CheckingNode && (!this.isRoot() || this.count != 0)) {
            this.error("Not an empty root", new Object[0]);
        }
        if (this.isLeaf) {
            if (BTreeNode.logging()) {
                log.debug(String.format("reduceRoot << leaf root", new Object[0]));
            }
            return;
        }
        BTreeNode n = this.getNode(0);
        BTreePageMgr.formatForRoot(this, n.isLeaf);
        n.records.copy(0, this.records, 0, n.count);
        if (!this.isLeaf) {
            n.ptrs.copy(0, this.ptrs, 0, n.count + 1);
        }
        this.count = n.count;
        this.pageMgr.put(this);
        this.pageMgr.release(n.id);
        if (BTreeNode.logging()) {
            log.debug(String.format("reduceRoot << %s", this));
        }
    }

    private BTreeNode rebalance(BTreeNode n, int idx) {
        if (BTreeNode.logging()) {
            log.debug(String.format("rebalance(id=%d, %d)", n.id, idx));
            log.debug(String.format(">> %s", n));
        }
        this.internalCheckNode();
        if (BTreeParams.CheckingNode && n.count != this.bTreeParams.MinRec) {
            this.error("Node not minimal size in rebalance", new Object[0]);
        }
        BTreeNode left = null;
        if (idx > 0) {
            left = this.getNode(idx - 1);
        }
        if (left != null && left.count > this.bTreeParams.MinRec) {
            if (BTreeNode.logging()) {
                log.debug("rebalance/shiftRight");
            }
            this.shiftRight(left, n, idx - 1);
            this.pageMgr.put(left);
            this.pageMgr.put(n);
            this.pageMgr.put(this);
            if (BTreeNode.logging()) {
                log.debug("rebalance<<");
            }
            if (BTreeParams.CheckingNode) {
                left.internalCheckNode();
                n.internalCheckNode();
                this.internalCheckNode();
            }
            return n;
        }
        BTreeNode right = null;
        if (idx < this.count) {
            right = this.getNode(idx + 1);
        }
        if (right != null && right.count > this.bTreeParams.MinRec) {
            if (BTreeNode.logging()) {
                log.debug("rebalance/shiftLeft");
            }
            this.shiftLeft(n, right, idx);
            this.pageMgr.put(right);
            this.pageMgr.put(n);
            this.pageMgr.put(this);
            if (BTreeNode.logging()) {
                log.debug("rebalance<<");
            }
            if (BTreeParams.CheckingNode) {
                right.internalCheckNode();
                n.internalCheckNode();
                this.internalCheckNode();
            }
            if (BTreeNode.logging()) {
                log.debug("rebalance<<");
            }
            return n;
        }
        if (BTreeParams.CheckingNode && left == null && right == null) {
            this.error("No siblings", new Object[0]);
        }
        Object newNode = null;
        if (left != null) {
            if (BTreeNode.logging()) {
                log.debug(String.format("rebalance/merge/left: left=%d n=%d [%d]", left.id, n.id, idx - 1));
            }
            if (BTreeParams.CheckingNode && left.id == n.id) {
                this.error("Left and n the same", new Object[0]);
            }
            return this.merge(left, n, idx - 1);
        }
        if (BTreeNode.logging()) {
            log.debug(String.format("rebalance/merge/right: n=%d right=%d [%d]", n.id, right.id, idx));
        }
        if (BTreeParams.CheckingNode && right.id == n.id) {
            this.error("N and right the same", new Object[0]);
        }
        return this.merge(n, right, idx);
    }

    private void deleteFromLeaf(int x) {
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteFromLeaf(%s, %d)", this.records.get(x), x));
            log.debug(String.format("deleteFromLeaf >> %s", this));
        }
        this.internalCheckNode();
        this.shuffleDown(x);
        this.pageMgr.put(this);
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteFromLeaf << %s", this));
        }
    }

    private void deleteFromInternal(Record rec, int x) {
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteFromInternal(%s, %d)", rec, x));
            log.debug(String.format("deleteFromInternal >> %s", this));
        }
        this.internalCheckNode();
        BTreeNode left = this.getNode(x);
        if (left.count > this.bTreeParams.MinRec) {
            if (BTreeNode.logging()) {
                log.debug("deleteFromInternal/left");
            }
            this.deleteHigh(left, x);
            return;
        }
        BTreeNode right = this.getNode(x + 1);
        if (right.count > this.bTreeParams.MinRec) {
            if (BTreeNode.logging()) {
                log.debug("deleteFromInternal/right");
            }
            this.deleteLow(right, x);
            return;
        }
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteFromInternal/merge(%d, %d, [%d])", left.id, right.id, x));
        }
        BTreeNode sub = this.merge(left, right, x);
        sub._delete(rec);
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteFromInternal<< %s", this));
        }
    }

    private void deleteHigh(BTreeNode subTree, int origIdx) {
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteHigh(,%d) >> %s", origIdx, this));
        }
        BTreeNode n = BTreeNode.subTreeLeft(subTree);
        Record rec = n.records.get(n.count - 1);
        n.deleteFromLeaf(n.count - 1);
        this.records.set(origIdx, rec);
        this.pageMgr.put(this);
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteHigh(,%d) << %s", origIdx, this));
        }
    }

    private static BTreeNode subTreeLeft(BTreeNode subTree) {
        BTreeNode n = subTree;
        while (!n.isLeaf) {
            BTreeNode n2 = n.getNode(n.count);
            if (n2.count == n2.bTreeParams.MinRec) {
                n2 = n.rebalance(n2, n.count);
                n.internalCheckNode();
                n2.internalCheckNode();
            }
            n = n2;
        }
        return n;
    }

    private void deleteLow(BTreeNode subTree, int origIdx) {
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteLow(,%d) >> %s", origIdx, this));
        }
        BTreeNode n = BTreeNode.subTreeRight(subTree);
        Record rec = n.records.get(0);
        n.deleteFromLeaf(0);
        this.records.set(origIdx, rec);
        this.pageMgr.put(this);
        if (BTreeNode.logging()) {
            log.debug(String.format("deleteLow(,%d) << %s", origIdx, this));
        }
    }

    private static BTreeNode subTreeRight(BTreeNode subTree) {
        BTreeNode n = subTree;
        while (!n.isLeaf) {
            BTreeNode n2 = n.getNode(0);
            if (n2.count == n2.bTreeParams.MinRec) {
                n2 = n.rebalance(n2, 0);
                n.internalCheckNode();
                n2.internalCheckNode();
            }
            n = n2;
        }
        return n;
    }

    private BTreeNode merge(BTreeNode left, BTreeNode right, int dividingSlot) {
        int size;
        if (BTreeNode.logging()) {
            log.debug(String.format("merge(,,%d) ", dividingSlot));
            if (BTreeParams.DumpTree) {
                log.debug(String.format("merge >> %s", this));
                log.debug(String.format("merge >> %s", left));
                log.debug(String.format("merge >> %s", right));
            }
        }
        if (BTreeParams.CheckingNode) {
            if (left.count != this.bTreeParams.MinRec) {
                this.error("Left node is not min sized", new Object[0]);
            }
            if (right.count != this.bTreeParams.MinRec) {
                this.error("Right node is not min sized", new Object[0]);
            }
            if (this.ptrs.get(dividingSlot) != left.id) {
                this.error("Left node not as expected", new Object[0]);
            }
            if (this.ptrs.get(dividingSlot + 1) != right.id) {
                this.error("Right node not as expected", new Object[0]);
            }
            if (left.isLeaf != right.isLeaf) {
                this.error("Left and right nodes not of the same leaf-ness", new Object[0]);
            }
        }
        this.internalCheckNode();
        BTreeNode n = this.create(this.id, left.isLeaf);
        left.records.copy(0, n.records, 0, left.count);
        if (!n.isLeaf) {
            left.ptrs.copy(0, n.ptrs, 0, left.count + 1);
        }
        int idx = left.count;
        Record medianRec = this.records.get(dividingSlot);
        n.records.add(medianRec);
        right.records.copy(0, n.records, idx + 1, right.count);
        if (!right.isLeaf) {
            right.ptrs.copy(0, n.ptrs, idx + 1, right.count + 1);
        }
        n.count = size = left.count + right.count + 1;
        if (BTreeParams.CheckingNode && size != this.maxRecords()) {
            this.error("Inconsistent node size: %d", size);
        }
        this.shuffleDown(dividingSlot);
        this.ptrs.set(dividingSlot, n.id);
        this.pageMgr.release(left.id);
        this.pageMgr.release(right.id);
        if (BTreeParams.CheckingNode && this.findSlot(medianRec) >= 0) {
            this.error("Can still find record in parent of merge blocks", new Object[0]);
        }
        this.pageMgr.put(n);
        this.pageMgr.put(this);
        if (BTreeNode.logging()) {
            log.debug(String.format("merge << %s", this));
            log.debug(String.format("merge << %s", n));
        }
        this.internalCheckNode();
        n.internalCheckNode();
        return n;
    }

    private void shiftRight(BTreeNode left, BTreeNode right, int idx) {
        if (BTreeNode.logging()) {
            log.debug(String.format("shiftRight(%d, %d)", left.id, right.id));
            log.debug(String.format("shiftRight >> %s", this));
            log.debug(String.format("shiftRight >> %s", left));
            log.debug(String.format("shiftRight >> %s", right));
        }
        if (BTreeParams.CheckingNode) {
            if (left.count <= this.bTreeParams.MinRec) {
                this.error("Left too small to rotate a record out", new Object[0]);
            }
            if (right.count >= this.maxRecords()) {
                this.error("Right too large to rotate a record into", new Object[0]);
            }
            if (this.ptrs.get(idx) != left.id) {
                this.error("Index is not of the left in shiftRight", new Object[0]);
            }
            if (this.ptrs.get(idx + 1) != right.id) {
                this.error("Index is not of the right in shiftRight", new Object[0]);
            }
        }
        Record rec1 = this.records.get(idx);
        right.records.add(0, rec1);
        if (!right.isLeaf) {
            int ptr1 = left.ptrs.get(left.count);
            right.ptrs.add(0, ptr1);
        }
        ++right.count;
        Record rec2 = left.records.get(left.count - 1);
        left.records.removeTop();
        if (!left.isLeaf) {
            left.ptrs.removeTop();
        }
        --left.count;
        this.records.set(idx, rec2);
        if (BTreeParams.DumpTree && BTreeNode.logging()) {
            log.debug(String.format("shiftRight << %s", this));
            log.debug(String.format("shiftRight << %s", left));
            log.debug(String.format("shiftRight << %s", right));
        }
    }

    private void shiftLeft(BTreeNode left, BTreeNode right, int idx) {
        if (BTreeNode.logging()) {
            log.debug(String.format("shiftLeft(%d, %d, [%d])", left.id, right.id, idx));
            log.debug(String.format("shiftLeft >> %s", this));
            log.debug(String.format("shiftLeft >> %s", left));
            log.debug(String.format("shiftLeft >> %s", right));
        }
        if (BTreeParams.CheckingNode) {
            if (right.count <= this.bTreeParams.MinRec) {
                this.error("Right too small to rotate a record out", new Object[0]);
            }
            if (left.count >= this.maxRecords()) {
                this.error("Left too large to rotate a record into", new Object[0]);
            }
            if (this.ptrs.get(idx) != left.id) {
                this.error("Index is not of the left in shiftLeft", new Object[0]);
            }
            if (this.ptrs.get(idx + 1) != right.id) {
                this.error("Index is not of the right in shiftLeft", new Object[0]);
            }
        }
        Record rec1 = this.records.get(idx);
        left.records.add(left.count, rec1);
        if (!right.isLeaf) {
            int ptr1 = right.ptrs.get(0);
            left.ptrs.add(left.count + 1, ptr1);
        }
        ++left.count;
        Record rec2 = right.records.get(0);
        right.shuffleDown(0);
        this.records.set(idx, rec2);
        if (BTreeNode.logging()) {
            log.debug(String.format("shiftLeft << %s", this));
            log.debug(String.format("shiftLeft << %s", left));
            log.debug(String.format("shiftLeft << %s", right));
        }
        left.internalCheckNode();
        right.internalCheckNode();
        this.internalCheckNode();
    }

    private void shuffleUp(int i) {
        if (BTreeNode.logging()) {
            log.debug(String.format("shuffleUp: i=%d count=%d MaxRec=%d", i, this.count, this.maxRecords()));
            log.debug("shuffleUp >> " + this);
        }
        this.internalCheckNode();
        if (i == this.count) {
            if (BTreeNode.logging()) {
                log.debug("shuffleUp << No op");
            }
            this.records.incSize();
            if (!this.isLeaf) {
                this.ptrs.incSize();
            }
            ++this.count;
            return;
        }
        if (BTreeParams.CheckingNode && i > this.count) {
            this.error("shuffleUp: out of bounds: %d :: %s", i, this);
        }
        ++this.count;
        this.records.shiftUp(i);
        if (!this.isLeaf) {
            this.ptrs.shiftUp(i + 1);
        }
        if (BTreeNode.logging()) {
            log.debug("shuffleUp << " + this);
        }
    }

    private void shuffleAllUp() {
        if (BTreeNode.logging()) {
            log.debug("shuffleAllUp >> " + this);
        }
        ++this.count;
        this.records.shiftUp(0);
        if (!this.isLeaf) {
            this.ptrs.shiftUp(0);
        }
        if (BTreeNode.logging()) {
            log.debug("shuffleAllUp << " + this);
        }
    }

    private void shuffleDown(int x) {
        if (BTreeNode.logging()) {
            log.debug(String.format("ShuffleDown: i=%d count=%d MaxRec=%d", x, this.count, this.maxRecords()));
            log.debug("shuffleDown >> " + this);
        }
        if (BTreeParams.CheckingNode && x >= this.count) {
            this.error("shuffleDown out of bounds", new Object[0]);
        }
        if (x == this.count - 1) {
            this.records.removeTop();
            if (!this.isLeaf) {
                this.ptrs.removeTop();
            }
            --this.count;
            if (BTreeNode.logging()) {
                log.debug("shuffleDown << Clear top");
                log.debug("shuffleDown << " + this);
            }
            this.internalCheckNode();
            return;
        }
        this.records.shiftDown(x);
        if (!this.isLeaf) {
            this.ptrs.shiftDown(x);
        }
        --this.count;
        if (BTreeNode.logging()) {
            log.debug("shuffleDown << " + this);
        }
        this.internalCheckNode();
    }

    final int findSlot(Record rec) {
        return this.records.find(rec);
    }

    private final boolean isRoot() {
        return this.bTree.root == this;
    }

    private final int maxRecords() {
        return this.isLeaf ? this.bTreeParams.MaxRecLeaf : this.bTreeParams.MaxRecNonLeaf;
    }

    private final boolean isFull() {
        if (BTreeParams.CheckingNode && this.count > this.maxRecords()) {
            this.error("isFull: Moby block: %s", this);
        }
        return this.count == this.maxRecords();
    }

    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        return BTreeRangeIterator.iterator(this, fromRec, toRec);
    }

    public Iterator<Record> iterator() {
        return BTreeRangeIterator.iterator(this);
    }

    private static final boolean logging() {
        return BTreeParams.Logging && log.isDebugEnabled();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isLeaf) {
            b.append("LEAF: ");
        } else {
            b.append("NODE: ");
        }
        String parentStr = "??";
        if (this.parent >= 0) {
            parentStr = Integer.toString(this.parent);
        } else if (this.parent == -2) {
            parentStr = "root";
        }
        b.append(String.format("%d [%s] (size %d) -- ", this.id, parentStr, this.count));
        if (this.isLeaf) {
            for (int i = 0; i < this.maxRecords(); ++i) {
                if (i != 0) {
                    b.append(" ");
                }
                b.append("(");
                b.append(this.recstr(this.records, i));
                b.append(")");
            }
        } else {
            for (int i = 0; i < this.maxRecords(); ++i) {
                b.append(this.childStr(i));
                b.append(" (");
                b.append(this.recstr(this.records, i));
                b.append(") ");
            }
            b.append(this.childStr(this.bTreeParams.HighPtr));
        }
        return b.toString();
    }

    private final String recstr(RecordBuffer records, int idx) {
        if (records.isClear(idx)) {
            return "----";
        }
        Record r = records._get(idx);
        return r.toString();
    }

    public void dump() {
        this.dump(System.out, 0);
    }

    public String dumpToString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream x = new PrintStream(out);
        this.dump(x, 0);
        x.flush();
        return out.toString();
    }

    public void dump(PrintStream out, int level) {
        this.indent(out, level);
        System.out.print(this.toString());
        System.out.println();
        ++level;
        if (!this.isLeaf) {
            for (int i = 0; i < this.count + 1; ++i) {
                int c = this.ptrs.get(i);
                BTreeNode n = this.pageMgr.get(c, this.id);
                n.dump(out, level);
            }
        }
    }

    private void indent(PrintStream out, int x) {
        for (int i = 0; i < x; ++i) {
            out.print("  ");
        }
    }

    private String childStr(int i) {
        if (i >= this.ptrs.size()) {
            return "*";
        }
        int x = this.ptrs.get(i);
        return Integer.toString(x);
    }

    final void internalCheckNode() {
        if (BTreeParams.CheckingNode) {
            this.checkNode(null, null);
        }
    }

    private final void checkNode(Record min, Record max) {
        int i;
        if (this.count != this.records.size()) {
            this.error("Inconsistent: id=%d, count=%d, records.size()=%d : %s", this.id, this.count, this.records.size(), this);
        }
        if (!this.isLeaf && this.count + 1 != this.ptrs.size()) {
            this.error("Inconsistent: id=%d, count+1=%d, ptrs.size()=%d ; %s", this.id, this.count + 1, this.ptrs.size(), this);
        }
        if (this.bTree.root != null && !this.isRoot() && this.count < this.bTreeParams.MinRec) {
            this.isRoot();
            this.error("Runt node: %s", this);
        }
        if (!this.isRoot() && this.count > this.maxRecords()) {
            this.error("Over full node: %s", this);
        }
        if (this.parent == this.id) {
            this.error("Parent same as id: %s", this);
        }
        Record k = min;
        for (i = 0; i < this.count; ++i) {
            if (this.records.get(i) == null) {
                this.error("Node: %d : Invalid record @%d :: %s", this.id, i, this);
            }
            if (k != null && Record.keyGE(k, this.records.get(i))) {
                Record r = this.records.get(i);
                this.error("Node: %d: Not sorted (%d) (%s, %s) :: %s ", this.id, i, k, r, this);
            }
            k = this.records.get(i);
        }
        if (k != null && max != null && Record.keyGE(k, max)) {
            this.error("Node: %d - Record is too high (max=%s):: %s", this.id, max, this);
        }
        if (SystemTDB.NullOut) {
            for (i = this.count; i < this.maxRecords(); ++i) {
                if (this.records.isClear(i)) continue;
                this.error("Node: %d - not clear (idx=%d) :: %s", this.id, i, this);
            }
        }
        if (SystemTDB.NullOut) {
            if (!this.isLeaf) {
                for (i = 0; i < this.count + 1; ++i) {
                    if (this.ptrs.get(i) > 0) continue;
                    this.error("Node: %d: Invalid child pointer @%d :: %s", this.id, i, this);
                }
                while (i < this.bTreeParams.MaxPtr) {
                    if (!this.ptrs.isClear(i)) {
                        this.ptrs.isClear(i);
                        this.error("Node: %d: Unexpected pointer @%d :: %s", this.id, i, this);
                    }
                    ++i;
                }
            }
        }
    }

    private final void internalCheckNodeDeep() {
        if (!BTreeParams.CheckingNode) {
            return;
        }
        this.checkNodeDeep();
    }

    public final void checkNodeDeep() {
        if (this.isRoot() && !this.isLeaf && this.count == 0) {
            this.error("Root is of size zero (one pointer) but not a leaf", new Object[0]);
        }
        this.checkNodeDeep(null, null);
    }

    private void checkNodeDeep(Record min, Record max) {
        this.checkNode(min, max);
        if (this.isLeaf) {
            return;
        }
        int limit = this.count == 0 ? 0 : this.count + 1;
        for (int i = 0; i < limit; ++i) {
            Record min1 = min;
            Record max1 = max;
            if (!this.pageMgr.valid(this.ptrs.get(i))) {
                this.error("Node: %d: Dangling ptr in block @%d :: %s", this.id, i, this);
            }
            BTreeNode n = this.pageMgr.get(this.ptrs.get(i), this.id);
            if (i == 0) {
                max1 = this.records.get(0);
            } else if (i == this.count) {
                min1 = this.records.get(this.count - 1);
                max1 = null;
            } else {
                min1 = this.records.get(i - 1);
                max1 = this.records.get(i);
            }
            if (n.parent != this.id) {
                this.error("Node: %d [%d]: Parent/child mismatch :: %s", this.id, n.parent, this);
            }
            n.checkNodeDeep(min1, max1);
        }
    }

    private void error(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println(msg);
        System.out.flush();
        try {
            this.pageMgr.dump();
            this.bTree.dump();
            System.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new BTreeException(msg);
    }
}

