/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.file.MetaFile;
import com.hp.hpl.jena.tdb.sys.Names;
import java.io.File;

public class Location {
    static String pathSeparator = File.separator;
    private String pathname;
    private MetaFile metafile = null;
    static Location mem = new Location();

    public static Location mem() {
        return new Location();
    }

    private Location() {
        this.pathname = "--mem--";
        this.metafile = new MetaFile("--mem--", "--mem--");
    }

    public Location(String rootname) {
        if (rootname.equals("--mem--")) {
            this.pathname = "--mem--";
            this.metafile = new MetaFile("--mem--", "--mem--");
            return;
        }
        File file = new File(rootname = rootname.replace('\\', '/'));
        if (!file.exists()) {
            file.mkdir();
        } else if (!file.isDirectory()) {
            throw new FileException("Not a directory: " + file.getAbsolutePath());
        }
        this.pathname = file.getAbsolutePath();
        if (!this.pathname.endsWith(File.separator) && !this.pathname.endsWith(pathSeparator)) {
            this.pathname = this.pathname + pathSeparator;
        }
        String metafileName = this.getPath("this", "info");
        this.metafile = new MetaFile("Location: " + rootname, metafileName);
    }

    public String getDirectoryPath() {
        return this.pathname;
    }

    public MetaFile getMetaFile() {
        return this.metafile;
    }

    public boolean isMem() {
        return Names.isMem(this.pathname);
    }

    public Location getSubLocation(String dirname) {
        String newName = this.pathname + dirname;
        File file = new File(newName);
        if (file.exists() && !file.isDirectory()) {
            throw new FileException("Existing file: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return new Location(newName);
    }

    public String getSubDirectory(String dirname) {
        return this.getSubLocation(dirname).getDirectoryPath();
    }

    public String absolute(String filename, String extension) {
        return extension == null ? this.absolute(filename) : this.absolute(filename + "." + extension);
    }

    public String absolute(String filename) {
        File f = new File(filename);
        if (!f.isAbsolute()) {
            filename = this.pathname + filename;
        }
        return filename;
    }

    public boolean exists() {
        File f = new File(this.getDirectoryPath());
        return f.exists() && f.isDirectory() && f.canRead();
    }

    public boolean exists(String filename) {
        return this.exists(filename, null);
    }

    public boolean exists(String filename, String ext) {
        String fn = this.getPath(filename, ext);
        File f = new File(fn);
        return f.exists();
    }

    public String getPath(String filename) {
        return this.getPath(filename, null);
    }

    public String getPath(String filename, String ext) {
        this.check(filename, ext);
        if (ext == null) {
            return this.pathname + filename;
        }
        return this.pathname + filename + "." + ext;
    }

    private void check(String filename, String ext) {
        if (filename == null) {
            throw new FileException("Location: null filename");
        }
        if (filename.contains("/") || filename.contains("\\")) {
            throw new FileException("Illegal file component name: " + filename);
        }
        if (filename.contains(".") && ext != null) {
            throw new FileException("Filename has an extension: " + filename);
        }
        if (ext != null && ext.contains(".")) {
            throw new FileException("Extension has an extension: " + filename);
        }
    }

    public String toString() {
        return "location:" + this.pathname;
    }
}

