/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrCache;
import com.hp.hpl.jena.tdb.base.block.BlockMgrDirect;
import com.hp.hpl.jena.tdb.base.block.BlockMgrMapped;
import com.hp.hpl.jena.tdb.base.block.BlockMgrMem;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.File;

public class BlockMgrFactory {
    public static BlockMgr create(FileSet fileSet, String ext, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        if (fileSet.isMem()) {
            return BlockMgrFactory.createMem(fileSet.filename(ext), blockSize);
        }
        return BlockMgrFactory.createFile(fileSet.filename(ext), blockSize, readBlockCacheSize, writeBlockCacheSize);
    }

    public static BlockMgr createMem(String indexName, int blockSize) {
        BlockMgr blockMgr = new BlockMgrMem(blockSize);
        blockMgr = new BlockMgrCache(indexName, 3, 3, blockMgr);
        return blockMgr;
    }

    public static BlockMgr createFile(String filename, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        switch (SystemTDB.fileMode()) {
            case mapped: {
                return BlockMgrFactory.createMMapFile(filename, blockSize);
            }
            case direct: {
                return BlockMgrFactory.createStdFile(filename, blockSize, readBlockCacheSize, writeBlockCacheSize);
            }
        }
        throw new TDBException("Unknown file mode: " + (Object)((Object)SystemTDB.fileMode()));
    }

    public static BlockMgr createMMapFile(String filename, int blockSize) {
        return new BlockMgrMapped(filename, blockSize);
    }

    public static BlockMgr createStdFile(String filename, int blockSize, int readBlockCacheSize, int writeBlockCacheSize) {
        BlockMgr blockMgr = new BlockMgrDirect(filename, blockSize);
        String fn = filename;
        int j = filename.lastIndexOf(File.separatorChar);
        if (j > 0) {
            fn = filename.substring(j + 1);
        }
        blockMgr = new BlockMgrCache(fn, readBlockCacheSize, writeBlockCacheSize, blockMgr);
        return blockMgr;
    }

    public static BlockMgr createStdFileNoCache(String filename, int blockSize) {
        BlockMgrDirect blockMgr = new BlockMgrDirect(filename, blockSize);
        return blockMgr;
    }
}

