/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Test;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.RiotParseException;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;
import org.openjena.riot.tokens.TokenizerText;

public class TestTokenizer
extends BaseTest {
    private static Tokenizer tokenizer(String string) {
        PeekReader r = PeekReader.readString((String)string);
        TokenizerText tokenizer = new TokenizerText(r);
        return tokenizer;
    }

    private static void token(String string) {
        Tokenizer tokenizer = TestTokenizer.tokenizer(string);
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        TestTokenizer.assertNotNull((Object)tokenizer.next());
    }

    private static Token token_XX(String string) {
        Tokenizer tokenizer = TestTokenizer.tokenizer(string);
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
        return token;
    }

    private static Token tokenizeAndTestExact(String input, TokenType tokenType, String tokenImage) {
        return TestTokenizer.tokenizeAndTestExact(input, tokenType, tokenImage, null);
    }

    private static Token tokenizeAndTestExact(String input, TokenType tokenType, String tokenImage1, String tokenImage2) {
        Tokenizer tokenizer = TestTokenizer.tokenizer(input);
        Token token = TestTokenizer.testNextToken(tokenizer, tokenType, tokenImage1, tokenImage2);
        TestTokenizer.assertFalse((String)"Excess tokens", (boolean)tokenizer.hasNext());
        return token;
    }

    private static Tokenizer tokenizeAndTestFirst(String input, TokenType tokenType, String tokenImage) {
        return TestTokenizer.tokenizeAndTestFirst(input, tokenType, tokenImage, null);
    }

    private static Tokenizer tokenizeAndTestFirst(String input, TokenType tokenType, String tokenImage1, String tokenImage2) {
        Tokenizer tokenizer = TestTokenizer.tokenizer(input);
        TestTokenizer.testNextToken(tokenizer, tokenType, tokenImage1, tokenImage2);
        return tokenizer;
    }

    private static Token testNextToken(Tokenizer tokenizer, TokenType tokenType) {
        return TestTokenizer.testNextToken(tokenizer, tokenType, null, null);
    }

    private static Token testNextToken(Tokenizer tokenizer, TokenType tokenType, String tokenImage1) {
        return TestTokenizer.testNextToken(tokenizer, tokenType, tokenImage1, null);
    }

    private static Token testNextToken(Tokenizer tokenizer, TokenType tokenType, String tokenImage1, String tokenImage2) {
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)tokenType, (Object)token.getType());
        TestTokenizer.assertEquals((Object)tokenImage1, (Object)token.getImage());
        TestTokenizer.assertEquals((Object)tokenImage2, (Object)token.getImage2());
        return token;
    }

    @Test
    public void tokenUnit_iri1() {
        TestTokenizer.tokenizeAndTestExact("<x>", TokenType.IRI, "x");
    }

    @Test
    public void tokenUnit_iri2() {
        TestTokenizer.tokenizeAndTestExact("   <>   ", TokenType.IRI, "");
    }

    @Test
    public void tokenUnit_iri3() {
        try {
            TestTokenizer.token("<abc\\>def>");
        }
        catch (RiotParseException ex) {
            String x = ex.getMessage();
            TestTokenizer.assertTrue((boolean)x.contains("illegal escape sequence value: >"));
        }
    }

    @Test
    public void tokenUnit_iri4() {
        TestTokenizer.tokenizeAndTestFirst("   <abc\\\\def>   123", TokenType.IRI, "abc\\def");
    }

    @Test
    public void tokenUnit_iri5() {
        TestTokenizer.tokenizeAndTestFirst("<abc\\u0041def>   123", TokenType.IRI, "abcAdef");
    }

    @Test
    public void tokenUnit_str1() {
        TestTokenizer.tokenizeAndTestExact("   'abc'   ", TokenType.STRING1, "abc");
    }

    @Test
    public void tokenUnit_str2() {
        TestTokenizer.tokenizeAndTestExact("   ''   ", TokenType.STRING1, "");
    }

    @Test
    public void tokenUnit_str3() {
        TestTokenizer.tokenizeAndTestExact("'\\u0020'", TokenType.STRING1, " ");
    }

    @Test
    public void tokenUnit_str4() {
        TestTokenizer.tokenizeAndTestExact("'a\\'\\\"\\n\\t\\r'", TokenType.STRING1, "a'\"\n\t\r");
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str5() {
        TestTokenizer.tokenizeAndTestExact("'\n'", TokenType.STRING1, "\n");
    }

    @Test
    public void tokenUnit_str6() {
        TestTokenizer.tokenizeAndTestExact("   \"abc\"   ", TokenType.STRING2, "abc");
    }

    @Test
    public void tokenUnit_str7() {
        TestTokenizer.tokenizeAndTestExact("\"\"", TokenType.STRING2, "");
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str8() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("\"");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str9() {
        TestTokenizer.token("'abc");
    }

    @Test
    public void tokenUnit_str10() {
        TestTokenizer.tokenizeAndTestExact("'\\'abc'", TokenType.STRING1, "'abc");
    }

    @Test
    public void tokenUnit_str11() {
        TestTokenizer.tokenizeAndTestExact("'\\U00000020'", TokenType.STRING1, " ");
    }

    @Test
    public void tokenUnit_str_long1() {
        TestTokenizer.tokenizeAndTestExact("'''aaa'''", TokenType.LONG_STRING1, "aaa");
    }

    @Test
    public void tokenUnit_str_long2() {
        TestTokenizer.tokenizeAndTestExact("\"\"\"aaa\"\"\"", TokenType.LONG_STRING2, "aaa");
    }

    @Test
    public void tokenUnit_str_long3() {
        TestTokenizer.tokenizeAndTestExact("''''1234'''", TokenType.LONG_STRING1, "'1234");
    }

    @Test
    public void tokenUnit_str_long4() {
        TestTokenizer.tokenizeAndTestExact("'''''1234'''", TokenType.LONG_STRING1, "''1234");
    }

    @Test
    public void tokenUnit_str_long5() {
        TestTokenizer.tokenizeAndTestExact("'''\\'''1234'''", TokenType.LONG_STRING1, "'''1234");
    }

    @Test
    public void tokenUnit_str_long6() {
        TestTokenizer.tokenizeAndTestExact("\"\"\"\"1234\"\"\"", TokenType.LONG_STRING2, "\"1234");
    }

    @Test
    public void tokenUnit_str_long7() {
        TestTokenizer.tokenizeAndTestExact("\"\"\"\"\"1234\"\"\"", TokenType.LONG_STRING2, "\"\"1234");
    }

    @Test
    public void tokenUnit_str_long8() {
        TestTokenizer.tokenizeAndTestExact("''''''", TokenType.LONG_STRING1, "");
    }

    @Test
    public void tokenUnit_str_long9() {
        TestTokenizer.tokenizeAndTestExact("\"\"\"'''''''''''''''''\"\"\"", TokenType.LONG_STRING2, "'''''''''''''''''");
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str_long10() {
        TestTokenizer.token("\"\"\"abcdef");
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_str_long11() {
        TestTokenizer.token("'''");
    }

    @Test
    public void tokenUnit_str_long12() {
        TestTokenizer.tokenizeAndTestExact("'''x'''@en", TokenType.LITERAL_LANG, "x", "en");
    }

    @Test
    public void tokenUnit_bNode1() {
        TestTokenizer.tokenizeAndTestExact("_:abc", TokenType.BNODE, "abc");
    }

    @Test
    public void tokenUnit_bNode2() {
        TestTokenizer.tokenizeAndTestExact("_:123 ", TokenType.BNODE, "123");
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_bNode3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("_:");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenUnit_bNode4() {
        TestTokenizer.tokenizeAndTestExact("_:1-2-Z ", TokenType.BNODE, "1-2-Z");
    }

    @Test
    public void tokenUnit_bNode5() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("_:x.    ", TokenType.BNODE, "x");
        TestTokenizer.testNextToken(tokenizer, TokenType.DOT);
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_bNode6() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("_:x:a.    ", TokenType.BNODE, "x");
        TestTokenizer.testNextToken(tokenizer, TokenType.PREFIXED_NAME, "", "a");
        TestTokenizer.testNextToken(tokenizer, TokenType.DOT);
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_syntax1() {
        TestTokenizer.tokenizeAndTestExact(".", TokenType.DOT, null, null);
    }

    @Test
    public void tokenUnit_syntax2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer(".;,");
        TestTokenizer.testNextToken(tokenizer, TokenType.DOT);
        TestTokenizer.testNextToken(tokenizer, TokenType.SEMICOLON);
        TestTokenizer.testNextToken(tokenizer, TokenType.COMMA);
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenUnit_pname1() {
        TestTokenizer.tokenizeAndTestExact("a:b.c", TokenType.PREFIXED_NAME, "a", "b.c");
    }

    @Test
    public void tokenUnit_pname2() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("a:b.", TokenType.PREFIXED_NAME, "a", "b");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.DOT, (Object)token.getType());
    }

    @Test
    public void tokenUnit_pname3() {
        TestTokenizer.tokenizeAndTestExact("a:b123", TokenType.PREFIXED_NAME, "a", "b123");
    }

    @Test
    public void tokenUnit_pname4() {
        TestTokenizer.tokenizeAndTestExact("a:", TokenType.PREFIXED_NAME, "a", "");
    }

    @Test
    public void tokenUnit_pname5() {
        TestTokenizer.tokenizeAndTestExact(":", TokenType.PREFIXED_NAME, "", "");
    }

    @Test
    public void tokenUnit_pname6() {
        TestTokenizer.tokenizeAndTestExact(":a", TokenType.PREFIXED_NAME, "", "a");
    }

    @Test
    public void tokenUnit_pname7() {
        TestTokenizer.tokenizeAndTestExact(":123", TokenType.PREFIXED_NAME, "", "123");
    }

    @Test
    public void tokenUnit_pname8() {
        TestTokenizer.tokenizeAndTestExact("a123:456", TokenType.PREFIXED_NAME, "a123", "456");
    }

    @Test
    public void tokenUnit_pname9() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("a123:-456", TokenType.PREFIXED_NAME, "a123", "");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertEquals((Object)TokenType.INTEGER, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"-456", (Object)token.getImage());
    }

    @Test
    public void tokenUnit_25() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("123:", TokenType.INTEGER, "123");
        TestTokenizer.testNextToken(tokenizer, TokenType.PREFIXED_NAME, "", "");
    }

    @Test
    public void tokenUnit_num1() {
        TestTokenizer.tokenizeAndTestExact("123", TokenType.INTEGER, "123");
    }

    @Test
    public void tokenUnit_num2() {
        TestTokenizer.tokenizeAndTestExact("123.", TokenType.DECIMAL, "123.");
    }

    @Test
    public void tokenUnit_num3() {
        TestTokenizer.tokenizeAndTestExact("+123.456", TokenType.DECIMAL, "+123.456");
    }

    @Test
    public void tokenUnit_num4() {
        TestTokenizer.tokenizeAndTestExact("-1", TokenType.INTEGER, "-1");
    }

    @Test
    public void tokenUnit_num5() {
        TestTokenizer.tokenizeAndTestExact("-1e0", TokenType.DOUBLE, "-1e0");
    }

    @Test
    public void tokenUnit_num6() {
        TestTokenizer.tokenizeAndTestExact("1e+1", TokenType.DOUBLE, "1e+1");
    }

    @Test
    public void tokenUnit_num7() {
        TestTokenizer.tokenizeAndTestExact("1.3e+1", TokenType.DOUBLE, "1.3e+1");
    }

    @Test
    public void tokenUnit_num8() {
        TestTokenizer.tokenizeAndTestFirst("1.3.4", TokenType.DECIMAL, "1.3");
    }

    @Test
    public void tokenUnit_num9() {
        TestTokenizer.tokenizeAndTestFirst("1.3e67.7", TokenType.DOUBLE, "1.3e67");
    }

    @Test
    public void tokenUnit_num10() {
        TestTokenizer.tokenizeAndTestExact(".1", TokenType.DECIMAL, ".1");
    }

    @Test
    public void tokenUnit_num11() {
        TestTokenizer.tokenizeAndTestExact(".1e0", TokenType.DOUBLE, ".1e0");
    }

    @Test
    public void tokenUnit_num12() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("000A     .", TokenType.INTEGER, "000");
        TestTokenizer.testNextToken(tokenizer, TokenType.KEYWORD, "A");
    }

    @Test
    public void tokenUnit_var1() {
        TestTokenizer.tokenizeAndTestFirst("?x ?y", TokenType.VAR, "x");
    }

    @Test
    public void tokenUnit_var2() {
        TestTokenizer.tokenizeAndTestFirst("? x", TokenType.VAR, "");
    }

    @Test
    public void tokenUnit_var3() {
        TestTokenizer.tokenizeAndTestExact("??x", TokenType.VAR, "?x");
    }

    @Test
    public void tokenUnit_var4() {
        TestTokenizer.tokenizeAndTestExact("?.1", TokenType.VAR, ".1");
    }

    @Test
    public void tokenUnit_var5() {
        TestTokenizer.tokenizeAndTestExact("?.", TokenType.VAR, ".");
    }

    @Test
    public void tokenUnit_var6() {
        TestTokenizer.tokenizeAndTestExact("?.0", TokenType.VAR, ".0");
    }

    @Test
    public void tokenUnit_hex1() {
        TestTokenizer.tokenizeAndTestExact("0xABC", TokenType.HEX, "0xABC");
    }

    @Test
    public void tokenUnit_hex2() {
        TestTokenizer.tokenizeAndTestFirst("0xABCXYZ", TokenType.HEX, "0xABC");
    }

    @Test(expected=RiotParseException.class)
    public void tokenUnit_hex3() {
        TestTokenizer.token("0xXYZ");
    }

    @Test
    public void tokenUnit_hex4() {
        TestTokenizer.tokenizeAndTestExact("0Xabc", TokenType.HEX, "0Xabc");
    }

    private static void tokenizeAndTestLiteralDT(String input, String image, TokenType dt, String image1, String image2) {
        Token token2 = TestTokenizer.tokenizeAndTestExact(input, TokenType.LITERAL_DT, image).getSubToken();
        TestTokenizer.assertEquals((Object)dt, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)image1, (Object)token2.getImage());
        TestTokenizer.assertEquals((Object)image2, (Object)token2.getImage2());
    }

    @Test
    public void tokenLiteralDT_0() {
        TestTokenizer.tokenizeAndTestLiteralDT("'123'^^<x> ", "123", TokenType.IRI, "x", null);
    }

    @Test
    public void tokenLiteralDT_1() {
        TestTokenizer.tokenizeAndTestLiteralDT("'123'^^x:y ", "123", TokenType.PREFIXED_NAME, "x", "y");
    }

    @Test
    public void tokenLiteralDT_2() {
        TestTokenizer.tokenizeAndTestLiteralDT("'123'^^:y", "123", TokenType.PREFIXED_NAME, "", "y");
    }

    @Test
    public void tokenLiteralDT_3() {
        TestTokenizer.tokenizeAndTestLiteralDT("'''123'''^^<xyz>", "123", TokenType.IRI, "xyz", null);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_1() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^ <x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_2() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123' ^^<x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"123", (Object)token.getImage());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_3() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^ ^<x> ");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralDT_bad_4() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("'123'^^ x:y");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
    }

    @Test
    public void tokenLiteralLang_0() {
        TestTokenizer.tokenizeAndTestExact("'a'@en", TokenType.LITERAL_LANG, "a", "en");
    }

    @Test
    public void tokenLiteralLang_1() {
        TestTokenizer.tokenizeAndTestExact("'a'@en-UK", TokenType.LITERAL_LANG, "a", "en-UK");
    }

    @Test
    public void tokenLiteralLang_2() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("'' @lang ", TokenType.STRING1, "");
        TestTokenizer.testNextToken(tokenizer, TokenType.DIRECTIVE, "lang");
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_3() {
        TestTokenizer.token("''@ lang ");
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_4() {
        TestTokenizer.token("''@lang- ");
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_5() {
        TestTokenizer.token("'abc'@- ");
    }

    @Test
    public void tokenLiteralLang_6() {
        TestTokenizer.tokenizeAndTestExact("'XYZ'@a-b-c ", TokenType.LITERAL_LANG, "XYZ", "a-b-c");
    }

    @Test
    public void tokenLiteralLang_7() {
        TestTokenizer.tokenizeAndTestExact("'X'@a-b9z-c99 ", TokenType.LITERAL_LANG, "X", "a-b9z-c99");
    }

    @Test(expected=RiotParseException.class)
    public void tokenLiteralLang_8() {
        TestTokenizer.token("''@9-b");
    }

    @Test
    public void tokenComment_01() {
        TestTokenizer.tokenizeAndTestExact("_:123 # Comment", TokenType.BNODE, "123");
    }

    @Test
    public void tokenComment_02() {
        TestTokenizer.tokenizeAndTestExact("\"foo # Non-Comment\"", TokenType.STRING2, "foo # Non-Comment");
    }

    @Test
    public void tokenComment_03() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("'foo' # Comment\n'bar'", TokenType.STRING1, "foo");
        TestTokenizer.testNextToken(tokenizer, TokenType.STRING1, "bar");
    }

    @Test
    public void tokenWord_01() {
        TestTokenizer.tokenizeAndTestExact("abc", TokenType.KEYWORD, "abc");
    }

    @Test
    public void token_multiple() {
        Tokenizer tokenizer = TestTokenizer.tokenizer("<x><y>");
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"x", (Object)token.getImage());
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token2 = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token2);
        TestTokenizer.assertEquals((Object)TokenType.IRI, (Object)token2.getType());
        TestTokenizer.assertEquals((Object)"y", (Object)token2.getImage());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    private static ByteArrayInputStream bytes(String string) {
        byte[] b = StrUtils.asUTF8bytes((String)string);
        return new ByteArrayInputStream(b);
    }

    @Test
    public void tokenizer_charset_1() {
        ByteArrayInputStream in = TestTokenizer.bytes("'abc'");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        Token t = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenizer_charset_2() {
        ByteArrayInputStream in = TestTokenizer.bytes("'abcd\u00e9'");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        Token t = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test(expected=RiotParseException.class)
    public void tokenizer_charset_3() {
        ByteArrayInputStream in = TestTokenizer.bytes("<http://example/abcd\u00e9>");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerASCII((InputStream)in);
        Token t = tokenizer.next();
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    @Test
    public void tokenizer_BOM_1() {
        ByteArrayInputStream in = TestTokenizer.bytes("\ufeff'abc'");
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8((InputStream)in);
        TestTokenizer.assertTrue((boolean)tokenizer.hasNext());
        Token token = tokenizer.next();
        TestTokenizer.assertNotNull((Object)token);
        TestTokenizer.assertEquals((Object)TokenType.STRING1, (Object)token.getType());
        TestTokenizer.assertEquals((Object)"abc", (Object)token.getImage());
        TestTokenizer.assertFalse((boolean)tokenizer.hasNext());
    }

    private static void testSymbol(String string, TokenType expected) {
        TestTokenizer.tokenizeAndTestFirst(string, expected, null);
    }

    @Test
    public void tokenizer_symbol_02() {
        TestTokenizer.testSymbol("+", TokenType.PLUS);
    }

    @Test
    public void tokenizer_symbol_03() {
        TestTokenizer.testSymbol("-", TokenType.MINUS);
    }

    @Test
    public void tokenizer_symbol_05() {
        TestTokenizer.testSymbol(">", TokenType.GT);
    }

    @Test
    public void tokenizer_symbol_06() {
        TestTokenizer.testSymbol("=", TokenType.EQUALS);
    }

    @Test
    public void tokenUnit_symbol_11() {
        TestTokenizer.testSymbol("+A", TokenType.PLUS);
    }

    @Test
    public void tokenUnit_symbol_12() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst("+-", TokenType.PLUS, null);
        TestTokenizer.testNextToken(tokenizer, TokenType.MINUS);
    }

    @Test
    public void tokenUnit_symbol_13() {
        TestTokenizer.testSymbol(".", TokenType.DOT);
    }

    @Test
    public void tokenUnit_symbol_14() {
        Tokenizer tokenizer = TestTokenizer.tokenizeAndTestFirst(".a", TokenType.DOT, null);
        TestTokenizer.testNextToken(tokenizer, TokenType.KEYWORD, "a");
    }
}

