/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;

public class TestTokenForNode
extends BaseTest {
    static String base = "http://localhost/";
    static PrefixMap prefixMap = new PrefixMap();

    @BeforeClass
    public static void beforeClass() {
        prefixMap.add("ex", "http://example/");
    }

    @Test
    public void tokenForNode01() {
        TestTokenForNode.test("'x'", TokenType.STRING, "x", null, null);
    }

    @Test
    public void tokenForNode02() {
        TestTokenForNode.test("<x>", TokenType.IRI, "x", null, null);
    }

    @Test
    public void tokenForNode03() {
        TestTokenForNode.test("'en'@lang", TokenType.LITERAL_LANG, "en", "lang", null);
    }

    @Test
    public void tokenForNode04() {
        Token sub = new Token(-1L, -1L);
        sub.setType(TokenType.IRI);
        sub.setImage("dtype");
        TestTokenForNode.test("'lex'^^<dtype>", TokenType.LITERAL_DT, "lex", null, sub);
    }

    @Test
    public void tokenForNode05() {
        TestTokenForNode.test("<http://localhost/foo>", TokenType.IRI, "foo", null, null);
    }

    @Test
    public void tokenForNode06() {
        TestTokenForNode.test("<http://example/bar>", TokenType.PREFIXED_NAME, "ex", "bar", null);
    }

    @Test
    public void tokenForNode07() {
        TestTokenForNode.test("123", TokenType.INTEGER, "123", null, null);
    }

    @Test
    public void tokenForNode08() {
        TestTokenForNode.test("123.0", TokenType.DECIMAL, "123.0", null, null);
    }

    @Test
    public void tokenForNode09() {
        TestTokenForNode.test("12e0", TokenType.DOUBLE, "12e0", null, null);
    }

    @Test
    public void tokenForNode10() {
        TestTokenForNode.test(Node.createAnon((AnonId)new AnonId("abc")), TokenType.BNODE, "abc", null, null);
    }

    private static void test(String nodeStr, TokenType type, String image, String image2, Token subToken) {
        Node n = NodeFactory.parseNode((String)nodeStr);
        TestTokenForNode.test(n, type, image, image2, subToken);
    }

    private static void test(Node node, TokenType type, String image, String image2, Token subToken) {
        Token t = Token.tokenForNode((Node)node, (String)base, (PrefixMap)prefixMap);
        TestTokenForNode.assertEquals((Object)type, (Object)t.getType());
        TestTokenForNode.assertEquals((Object)image, (Object)t.getImage());
        TestTokenForNode.assertEquals((Object)image2, (Object)t.getImage2());
        TestTokenForNode.assertEquals((Object)subToken, (Object)t.getSubToken());
    }

    private static void test(String nodeStr, PrefixMap pmap, TokenType type, String image, String image2, Token subToken) {
        Node n = SSE.parseNode((String)nodeStr);
        Token t = Token.tokenForNode((Node)n);
        TestTokenForNode.assertEquals((Object)type, (Object)t.getType());
        TestTokenForNode.assertEquals((Object)image, (Object)t.getImage());
        TestTokenForNode.assertEquals((Object)image2, (Object)t.getImage2());
        TestTokenForNode.assertEquals((Object)subToken, (Object)t.getSubToken());
    }
}

