/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.riot.pipeline.normalize.CanonicalizeLiteral;

public class TestNormalization
extends BaseTest {
    @Test
    public void normalize_int_01() {
        TestNormalization.normalize("23", "23");
    }

    @Test
    public void normalize_int_02() {
        TestNormalization.normalize("023", "23");
    }

    @Test
    public void normalize_int_03() {
        TestNormalization.normalize("+23", "23");
    }

    @Test
    public void normalize_int_04() {
        TestNormalization.normalize("+023", "23");
    }

    @Test
    public void normalize_int_05() {
        TestNormalization.normalize("-23", "-23");
    }

    @Test
    public void normalize_int_06() {
        TestNormalization.normalize("-0230", "-230");
    }

    @Test
    public void normalize_int_07() {
        TestNormalization.normalize("0", "0");
    }

    @Test
    public void normalize_int_08() {
        TestNormalization.normalize("00", "0");
    }

    @Test
    public void normalize_int_09() {
        TestNormalization.normalize("+00", "0");
    }

    @Test
    public void normalize_int_10() {
        TestNormalization.normalize("-0", "0");
    }

    @Test
    public void normalize_int_11() {
        TestNormalization.normalize("-000", "0");
    }

    @Test
    public void normalize_int_20() {
        TestNormalization.normalize("'-000'^^xsd:int", "0");
    }

    @Test
    public void normalize_int_21() {
        TestNormalization.normalize("'0'^^xsd:int", "0");
    }

    @Test
    public void normalize_int_22() {
        TestNormalization.normalize("'1'^^xsd:long", "1");
    }

    @Test
    public void normalize_int_23() {
        TestNormalization.normalize("'100'^^xsd:unsignedInt", "100");
    }

    @Test
    public void normalize_int_24() {
        TestNormalization.normalize("'-100'^^xsd:nonPositiveInteger", "-100");
    }

    @Test
    public void normalize_int_25() {
        TestNormalization.normalize("'+100'^^xsd:positiveInteger", "100");
    }

    @Test
    public void normalize_decimal_01() {
        TestNormalization.normalize("0.0", "0.0");
    }

    @Test
    public void normalize_decimal_02() {
        TestNormalization.normalize("'0'^^xsd:decimal", "0.0");
    }

    @Test
    public void normalize_decimal_03() {
        TestNormalization.normalize("1.0", "1.0");
    }

    @Test
    public void normalize_decimal_04() {
        TestNormalization.normalize("1.1", "1.1");
    }

    @Test
    public void normalize_decimal_05() {
        TestNormalization.normalize("0001.10", "1.1");
    }

    @Test
    public void normalize_decimal_06() {
        TestNormalization.normalize("-0.0", "0.0");
    }

    @Test
    public void normalize_decimal_07() {
        TestNormalization.normalize("+0.0", "0.0");
    }

    @Test
    public void normalize_decimal_08() {
        TestNormalization.normalize("+00560.0", "560.0");
    }

    @Test
    public void normalize_decimal_09() {
        TestNormalization.normalize("-1.0", "-1.0");
    }

    @Test
    public void normalize_decimal_10() {
        TestNormalization.normalize("-1.0", "-1.0");
    }

    @Test
    public void normalize_decimal_11() {
        TestNormalization.normalize("+1.0", "1.0");
    }

    @Test
    public void normalize_decimal_12() {
        TestNormalization.normalize("+1.0001", "1.0001");
    }

    @Test
    public void normalize_decimal_13() {
        TestNormalization.normalize("-1.000100", "-1.0001");
    }

    @Test
    public void normalize_decimal_14() {
        TestNormalization.normalize("'-1'^^xsd:decimal", "-1.0");
    }

    @Test
    public void normalize_decimal_15() {
        TestNormalization.normalize("'0'^^xsd:decimal", "0.0");
    }

    @Test
    public void normalize_double_01() {
        TestNormalization.normalize("1e0", "1.0E0");
    }

    @Test
    public void normalize_double_02() {
        TestNormalization.normalize("0e0", "0.0E0");
    }

    @Test
    public void normalize_double_03() {
        TestNormalization.normalize("00e0", "0.0E0");
    }

    @Test
    public void normalize_double_04() {
        TestNormalization.normalize("0e00", "0.0E0");
    }

    @Test
    public void normalize_double_05() {
        TestNormalization.normalize("10e0", "1.0E1");
    }

    @Test
    public void normalize_double_10() {
        TestNormalization.normalize("'-1e+0'^^xsd:double", "-1.0E0");
    }

    @Test
    public void normalize_double_11() {
        TestNormalization.normalize("'+0e01'^^xsd:double", "0.0E0");
    }

    @Test
    public void normalize_double_12() {
        TestNormalization.normalize("'1000'^^xsd:double", "1.0E3");
    }

    @Test
    public void normalize_double_13() {
        TestNormalization.normalize("+1.e4", "1.0E4");
    }

    @Test
    public void normalize_double_14() {
        TestNormalization.normalize("+12345.6789e+9", "1.23456789E13");
    }

    @Test
    public void normalize_double_15() {
        TestNormalization.normalize("-12345.6789e+9", "-1.23456789E13");
    }

    @Test
    public void normalize_double_16() {
        TestNormalization.normalize("+12345.6789e-9", "1.23456789E-5");
    }

    @Test
    public void normalize_double_17() {
        TestNormalization.normalize("-12345.6789e-9", "-1.23456789E-5");
    }

    @Test
    public void normalize_datetime_01() {
        TestNormalization.normalizeDT("1984-01-01T07:07:07", "1984-01-01T07:07:07");
    }

    @Test
    public void normalize_datetime_02() {
        TestNormalization.normalizeDT("1984-01-01T07:07:07.0", "1984-01-01T07:07:07");
    }

    @Test
    public void normalize_datetime_03() {
        TestNormalization.normalizeDT("1984-01-01T07:07:07.00", "1984-01-01T07:07:07");
    }

    @Test
    public void normalize_datetime_04() {
        TestNormalization.normalizeDT("1984-01-01T07:07:07.01", "1984-01-01T07:07:07.01");
    }

    @Test
    public void normalize_datetime_05() {
        TestNormalization.normalizeDT("1984-01-01T07:07:07.010", "1984-01-01T07:07:07.01");
    }

    @Test
    public void normalize_boolean_01() {
        TestNormalization.normalize("'true'^^xsd:boolean", "'true'^^xsd:boolean");
    }

    @Test
    public void normalize_boolean_02() {
        TestNormalization.normalize("'false'^^xsd:boolean", "'false'^^xsd:boolean");
    }

    @Test
    public void normalize_boolean_03() {
        TestNormalization.normalize("'1'^^xsd:boolean", "'true'^^xsd:boolean");
    }

    @Test
    public void normalize_boolean_04() {
        TestNormalization.normalize("'0'^^xsd:boolean", "'false'^^xsd:boolean");
    }

    @Test
    public void normalize_lang_01() {
        TestNormalization.normalizeLang("''", "''");
    }

    @Test
    public void normalize_lang_02() {
        TestNormalization.normalizeLang("'abc'", "'abc'");
    }

    @Test
    public void normalize_lang_03() {
        TestNormalization.normalizeLang("'abc'@EN", "'abc'@en");
    }

    @Test
    public void normalize_lang_04() {
        TestNormalization.normalizeLang("'abc'@EN-UK", "'abc'@en-UK");
    }

    @Test
    public void normalize_lang_05() {
        TestNormalization.normalizeLang("'abc'@EN", "'abc'@EN", false);
    }

    @Test
    public void normalize_lang_06() {
        TestNormalization.normalizeLang("'abc'@EN-UK", "'abc'@en-uk", false);
    }

    private static void normalize(String input, String expected) {
        Node n1 = NodeFactory.parseNode((String)input);
        TestNormalization.assertTrue((String)"Invalid lexical form", (boolean)n1.getLiteralDatatype().isValid(n1.getLiteralLexicalForm()));
        Node n2 = CanonicalizeLiteral.get().convert(n1);
        Node n3 = NodeFactory.parseNode((String)expected);
        TestNormalization.assertEquals((String)"Invalid canonicalization (lex)", (Object)n3.getLiteralLexicalForm(), (Object)n2.getLiteralLexicalForm());
        TestNormalization.assertEquals((String)"Invalid canonicalization (node)", (Object)n3, (Object)n2);
    }

    private static void normalizeLang(String input, String expected) {
        TestNormalization.normalizeLang(input, expected, true);
    }

    private static void normalizeLang(String input, String expected, boolean correct) {
        Node n1 = NodeFactory.parseNode((String)input);
        Node n2 = CanonicalizeLiteral.get().convert(n1);
        Node n3 = NodeFactory.parseNode((String)expected);
        if (correct) {
            TestNormalization.assertEquals((String)"Invalid canonicalization (lang)", (Object)n3.getLiteralLanguage(), (Object)n2.getLiteralLanguage());
            TestNormalization.assertEquals((String)"Invalid canonicalization (node)", (Object)n3, (Object)n2);
        } else {
            TestNormalization.assertNotEquals("Invalid canonicalization (lang)", n3.getLiteralLanguage(), n2.getLiteralLanguage());
            TestNormalization.assertNotEquals("Invalid canonicalization (node)", n3, n2);
        }
    }

    private static void normalizeDT(String input, String expected) {
        TestNormalization.normalize("'" + input + "'^^xsd:dateTime", "'" + expected + "'^^xsd:dateTime");
    }
}

