/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import junit.framework.TestCase;
import org.openjena.atlas.io.PeekReader;
import org.openjena.riot.RiotParseException;
import org.openjena.riot.system.JenaReaderNTriples2;
import org.openjena.riot.system.JenaReaderTurtle2;

public class UnitTestTurtle
extends TestCase {
    String input;
    String output;
    String baseIRI;

    public UnitTestTurtle(String name, String input, String output, String baseIRI) {
        super(name);
        this.input = input;
        this.output = output;
        this.baseIRI = baseIRI;
    }

    public void runTest() {
        Model model = ModelFactory.createDefaultModel();
        JenaReaderTurtle2 t = new JenaReaderTurtle2();
        try {
            if (this.baseIRI != null) {
                InputStream in = FileManager.get().open(this.input);
                PeekReader r = PeekReader.makeUTF8((InputStream)in);
                t.read(model, (Reader)r, this.baseIRI);
            } else {
                t.read(model, this.input);
            }
            String syntax = FileUtils.guessLang((String)this.output, (String)"N-TRIPLE");
            Model results = ModelFactory.createDefaultModel();
            new JenaReaderNTriples2().read(results, this.output);
            boolean b = model.isIsomorphicWith(results);
            if (!b) {
                System.out.println("---- Parsed");
                model.write((OutputStream)System.out, "TTL");
                System.out.println("---- Expected");
                results.write((OutputStream)System.out, "TTL");
                System.out.println("--------");
            }
            UnitTestTurtle.assertTrue((String)"Models not isomorphic", (boolean)b);
        }
        catch (RiotParseException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }
}

