/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkNull;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangTurtle;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class TestTurtleTerms
extends BaseTest {
    public static final String QUOTE3 = "\"\"\"";
    public static boolean VERBOSE = false;

    @Test
    public void turtle_001() {
        TestTurtleTerms.parse("a:subj a:prop a:d .");
    }

    @Test
    public void turtle_002() {
        TestTurtleTerms.parse("a:subj a:prop a:d . ");
    }

    @Test
    public void turtle_003() {
        TestTurtleTerms.parse("a:subj a:prop a:d.");
    }

    @Test
    public void turtle_004() {
        TestTurtleTerms.parse("a:subj a:prop a:d. ");
    }

    @Test
    public void turtle_005() {
        TestTurtleTerms.parse("rdf: rdf:type :_.");
    }

    @Test
    public void turtle_006() {
        TestTurtleTerms.parse("@prefix start: <somewhere>.");
    }

    @Test
    public void turtle_007() {
        TestTurtleTerms.parse("<http://here/subj> <http://here/prep> <http://here/obj>.");
    }

    @Test
    public void turtle_008() {
        TestTurtleTerms.parse("a:subj\ta:prop\ta:d.\t");
    }

    @Test
    public void turtle_009() {
        TestTurtleTerms.parse("       a:subj\ta:prop\ta:d.     ");
    }

    @Test
    public void turtle_010() {
        TestTurtleTerms.parse("a:subj a:prop a:d.  ");
    }

    @Test
    public void turtle_011() {
        TestTurtleTerms.parse("");
    }

    @Test
    public void turtle_012() {
        TestTurtleTerms.parse(" #Comment");
    }

    @Test
    public void turtle_013() {
        TestTurtleTerms.parse("a:subj a:prop a:d.  # Comment");
    }

    @Test
    public void turtle_014() {
        TestTurtleTerms.parse("a:subj a:prop a:d.# Comment");
    }

    @Test
    public void turtle_015() {
        TestTurtleTerms.parse("a:subj a:prop 'string1'.");
    }

    @Test
    public void turtle_016() {
        TestTurtleTerms.parse("a:subj a:prop \"string2\".");
    }

    @Test
    public void turtle_017() {
        TestTurtleTerms.parse("a:subj a:prop '''string3'''.");
    }

    @Test
    public void turtle_018() {
        TestTurtleTerms.parse("a:subj a:prop \"\"\"string3\"\"\".");
    }

    @Test
    public void turtle_019() {
        TestTurtleTerms.parse("a:subj a:prop 'string1'^^x:dt.");
    }

    @Test
    public void turtle_020() {
        TestTurtleTerms.parse("a:subj a:prop 'string1'^^<uriref>.");
    }

    @Test
    public void turtle_021() {
        TestTurtleTerms.parse("a: :p 2. .");
    }

    @Test
    public void turtle_022() {
        TestTurtleTerms.parse("a: :p +2. .");
    }

    @Test
    public void turtle_023() {
        TestTurtleTerms.parse("a: :p -2 .");
    }

    @Test
    public void turtle_024() {
        TestTurtleTerms.parse("a: :p 2e6.");
    }

    @Test
    public void turtle_025() {
        TestTurtleTerms.parse("a: :p 2e-6.");
    }

    @Test
    public void turtle_026() {
        TestTurtleTerms.parse("a: :p -2e-6.");
    }

    @Test
    public void turtle_027() {
        TestTurtleTerms.parse("a: :p 2.0e-6.");
    }

    @Test
    public void turtle_028() {
        TestTurtleTerms.parse("a: :p 2.0 .");
    }

    @Test
    public void turtle_033() {
        TestTurtleTerms.parse("a:subj a:prop \"\\'string2\\'\".");
    }

    @Test
    public void turtle_034() {
        TestTurtleTerms.parse("a:subj a:prop \"\\\"string2\\\"\".");
    }

    @Test
    public void turtle_035() {
        TestTurtleTerms.parse("a:subj a:prop '\\'string1\\''.");
    }

    @Test
    public void turtle_036() {
        TestTurtleTerms.parse("a:subj a:prop '\\\"string1\\\"'.");
    }

    @Test
    public void turtle_037() {
        TestTurtleTerms.parse("a:q21 a:prop \"\"\"start\"finish\"\"\".");
    }

    @Test
    public void turtle_038() {
        TestTurtleTerms.parse("a:q22 a:prop \"\"\"start\"\"finish\"\"\".");
    }

    @Test
    public void turtle_039() {
        TestTurtleTerms.parse("a:q2e3 a:prop \"\"\"start\\\"\\\"\\\"finish\"\"\".");
    }

    @Test
    public void turtle_040() {
        TestTurtleTerms.parse("a:q13 a:prop \"\"\"start'''finish\"\"\".");
    }

    @Test
    public void turtle_041() {
        TestTurtleTerms.parse("a:q11 a:prop '''start'finish'''.");
    }

    @Test
    public void turtle_042() {
        TestTurtleTerms.parse("a:q12 a:prop '''start''finish'''.");
    }

    @Test
    public void turtle_043() {
        TestTurtleTerms.parse("a:q12 a:prop '''start\\'\\'\\'finish'''.");
    }

    @Test
    public void turtle_044() {
        TestTurtleTerms.parse("a:q23 a:prop '''start\"\"\"finish'''.");
    }

    @Test
    public void turtle_053() {
        TestTurtleTerms.parse("a:subj <a>  x:y .");
    }

    @Test
    public void turtle_054() {
        TestTurtleTerms.parse("<this>  a   x:y .");
    }

    @Test
    public void turtle_055() {
        TestTurtleTerms.parse("@prefix has: <uri>.");
    }

    @Test
    public void turtle_056() {
        TestTurtleTerms.parse("<>   a:prop  x:y .");
    }

    @Test
    public void turtle_057() {
        TestTurtleTerms.parse("<#>  a:prop  x:y .");
    }

    @Test
    public void turtle_058() {
        TestTurtleTerms.parse("a:subj a:prop a:d, a:e.");
    }

    @Test
    public void turtle_059() {
        TestTurtleTerms.parse("a:subj a:prop a:d, '123'.");
    }

    @Test
    public void turtle_060() {
        TestTurtleTerms.parse("a:subj a:prop '123', a:e.");
    }

    @Test
    public void turtle_063() {
        TestTurtleTerms.parse("a:subj a:p1 a:v1 ;  a:p2 a:v2 .");
    }

    @Test
    public void turtle_064() {
        TestTurtleTerms.parse("a:subj a:p1 a:v1, a:v2 ;  a:p2 a:v2 ; a:p3 'v4' ,'v5' .");
    }

    @Test
    public void turtle_065() {
        TestTurtleTerms.parse("a:subj a:p1 a:v1; .");
    }

    @Test
    public void turtle_066() {
        TestTurtleTerms.parse("a:subj a:p1 a:v1; a:p2 a:v2; .");
    }

    @Test
    public void turtle_067() {
        TestTurtleTerms.parse("[a:prop a:val].");
    }

    @Test
    public void turtle_068() {
        TestTurtleTerms.parse("[] a:prop a:val.");
    }

    @Test
    public void turtle_069() {
        TestTurtleTerms.parse("[] a:prop [].");
    }

    @Test
    public void turtle_079() {
        TestTurtleTerms.parse("<here> <list> ().");
    }

    @Test
    public void turtle_080() {
        TestTurtleTerms.parse(" ( a:i1 a:i2 a:i3 ) a rdf:List.");
    }

    @Test
    public void turtle_102() {
        TestTurtleTerms.parse("a:subj a:prop '123'^^xsd:integer .");
    }

    @Test
    public void turtle_103() {
        TestTurtleTerms.parse("a:subj a:prop '123'^^<uri> .");
    }

    @Test
    public void turtle_104() {
        TestTurtleTerms.parse("a:subj a:prop '<tag>text</tag>'^^rdf:XMLLiteral .");
    }

    @Test
    public void turtle_105() {
        TestTurtleTerms.parse("a:subj a:prop 123 .");
    }

    @Test
    public void turtle_107() {
        TestTurtleTerms.parse("a:subj a:prop 123.1 .");
    }

    @Test
    public void turtle_108() {
        TestTurtleTerms.parse("a:subj a:prop -123.1 .");
    }

    @Test
    public void turtle_109() {
        TestTurtleTerms.parse("a:subj a:prop 123.1e3 .");
    }

    @Test
    public void turtle_110() {
        TestTurtleTerms.parse("a:subj a:prop 123.1e-3 .");
    }

    @Test
    public void turtle_111() {
        TestTurtleTerms.parse("a:subj a:prop 123.1E3 .");
    }

    @Test
    public void turtle_112() {
        TestTurtleTerms.parse("a:subj a:prop 123.1E-3 .");
    }

    @Test
    public void turtle_113() {
        TestTurtleTerms.parse("a:subj a:prop 'text'@en .");
    }

    @Test
    public void turtle_120() {
        TestTurtleTerms.parse("a:subj a:prop '\u00e9'.");
    }

    @Test
    public void turtle_121() {
        TestTurtleTerms.parse("a:subj a:prop ';1'.");
    }

    @Test
    public void turtle_122() {
        TestTurtleTerms.parse("\u00e9:subj a:prop '\u00e9'.");
    }

    @Test
    public void turtle_123() {
        TestTurtleTerms.parse("a:subj-\u00e9 a:prop '\u00e9'.");
    }

    @Test
    public void turtle_124() {
        TestTurtleTerms.parse("\u03b1:subj a:prop '\u03b1'.");
    }

    @Test
    public void turtle_125() {
        TestTurtleTerms.parse("a:subj-\u03b1 a:prop '\u03b1'.");
    }

    @Test
    public void turtle_150() {
        TestTurtleTerms.parse("<x> a <y> . ");
    }

    @Test
    public void turtle_151() {
        TestTurtleTerms.parse("[ a <y> ] . ");
    }

    @Test
    public void turtle_152() {
        TestTurtleTerms.parse("[ a <y> ; a <z> ] . ");
    }

    @Test
    public void turtle_153() {
        TestTurtleTerms.parse("[ a <z>, <z1> ] . ");
    }

    public static void parse(String testString) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)testString);
        SinkNull sink = new SinkNull();
        LangTurtle parser = RiotReader.createParserTurtle((Tokenizer)tokenizer, (String)"http://base/", (Sink)sink);
        PrefixMap prefixMap = parser.getProfile().getPrologue().getPrefixMap();
        prefixMap.add("a", "http://host/a#");
        prefixMap.add("x", "http://host/a#");
        prefixMap.add("\u00e9", "http://host/e-acute/");
        prefixMap.add("\u03b1", "http://host/alpha/");
        prefixMap.add("", "http://host/");
        prefixMap.add("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixMap.add("xsd", "http://www.w3.org/2001/XMLSchema#");
        parser.parse();
        tokenizer.close();
    }
}

