/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.LangNTriples;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.LangTriG;
import org.openjena.riot.lang.LangTurtle;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class TestParserFactory
extends BaseTest {
    @Test
    public void ntriples_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> .");
        CatchSink sink = new CatchSink();
        LangNTriples parser = RiotReader.createParserNTriples((Tokenizer)tokenizer, sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.flushCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.closeCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.things.size());
        TestParserFactory.assertEquals((Object)SSE.parseTriple((String)"(<x> <p> <q>)"), sink.getLast());
    }

    @Test
    public void turtle_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> .");
        CatchSink sink = new CatchSink();
        LangTurtle parser = RiotReader.createParserTurtle((Tokenizer)tokenizer, (String)"http://base/", sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.flushCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.closeCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.things.size());
        TestParserFactory.assertEquals((Object)SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)"), sink.getLast());
    }

    @Test
    public void nquads_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<x> <p> <q> <g>.");
        CatchSink sink = new CatchSink();
        LangNQuads parser = RiotReader.createParserNQuads((Tokenizer)tokenizer, sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.flushCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.closeCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.things.size());
        Quad q = SSE.parseQuad((String)"(<g> <x> <p> <q>)");
        TestParserFactory.assertEquals((Object)q, sink.getLast());
    }

    @Test
    public void trig_01() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"{ <x> <p> <q> }");
        CatchSink sink = new CatchSink();
        LangTriG parser = RiotReader.createParserTriG((Tokenizer)tokenizer, (String)"http://base/", sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.flushCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.closeCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.things.size());
        Triple t = SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)");
        Quad q = new Quad(Quad.tripleInQuad, t);
        TestParserFactory.assertEquals((Object)q, sink.getLast());
    }

    @Test
    public void trig_02() {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)"<g> { <x> <p> <q> }");
        CatchSink sink = new CatchSink();
        LangTriG parser = RiotReader.createParserTriG((Tokenizer)tokenizer, (String)"http://base/", sink);
        TestParserFactory.parserSetup((LangRIOT)parser);
        parser.parse();
        TestParserFactory.assertEquals((long)1L, (long)sink.flushCalled);
        TestParserFactory.assertEquals((long)0L, (long)sink.closeCalled);
        TestParserFactory.assertEquals((long)1L, (long)sink.things.size());
        Quad q = SSE.parseQuad((String)"(<http://base/g> <http://base/x> <http://base/p> <http://base/q>)");
        TestParserFactory.assertEquals((Object)q, sink.getLast());
    }

    private static void parserSetup(LangRIOT parser) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatchSink<T>
    implements Sink<T> {
        List<T> things = new ArrayList<T>();
        int flushCalled = 0;
        int closeCalled = 0;

        CatchSink() {
        }

        public void send(T item) {
            this.things.add(item);
        }

        public void flush() {
            ++this.flushCalled;
        }

        public void close() {
            ++this.closeCalled;
        }

        public T getLast() {
            if (this.things.size() == 0) {
                return null;
            }
            return this.things.get(this.things.size() - 1);
        }
    }
}

