/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.riot.lang.LabelToNode;

public class TestNodeAllocator
extends BaseTest {
    static Node gragh1 = Node.createURI((String)"g1");
    static Node gragh2 = Node.createURI((String)"g2");

    @Test
    public void allocOneScope1() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
        TestNodeAllocator.assertSame((Object)b1, (Object)b2);
    }

    @Test
    public void allocOneScope2() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh1, (Object)"123");
        TestNodeAllocator.assertNotEquals(b1, b2);
    }

    @Test
    public void allocOneScope3() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh2, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
    }

    @Test
    public void allocOneScope4() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get(null, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh2, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
    }

    @Test
    public void allocOneScope5() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get(null, (Object)"xyz");
        Node b2 = (Node)alloc.get(null, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
    }

    @Test
    public void allocGraphScope1() {
        LabelToNode alloc = LabelToNode.createScopeByGraph();
        Node b1 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
        TestNodeAllocator.assertSame((Object)b1, (Object)b2);
    }

    @Test
    public void allocGraphScope2() {
        LabelToNode alloc = LabelToNode.createScopeByGraph();
        Node b1 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh1, (Object)"123");
        TestNodeAllocator.assertNotEquals(b1, b2);
    }

    @Test
    public void allocGraphScope3() {
        LabelToNode alloc = LabelToNode.createScopeByGraph();
        Node b1 = (Node)alloc.get((Object)gragh1, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh2, (Object)"xyz");
        TestNodeAllocator.assertNotEquals(b1, b2);
    }

    @Test
    public void allocGraphScope4() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get(null, (Object)"xyz");
        Node b2 = (Node)alloc.get((Object)gragh2, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
    }

    @Test
    public void allocGraphScope5() {
        LabelToNode alloc = LabelToNode.createScopeByDocument();
        Node b1 = (Node)alloc.get(null, (Object)"xyz");
        Node b2 = (Node)alloc.get(null, (Object)"xyz");
        TestNodeAllocator.assertEquals((Object)b1, (Object)b2);
    }
}

