/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.ErrorHandlerTestLib;
import org.openjena.riot.RiotLoader;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangTurtle;
import org.openjena.riot.system.JenaReaderTurtle2;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class TestLangTurtle
extends BaseTest {
    @Test
    public void blankNodes1() {
        String s = "_:a <http://example/p> 'foo' . ";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        JenaReaderTurtle2 reader = new JenaReaderTurtle2();
        this.readProtected((RDFReader)reader, m, r, null);
        TestLangTurtle.assertEquals((long)1L, (long)m.size());
        String x = ((Statement)m.listStatements().next()).getSubject().getId().getLabelString();
        TestLangTurtle.assertNotEquals(x, "a");
        r = new StringReader(s);
        reader.read(m, (Reader)r, null);
        TestLangTurtle.assertEquals((long)2L, (long)m.size());
    }

    @Test
    public void blankNodes2() {
        String s = "_:a <http://example/p> 'foo' . _:a <http://example/p> 'foo' .";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        JenaReaderTurtle2 reader = new JenaReaderTurtle2();
        this.readProtected((RDFReader)reader, m, r, null);
        TestLangTurtle.assertEquals((long)1L, (long)m.size());
    }

    @Test
    public void updatePrefixMapping() {
        JenaReaderTurtle2 parser = new JenaReaderTurtle2();
        Model model = ModelFactory.createDefaultModel();
        StringReader reader = new StringReader("@prefix x: <http://example/x>.");
        parser.read(model, (Reader)reader, "http://example/base/");
        TestLangTurtle.assertEquals((long)1L, (long)model.getNsPrefixMap().size());
        TestLangTurtle.assertEquals((Object)"http://example/x", (Object)model.getNsPrefixURI("x"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProtected(RDFReader reader, Model m, Reader r, String base) {
        ErrorHandler errHandler = ErrorHandlerFactory.errorHandlerStd;
        ErrorHandlerFactory.errorHandlerStd = ErrorHandlerFactory.errorHandlerNoLogging;
        try {
            reader.read(m, r, base);
        }
        finally {
            ErrorHandlerFactory.errorHandlerStd = errHandler;
        }
    }

    private static Graph parse(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        StringReader reader = new StringReader(string);
        String baseIRI = "http://base/";
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer((Reader)reader);
        Graph graph = GraphFactory.createDefaultGraph();
        Sink sink = RiotLoader.graphSink((Graph)graph);
        LangTurtle parser = RiotReader.createParserTurtle((Tokenizer)tokenizer, (String)"http://base/", (Sink)sink);
        parser.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        parser.parse();
        return graph;
    }

    private static Triple parseOneTriple(String ... strings) {
        Graph graph = TestLangTurtle.parse(strings);
        TestLangTurtle.assertEquals((long)1L, (long)graph.size());
        return (Triple)graph.find(null, null, null).next();
    }

    @Test
    public void triple() {
        TestLangTurtle.parse("<s> <p> <o> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorJunk_1() {
        TestLangTurtle.parse("<p>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorJunk_2() {
        TestLangTurtle.parse("<r> <p>");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorNoPrefixDef() {
        TestLangTurtle.parse("x:p <p> 'q' .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorNoPrefixDefDT() {
        TestLangTurtle.parse("<p> <p> 'q'^^x:foo .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void errorBadDatatype() {
        TestLangTurtle.parse("<p> <p> 'q'^^.");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void errorBadURI_1() {
        TestLangTurtle.parse("<http://example/a b> <http://example/p> 123 .");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void errorBadURI_2() {
        TestLangTurtle.parse("<http://example/a%XAb> <http://example/p> 123 .");
    }

    @Test
    public void errorBadURI_3() {
        TestLangTurtle.parse("<http://example/a%Aab> <http://example/p> 123 .");
    }

    @Test
    public void turtle_01() {
        Triple t = TestLangTurtle.parseOneTriple("<s> <p> 123 . ");
        Triple t2 = SSE.parseTriple((String)"(<http://base/s> <http://base/p> 123)");
        TestLangTurtle.assertEquals((Object)t2, (Object)t);
    }

    @Test
    public void turtle_02() {
        Triple t = TestLangTurtle.parseOneTriple("@base <http://example/> . <s> <p> 123 . ");
        Triple t2 = SSE.parseTriple((String)"(<http://example/s> <http://example/p> 123)");
        TestLangTurtle.assertEquals((Object)t2, (Object)t);
    }

    @Test
    public void turtle_03() {
        Triple t = TestLangTurtle.parseOneTriple("@prefix ex: <http://example/x/> . ex:s ex:p 123 . ");
        Triple t2 = SSE.parseTriple((String)"(<http://example/x/s> <http://example/x/p> 123)");
        TestLangTurtle.assertEquals((Object)t2, (Object)t);
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void turtle_10() {
        TestLangTurtle.parse("@prefix ex:  <http://example/> .  { ex:s ex:p 123 . } ");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_20() {
        TestLangTurtle.parse("@prefix ex:  <bad iri> .  ex:s ex:p 123 ");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_21() {
        TestLangTurtle.parse("@prefix ex:  <http://example/> . ex:s <http://example/broken p> 123");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_22() {
        TestLangTurtle.parse("<x> <p> 'number'^^<bad uri> ");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void turtle_23() {
        TestLangTurtle.parse("@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> . <x> <p> 'number'^^xsd:byte }");
    }
}

