/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.lib.DatasetLib;
import com.hp.hpl.jena.sparql.sse.SSE;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerTestLib;
import org.openjena.riot.RiotLoader;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangTriG;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class TestLangTrig
extends BaseTest {
    @Test
    public void trig_01() {
        TestLangTrig.parse("{}");
    }

    @Test
    public void trig_02() {
        TestLangTrig.parse("{}.");
    }

    @Test
    public void trig_03() {
        TestLangTrig.parse("<g> {}");
    }

    @Test
    public void trig_04() {
        TestLangTrig.parse("<g> = {}");
    }

    @Test
    public void trig_05() {
        TestLangTrig.parse("<g> = {} .");
    }

    @Test
    public void trig_10() {
        DatasetGraph dsg = TestLangTrig.parse("{ <x> <p> <q> }");
        TestLangTrig.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
        Triple t = (Triple)dsg.getDefaultGraph().find(null, null, null).next();
        Triple t2 = SSE.parseTriple((String)"(<http://base/x> <http://base/p> <http://base/q>)");
        TestLangTrig.assertEquals((Object)t2, (Object)t);
    }

    @Test
    public void trig_11() {
        DatasetGraph dsg = TestLangTrig.parse("@prefix ex:  <http://example/> .", "{ ex:s ex:p 123 }");
        TestLangTrig.assertEquals((long)1L, (long)dsg.getDefaultGraph().size());
        Triple t = (Triple)dsg.getDefaultGraph().find(null, null, null).next();
        Triple t2 = SSE.parseTriple((String)"(<http://example/s> <http://example/p> 123)");
    }

    @Test
    public void trig_12() {
        TestLangTrig.parse("@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> .", "{ <x> <p> '1'^^xsd:byte }");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void trig_20() {
        TestLangTrig.parse("@prefix ex:  <bad iri> .", "{ ex:s ex:p 123 }");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void trig_21() {
        TestLangTrig.parse("@prefix ex:  <http://example/> .", "{ ex:s <http://example/broken p> 123 }");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void trig_22() {
        TestLangTrig.parse("{ <x> <p> 'number'^^<bad uri> }");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void trig_23() {
        TestLangTrig.parse("@prefix xsd:  <http://www.w3.org/2001/XMLSchema#> .", "{ <x> <p> 'number'^^xsd:byte }");
    }

    private static DatasetGraph parse(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        Sink sink = RiotLoader.datasetSink((DatasetGraph)dsg);
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString((String)string);
        LangTriG parser = RiotReader.createParserTriG((Tokenizer)tokenizer, (String)"http://base/", (Sink)sink);
        parser.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        parser.parse();
        return dsg;
    }
}

