/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.io.Reader;
import java.io.StringReader;
import org.junit.Test;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkCounting;
import org.openjena.atlas.lib.StrUtils;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerTestLib;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangNTriples;
import org.openjena.riot.lang.TestLangNTuples;
import org.openjena.riot.system.JenaReaderNTriples2;
import org.openjena.riot.system.RiotLib;
import org.openjena.riot.tokens.Tokenizer;

public class TestLangNTriples
extends TestLangNTuples {
    @Test
    public void nt_reader_twice() {
        String s = "_:a <p> 'foo' . ";
        StringReader r = new StringReader(s);
        Model m = ModelFactory.createDefaultModel();
        JenaReaderNTriples2 reader = new JenaReaderNTriples2();
        reader.read(m, (Reader)r, null);
        TestLangNTriples.assertEquals((long)1L, (long)m.size());
        String x = ((Statement)m.listStatements().next()).getSubject().getId().getLabelString();
        TestLangNTriples.assertNotEquals(x, "a");
        r = new StringReader(s);
        reader.read(m, (Reader)r, null);
        TestLangNTriples.assertEquals((long)2L, (long)m.size());
    }

    @Test
    public void nt_model_1() {
        Model m1 = this.parseToModel("<x> <p> \"abc-\\u00E9\". ");
        TestLangNTriples.assertEquals((long)1L, (long)m1.size());
        Model m2 = this.parseToModel("<x> <p> \"abc-\\u00E9\". ");
        TestLangNTriples.assertTrue((boolean)m1.isIsomorphicWith(m2));
        Graph g1 = SSE.parseGraph((String)"(graph (triple <x> <p> \"abc-\u00e9\"))");
        TestLangNTriples.assertTrue((boolean)g1.isIsomorphicWith(m1.getGraph()));
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_1() {
        this.parseCount("<x> <p> <s> <g> .");
    }

    @Test(expected=ErrorHandlerTestLib.ExFatal.class)
    public void nt_only_2() {
        this.parseCount("@base <http://example/> . <x> <p> <s> .");
    }

    @Test(expected=RiotException.class)
    public void nt_only_5() {
        this.parseCount("<x> <p> \"\u00e9\" .");
    }

    protected long parseCount(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNTriples.tokenizer(string);
        SinkCounting sink = new SinkCounting();
        LangNTriples x = RiotReader.createParserNTriples((Tokenizer)tokenizer, (Sink)sink);
        x.getProfile().setHandler((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
        x.parse();
        return sink.getCount();
    }

    protected void parseCheck(String ... strings) {
        String string = StrUtils.strjoin((String)"\n", (String[])strings);
        Tokenizer tokenizer = TestLangNTriples.tokenizer(string);
        SinkCounting sink = new SinkCounting();
        LangNTriples x = RiotReader.createParserNTriples((Tokenizer)tokenizer, (Sink)sink);
        x.setProfile(RiotLib.profile(null, (boolean)false, (boolean)true, (ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx()));
        x.parse();
    }

    protected Model parseToModel(String string) {
        StringReader r = new StringReader(string);
        Model model = ModelFactory.createDefaultModel();
        JenaReaderNTriples2 reader = new JenaReaderNTriples2();
        reader.read(model, (Reader)r, null);
        return model;
    }
}

