/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import org.junit.Test;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerTestLib;
import org.openjena.riot.checker.CheckerIRI;
import org.openjena.riot.system.Checker;

public class TestIRI {
    protected static final ErrorHandler handler = new ErrorHandlerTestLib.ErrorHandlerEx();
    protected static final Checker checker = new Checker((ErrorHandler)new ErrorHandlerTestLib.ErrorHandlerEx());
    static IRIFactory factory = IRIFactory.iriImplementation();

    @Test
    public void iri1() {
        this.test("http://example/");
    }

    @Test(expected=ErrorHandlerTestLib.ExError.class)
    public void iri2() {
        this.test("example");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriErr1() {
        this.test("http:");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriErr2() {
        this.test("http:///::");
    }

    @Test(expected=ErrorHandlerTestLib.ExWarning.class)
    public void iriErr3() {
        this.test("http://example/.");
    }

    private void test(String uriStr) {
        IRI iri = factory.create(uriStr);
        CheckerIRI.iriViolations((IRI)iri, (ErrorHandler)handler);
    }
}

