/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Hex;

public class TestHex
extends BaseTest {
    @Test
    public void hex_01() {
        byte[] b = new byte[16];
        TestHex.test(0L, 0, b, 16);
    }

    @Test
    public void hex_02() {
        byte[] b = new byte[16];
        TestHex.test(1L, 0, b, 16);
    }

    @Test
    public void hex_03() {
        byte[] b = new byte[16];
        TestHex.test(Long.MAX_VALUE, 0, b, 16);
    }

    @Test
    public void hex_04() {
        byte[] b = new byte[16];
        TestHex.test(Long.MIN_VALUE, 0, b, 16);
    }

    @Test
    public void hex_05() {
        byte[] b = new byte[16];
        TestHex.test(-1L, 0, b, 16);
    }

    @Test
    public void hex_06() {
        byte[] b = new byte[16];
        TestHex.test(-1L, 0, b, 16);
    }

    private static void test(long value, int idx, byte[] b, int width) {
        int x = Hex.formatUnsignedLongHex((byte[])b, (int)idx, (long)value, (int)width);
        TestHex.assertEquals((long)width, (long)x);
        for (int i = 0; i < width; ++i) {
            byte v = b[i];
            if (v >= 48 && v <= 57 || v >= 97 && v <= 102 || v >= 65 && v <= 70) continue;
            TestHex.fail((String)String.format("Not a hex digit: %02X", b[i]));
        }
        long v = Hex.getLong((byte[])b, (int)idx);
        TestHex.assertEquals((long)value, (long)v);
    }
}

