/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.io.File;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.IRILib;

public class TestFilenameProcessing
extends BaseTest {
    private static String cwd = new File(".").getAbsolutePath();
    static boolean isWindows;

    @Test
    public void encode_1() {
        TestFilenameProcessing.encodeComponent("abc", "abc");
    }

    @Test
    public void encode_2() {
        TestFilenameProcessing.encodeComponent("", "");
    }

    @Test
    public void encode_3() {
        TestFilenameProcessing.encodeComponent(":/", "%3A%2F");
    }

    @Test
    public void fileURL_1() {
        TestFilenameProcessing.assertNotEquals(cwd, "");
        TestFilenameProcessing.assertNotNull((Object)cwd);
        TestFilenameProcessing.filenameToIRI("abc", "file://" + cwd + "/abc");
    }

    @Test
    public void fileURL_2() {
        TestFilenameProcessing.filenameToIRI("/abc", "file:///abc");
    }

    @Test
    public void fileURL_3() {
        if (isWindows) {
            TestFilenameProcessing.filenameToIRI("c:/Program File/App File", "file:///c:/Program%20File/App%20File");
        } else {
            TestFilenameProcessing.filenameToIRI("/Program File/App File", "file:///Program%20File/App%20File");
        }
    }

    @Test
    public void fileURL_4() {
        if (isWindows) {
            TestFilenameProcessing.filenameToIRI("c:/Program File/App Dir/", "file:///c:/Program%20File/App%20Dir/");
        } else {
            TestFilenameProcessing.filenameToIRI("/Program File/App Dir/", "file:///Program%20File/App%20Dir/");
        }
    }

    @Test
    public void fileURL_5() {
        if (isWindows) {
            TestFilenameProcessing.filenameToIRI("c:\\Windows\\Path", "file:///c:/Windows/Path");
        } else {
            TestFilenameProcessing.filenameToIRI("c:\\Windows\\Path", "file://" + cwd + "/c:%5CWindows%5CPath");
        }
    }

    @Test
    public void fileURL_6() {
        TestFilenameProcessing.filenameToIRI("~user", "file://" + cwd + "/~user");
    }

    @Test
    public void fileURL_7() {
        TestFilenameProcessing.filenameToIRI(".", "file://" + cwd);
    }

    @Test
    public void fileURL_10() {
        TestFilenameProcessing.filenameToIRI("file:abc", "file://" + cwd + "/abc");
    }

    @Test
    public void fileURL_11() {
        TestFilenameProcessing.filenameToIRI("file:/abc", "file:///abc");
    }

    @Test
    public void fileURL_12() {
        TestFilenameProcessing.filenameToIRI("file:", "file://" + cwd);
    }

    @Test
    public void fileURL_13() {
        TestFilenameProcessing.filenameToIRI("file:.", "file://" + cwd + "");
    }

    @Test
    public void fileURL_14() {
        String x = cwd;
        if (isWindows) {
            x = x.replace('\\', '/');
        }
        x = cwd.replaceAll("/[^/]*$", "");
        TestFilenameProcessing.filenameToIRI("file:..", "file://" + x);
    }

    private static void encodeComponent(String string, String result) {
        String r = IRILib.encodeUriComponent((String)string);
        TestFilenameProcessing.assertEquals((Object)result, (Object)r);
    }

    private static void filenameToIRI(String string, String result) {
        String r = IRILib.filenameToIRI((String)string);
        TestFilenameProcessing.assertEquals((Object)result, (Object)r);
    }

    static {
        cwd = cwd.substring(0, cwd.length() - 2);
        isWindows = File.pathSeparator.equals(";");
    }
}

