/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import org.junit.Before;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheFactory;
import org.openjena.atlas.lib.CacheStats;
import org.openjena.atlas.lib.cache.CacheStatsAtomic;

public class TestCacheStats
extends BaseTest {
    Cache<Integer, Integer> cache;

    @Before
    public void before() {
        this.cache = CacheFactory.createSimpleCache((int)2);
    }

    @Test
    public void stats_01() {
        this.cache.clear();
        this.cache = new CacheStatsAtomic(this.cache);
        CacheStats cs = (CacheStats)this.cache;
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheEntries());
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheMisses());
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheHits());
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheEjects());
    }

    @Test
    public void stats_02() {
        this.cache.clear();
        this.cache = new CacheStatsAtomic(this.cache);
        CacheStats cs = (CacheStats)this.cache;
        this.cache.put((Object)7, (Object)77);
        TestCacheStats.assertEquals((long)1L, (long)cs.getCacheEntries());
        this.cache.remove((Object)7);
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheEntries());
        this.cache.clear();
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheEntries());
    }

    @Test
    public void stats_03() {
        this.cache.clear();
        this.cache = new CacheStatsAtomic(this.cache);
        CacheStats cs = (CacheStats)this.cache;
        this.cache.put((Object)7, (Object)77);
        this.cache.put((Object)8, (Object)88);
        TestCacheStats.assertEquals((long)2L, (long)cs.getCacheEntries());
        this.cache.remove((Object)7);
        TestCacheStats.assertEquals((long)1L, (long)cs.getCacheEntries());
        this.cache.clear();
        TestCacheStats.assertEquals((long)0L, (long)cs.getCacheEntries());
    }

    @Test
    public void stats_04() {
        this.cache.clear();
        this.cache = new CacheStatsAtomic(this.cache);
        CacheStats cs = (CacheStats)this.cache;
        this.cache.put((Object)7, (Object)77);
        this.cache.get((Object)7);
        TestCacheStats.assertEquals((long)1L, (long)cs.getCacheHits());
        this.cache.get((Object)7);
        TestCacheStats.assertEquals((long)2L, (long)cs.getCacheHits());
    }
}

