/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.junit.BaseTest;
import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheFactory;
import org.openjena.atlas.lib.cache.CacheStatsAtomic;
import org.openjena.atlas.lib.cache.CacheStatsSimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class TestCache
extends BaseTest {
    private static CacheMaker<Integer, Integer> simple = new CacheMaker<Integer, Integer>(){

        @Override
        public Cache<Integer, Integer> make(int size) {
            return CacheFactory.createSimpleCache((int)size);
        }

        @Override
        public String name() {
            return "Simple";
        }
    };
    private static CacheMaker<Integer, Integer> standard = new CacheMaker<Integer, Integer>(){

        @Override
        public Cache<Integer, Integer> make(int size) {
            return CacheFactory.createCache((int)size);
        }

        @Override
        public String name() {
            return "Standard";
        }
    };
    private static CacheMaker<Integer, Integer> syncStandard = new CacheMaker<Integer, Integer>(){

        @Override
        public Cache<Integer, Integer> make(int size) {
            return CacheFactory.createSync(standard.make(size));
        }

        @Override
        public String name() {
            return "Sync Standard";
        }
    };
    private static CacheMaker<Integer, Integer> stats = new CacheMaker<Integer, Integer>(){

        @Override
        public Cache<Integer, Integer> make(int size) {
            Cache c = CacheFactory.createCache((int)size);
            return new CacheStatsSimple(c);
        }

        @Override
        public String name() {
            return "Stats";
        }
    };
    private static CacheMaker<Integer, Integer> statsAtomic = new CacheMaker<Integer, Integer>(){

        @Override
        public Cache<Integer, Integer> make(int size) {
            Cache c = CacheFactory.createCache((int)size);
            return new CacheStatsAtomic(c);
        }

        @Override
        public String name() {
            return "StatsAtomic";
        }
    };
    Cache<Integer, Integer> cache;
    CacheMaker<Integer, Integer> cacheMaker;
    int size;

    @Parameterized.Parameters
    public static Collection<Object[]> cacheMakers() {
        return Arrays.asList({simple, 10}, {simple, 2}, {simple, 1}, {standard, 10}, {standard, 2}, {standard, 1}, {syncStandard, 10}, {syncStandard, 2}, {syncStandard, 1}, {stats, 10}, {stats, 2}, {stats, 1}, {statsAtomic, 10}, {statsAtomic, 2}, {statsAtomic, 1});
    }

    public TestCache(CacheMaker<Integer, Integer> cacheMaker, int size) {
        this.cacheMaker = cacheMaker;
        this.size = size;
    }

    @Before
    public void before() {
        this.cache = this.cacheMaker.make(this.size);
    }

    @Test
    public void cache_00() {
        TestCache.assertEquals((long)0L, (long)this.cache.size());
        TestCache.assertTrue((boolean)this.cache.isEmpty());
    }

    @Test
    public void cache_01() {
        Integer x = (Integer)this.cache.put((Object)7, (Object)7);
        TestCache.assertEquals((long)1L, (long)this.cache.size());
        TestCache.assertNull((Object)x);
        TestCache.assertTrue((boolean)this.cache.containsKey((Object)7));
        TestCache.assertEquals((Object)7, (Object)this.cache.get((Object)7));
    }

    @Test
    public void cache_02() {
        Integer x1 = (Integer)this.cache.put((Object)7, (Object)7);
        Integer x2 = (Integer)this.cache.put((Object)8, (Object)8);
        if (this.size > 2) {
            TestCache.assertEquals((long)2L, (long)this.cache.size());
        }
        TestCache.assertNull((Object)x1);
        if (this.size > 2) {
            TestCache.assertNull((Object)x2);
        }
        if (this.size > 2) {
            TestCache.assertTrue((boolean)this.cache.containsKey((Object)7));
        }
        if (this.size > 2) {
            TestCache.assertEquals((Object)7, (Object)this.cache.get((Object)7));
        }
        TestCache.assertTrue((boolean)this.cache.containsKey((Object)8));
        TestCache.assertEquals((Object)8, (Object)this.cache.get((Object)8));
    }

    @Test
    public void cache_03() {
        Integer x1 = (Integer)this.cache.put((Object)7, (Object)7);
        Integer x2 = (Integer)this.cache.put((Object)7, (Object)18);
        TestCache.assertEquals((long)1L, (long)this.cache.size());
        TestCache.assertEquals((long)7L, (long)x2.intValue());
        TestCache.assertTrue((boolean)this.cache.containsKey((Object)7));
        TestCache.assertEquals((Object)18, (Object)this.cache.get((Object)7));
    }

    @Test
    public void cache_04() {
        this.cache.clear();
        this.cache.put((Object)7, (Object)77);
        List x = Iter.toList((Iterator)this.cache.keys());
        TestCache.assertEquals((long)1L, (long)x.size());
        TestCache.assertEquals((Object)7, x.get(0));
    }

    @Test
    public void cache_05() {
        this.cache.clear();
        this.cache.put((Object)7, (Object)77);
        this.cache.clear();
        TestCache.assertEquals((long)0L, (long)this.cache.size());
        TestCache.assertTrue((boolean)this.cache.isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CacheMaker<K, V> {
        public Cache<K, V> make(int var1);

        public String name();
    }
}

