/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json;

import org.junit.Test;
import org.openjena.atlas.json.JsonString;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.LibJsonTest;
import org.openjena.atlas.junit.BaseTest;

public class TestJsonWriter
extends BaseTest {
    @Test
    public void js_write_str_1() {
        TestJsonWriter.test("foo");
    }

    @Test
    public void js_write_str_2() {
        TestJsonWriter.test("foo bar");
    }

    @Test
    public void js_write_str_3() {
        TestJsonWriter.test("foo\nbar");
    }

    @Test
    public void js_write_str_4() {
        TestJsonWriter.test("x\ty", "\"x\\ty\"");
    }

    @Test
    public void js_write_str_5() {
        TestJsonWriter.test("\r", "\"\\r\"");
    }

    @Test
    public void js_write_str_6() {
        TestJsonWriter.test("\u0000", "\"\\u0000\"");
    }

    @Test
    public void js_write_str_7() {
        TestJsonWriter.test("\u0001", "\"\\u0001\"");
    }

    @Test
    public void js_write_str_8() {
        TestJsonWriter.test("\u001f", "\"\\u001F\"");
    }

    @Test
    public void js_write_str_9() {
        TestJsonWriter.test("\u007f", "\"\\u007F\"");
    }

    @Test
    public void js_write_str_10() {
        TestJsonWriter.test("\u009f", "\"\\u009F\"");
    }

    @Test
    public void js_write_str_11() {
        TestJsonWriter.test("\u2001", "\"\\u2001\"");
    }

    private static void test(String str, String expected) {
        JsonString v = new JsonString(str);
        str = v.toString();
        TestJsonWriter.assertEquals((Object)expected, (Object)str);
    }

    private static void test(String str) {
        JsonString v = new JsonString(str);
        LibJsonTest.writeRead((JsonValue)v);
    }
}

