/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.openjena.atlas.iterator.IteratorWithHistory;
import org.openjena.atlas.junit.BaseTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestIteratorWithHistory
extends BaseTest {
    @Test
    public void iterHistory_01() {
        IteratorWithHistory<String> iter = this.createHistory(1, "a", "b", "c");
        TestIteratorWithHistory.assertEquals((long)0L, (long)iter.currentSize());
        TestIteratorWithHistory.assertEquals(null, (Object)iter.getPrevious(0));
    }

    @Test
    public void iterHistory_02() {
        IteratorWithHistory<String> iter = this.createHistory(1, "a", "b", "c");
        TestIteratorWithHistory.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorWithHistory.assertEquals((long)1L, (long)iter.currentSize());
    }

    @Test
    public void iterHistory_03() {
        IteratorWithHistory<String> iter = this.createHistory(2, "a", "b", "c");
        TestIteratorWithHistory.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorWithHistory.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorWithHistory.assertEquals((long)2L, (long)iter.currentSize());
        TestIteratorWithHistory.assertEquals((Object)"b", (Object)iter.getPrevious(0));
        TestIteratorWithHistory.assertEquals((Object)"a", (Object)iter.getPrevious(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void iterHistory_04() {
        IteratorWithHistory<String> iter = this.createHistory(2, "a", "b", "c");
        iter.getPrevious(2);
    }

    @Test
    public void iterHistory_05() {
        IteratorWithHistory<String> iter = this.createHistory(2, "a", "b", "c");
        TestIteratorWithHistory.assertEquals((Object)"a", (Object)iter.next());
        TestIteratorWithHistory.assertEquals((Object)"a", (Object)iter.getPrevious(0));
        TestIteratorWithHistory.assertEquals((long)1L, (long)iter.currentSize());
        TestIteratorWithHistory.assertEquals((Object)"b", (Object)iter.next());
        TestIteratorWithHistory.assertEquals((Object)"b", (Object)iter.getPrevious(0));
        TestIteratorWithHistory.assertEquals((Object)"a", (Object)iter.getPrevious(1));
        TestIteratorWithHistory.assertEquals((long)2L, (long)iter.currentSize());
        TestIteratorWithHistory.assertEquals((Object)"c", (Object)iter.next());
        TestIteratorWithHistory.assertEquals((long)2L, (long)iter.currentSize());
        TestIteratorWithHistory.assertEquals((Object)"c", (Object)iter.getPrevious(0));
        TestIteratorWithHistory.assertEquals((Object)"b", (Object)iter.getPrevious(1));
    }

    private IteratorWithHistory<String> createHistory(int N, String ... strings) {
        List<String> data = Arrays.asList(strings);
        IteratorWithHistory iter = new IteratorWithHistory(data.iterator(), N);
        return iter;
    }
}

