/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.graph.GNode;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;

public class TestList
extends TestCase {
    private GNode emptyList = TestList.parse(listStr_1);
    private GNode list4 = TestList.parse(listStr_2);
    private GNode list22 = TestList.parse(listStr_3);
    private Node NIL = RDF.nil.asNode();
    private static Node node1 = Node.createLiteral((String)"1", (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node2 = Node.createLiteral((String)"2", (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node3 = Node.createLiteral((String)"3", (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node4 = Node.createLiteral((String)"4", (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node node0 = Node.createLiteral((String)"0", (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    private static Node r = Node.createURI((String)"http://example/r");
    private static Node p = Node.createURI((String)"http://example/p");
    private static String preamble = "@prefix : <http://example/> . :r :p ";
    private static String listStr_1 = preamble + "() .";
    private static String listStr_2 = preamble + "(1 2 3 4) .";
    private static String listStr_3 = preamble + "(1 2 1 2) .";

    public static Test suite() {
        return new JUnit4TestAdapter(TestList.class);
    }

    @org.junit.Test
    public void testListLength_1() {
        TestList.assertEquals((int)0, (int)GraphList.length((GNode)this.emptyList));
    }

    @org.junit.Test
    public void testListLength_2() {
        TestList.assertEquals((int)4, (int)GraphList.length((GNode)this.list4));
    }

    @org.junit.Test
    public void testListLength_3() {
        TestList.assertEquals((int)4, (int)GraphList.length((GNode)this.list22));
    }

    @org.junit.Test
    public void testListIndex_1() {
        TestList.assertEquals((int)0, (int)GraphList.index((GNode)this.list4, (Node)node1));
    }

    @org.junit.Test
    public void testListIndex_2() {
        TestList.assertEquals((int)1, (int)GraphList.index((GNode)this.list4, (Node)node2));
    }

    @org.junit.Test
    public void testListIndex_3() {
        TestList.assertEquals((int)2, (int)GraphList.index((GNode)this.list4, (Node)node3));
    }

    @org.junit.Test
    public void testListIndex_4() {
        TestList.assertEquals((int)3, (int)GraphList.index((GNode)this.list4, (Node)node4));
    }

    @org.junit.Test
    public void testListIndex_5() {
        TestList.assertEquals((int)-1, (int)GraphList.index((GNode)this.list4, (Node)node0));
    }

    @org.junit.Test
    public void testListIndex_6() {
        TestList.assertEquals((int)-1, (int)GraphList.index((GNode)this.emptyList, (Node)node1));
    }

    @org.junit.Test
    public void testListIndex_7() {
        TestList.assertEquals((int)0, (int)GraphList.index((GNode)this.list22, (Node)node1));
    }

    @org.junit.Test
    public void testListIndex_8() {
        TestList.assertEquals((int)1, (int)GraphList.index((GNode)this.list22, (Node)node2));
    }

    @org.junit.Test
    public void testListIndexes_1() {
        List x = GraphList.indexes((GNode)this.emptyList, (Node)node0);
        TestList.assertEquals((int)0, (int)x.size());
    }

    @org.junit.Test
    public void testListIndexes_2() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node0);
        TestList.assertEquals((int)0, (int)x.size());
    }

    @org.junit.Test
    public void testListIndexes_3() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node1);
        TestList.assertEquals((int)1, (int)x.size());
        TestList.assertEquals((int)0, (int)((Integer)x.get(0)));
    }

    @org.junit.Test
    public void testListIndexes_4() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node2);
        TestList.assertEquals((int)1, (int)x.size());
        TestList.assertEquals((int)1, (int)((Integer)x.get(0)));
    }

    @org.junit.Test
    public void testListIndexes_5() {
        List x = GraphList.indexes((GNode)this.list4, (Node)node4);
        TestList.assertEquals((int)1, (int)x.size());
        TestList.assertEquals((int)3, (int)((Integer)x.get(0)));
    }

    @org.junit.Test
    public void testListIndexes_6() {
        List x = GraphList.indexes((GNode)this.list22, (Node)node1);
        TestList.assertEquals((int)2, (int)x.size());
        TestList.assertEquals((int)0, (int)((Integer)x.get(0)));
        TestList.assertEquals((int)2, (int)((Integer)x.get(1)));
    }

    @org.junit.Test
    public void testListTriples_1() {
        TestList.assertEquals((int)0, (int)GraphList.allTriples((GNode)this.emptyList).size());
    }

    @org.junit.Test
    public void testListTriples_2() {
        TestList.assertEquals((int)8, (int)GraphList.allTriples((GNode)this.list4).size());
    }

    @org.junit.Test
    public void testListContains_1() {
        TestList.assertFalse((boolean)GraphList.contains((GNode)this.emptyList, (Node)node0));
    }

    @org.junit.Test
    public void testListContains_2() {
        TestList.assertFalse((boolean)GraphList.contains((GNode)this.emptyList, (Node)node1));
    }

    @org.junit.Test
    public void testListContains_3() {
        TestList.assertTrue((boolean)GraphList.contains((GNode)this.list4, (Node)node1));
    }

    @org.junit.Test
    public void testListContains_4() {
        TestList.assertTrue((boolean)GraphList.contains((GNode)this.list4, (Node)node2));
    }

    @org.junit.Test
    public void testListContains_5() {
        TestList.assertTrue((boolean)GraphList.contains((GNode)this.list4, (Node)node4));
    }

    @org.junit.Test
    public void testListOccurs_1() {
        TestList.assertEquals((int)0, (int)GraphList.occurs((GNode)this.emptyList, (Node)node0));
    }

    @org.junit.Test
    public void testListOccurs_2() {
        TestList.assertEquals((int)0, (int)GraphList.occurs((GNode)this.emptyList, (Node)node1));
    }

    @org.junit.Test
    public void testListOccurs_3() {
        TestList.assertEquals((int)0, (int)GraphList.occurs((GNode)this.list4, (Node)node0));
    }

    @org.junit.Test
    public void testListOccurs_4() {
        TestList.assertEquals((int)0, (int)GraphList.occurs((GNode)this.emptyList, (Node)node1));
    }

    @org.junit.Test
    public void testListOccurs_5() {
        TestList.assertEquals((int)0, (int)GraphList.occurs((GNode)this.emptyList, (Node)this.NIL));
    }

    @org.junit.Test
    public void testListOccurs_6() {
        TestList.assertEquals((int)0, (int)GraphList.occurs((GNode)this.list4, (Node)this.NIL));
    }

    @org.junit.Test
    public void testListOccurs_7() {
        TestList.assertEquals((int)1, (int)GraphList.occurs((GNode)this.list4, (Node)node1));
    }

    @org.junit.Test
    public void testListOccurs_8() {
        TestList.assertEquals((int)1, (int)GraphList.occurs((GNode)this.list4, (Node)node2));
    }

    @org.junit.Test
    public void testListOccurs_9() {
        TestList.assertEquals((int)1, (int)GraphList.occurs((GNode)this.list4, (Node)node3));
    }

    @org.junit.Test
    public void testListOccurs_10() {
        TestList.assertEquals((int)1, (int)GraphList.occurs((GNode)this.list4, (Node)node4));
    }

    @org.junit.Test
    public void testListOccurs_11() {
        TestList.assertEquals((int)2, (int)GraphList.occurs((GNode)this.list22, (Node)node1));
    }

    @org.junit.Test
    public void testListOccurs_12() {
        TestList.assertEquals((int)2, (int)GraphList.occurs((GNode)this.list22, (Node)node2));
    }

    @org.junit.Test
    public void testListGet_1() {
        TestList.assertNull((Object)GraphList.get((GNode)this.emptyList, (int)0));
    }

    @org.junit.Test
    public void testListGet_2() {
        TestList.assertNull((Object)GraphList.get((GNode)this.emptyList, (int)-1));
    }

    @org.junit.Test
    public void testListGet_3() {
        TestList.assertNull((Object)GraphList.get((GNode)this.list4, (int)-1));
    }

    @org.junit.Test
    public void testListGet_4() {
        TestList.assertNull((Object)GraphList.get((GNode)this.list4, (int)9));
    }

    @org.junit.Test
    public void testListGet_5() {
        TestList.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list4, (int)0));
    }

    @org.junit.Test
    public void testListGet_6() {
        TestList.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list4, (int)0));
        TestList.assertEquals((Object)node2, (Object)GraphList.get((GNode)this.list4, (int)1));
        TestList.assertEquals((Object)node3, (Object)GraphList.get((GNode)this.list4, (int)2));
        TestList.assertEquals((Object)node4, (Object)GraphList.get((GNode)this.list4, (int)3));
    }

    @org.junit.Test
    public void testListGet_7() {
        TestList.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list22, (int)0));
        TestList.assertEquals((Object)node2, (Object)GraphList.get((GNode)this.list22, (int)1));
        TestList.assertEquals((Object)node1, (Object)GraphList.get((GNode)this.list22, (int)2));
        TestList.assertEquals((Object)node2, (Object)GraphList.get((GNode)this.list22, (int)3));
    }

    private static GNode gnode(Node n) {
        return new GNode(Factory.createDefaultGraph(), n);
    }

    private static GNode parse(String str) {
        Model m = ModelFactory.createDefaultModel();
        m.read((Reader)new StringReader(str), null, "TTL");
        Graph graph = m.getGraph();
        Triple t = (Triple)graph.find(r, p, Node.ANY).next();
        return new GNode(graph, t.getObject());
    }
}

