/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.util.DateTimeStruct;
import junit.framework.TestCase;
import org.junit.Test;

public class TestDateTimeParsing
extends TestCase {
    @Test
    public void testDT_1() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56Z");
    }

    @Test
    public void testDT_2() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56");
    }

    @Test
    public void testDT_3() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56.003");
    }

    @Test
    public void testDT_4() {
        TestDateTimeParsing.dateTimeTest("2007-08-31T12:34:56.003+05:00");
    }

    @Test
    public void testDT_5() {
        TestDateTimeParsing.dateTimeTest("-2007-08-31T12:34:56.003-05:00");
    }

    @Test
    public void testDT_6() {
        TestDateTimeParsing.dateTimeTest("-2007-08-31T12:34:56");
    }

    @Test
    public void testDT_7() {
        TestDateTimeParsing.dateTimeBad("+2007-08-31T12:34:56");
    }

    @Test
    public void testDT_8() {
        TestDateTimeParsing.dateTimeBad("2007-08-31");
    }

    @Test
    public void testDT_10() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime((String)"2007-08-31T12:34:56");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", "12", "34", "56", null);
    }

    @Test
    public void testDT_11() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime((String)"2007-08-31T12:34:56Z");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", "12", "34", "56", "Z");
    }

    @Test
    public void testDT_12() {
        DateTimeStruct dt = DateTimeStruct.parseDateTime((String)"-2007-08-31T12:34:56.003-05:00");
        TestDateTimeParsing.check(dt, "-", "2007", "08", "31", "12", "34", "56.003", "-05:00");
    }

    @Test
    public void testD_1() {
        TestDateTimeParsing.dateTest("2007-08-31Z");
    }

    @Test
    public void testD_2() {
        TestDateTimeParsing.dateTest("2007-08-31");
    }

    @Test
    public void testD_10() {
        DateTimeStruct dt = DateTimeStruct.parseDate((String)"2007-08-31");
        TestDateTimeParsing.check(dt, null, "2007", "08", "31", null);
    }

    @Test
    public void testGYear_1() {
        DateTimeStruct dt = DateTimeStruct.parseGYear((String)"2007");
        TestDateTimeParsing.check(dt, null, "2007", null, null, null);
    }

    @Test
    public void testGYear_2() {
        DateTimeStruct dt = DateTimeStruct.parseGYear((String)"2007Z");
        TestDateTimeParsing.check(dt, null, "2007", null, null, "Z");
    }

    @Test
    public void testGYear_3() {
        DateTimeStruct dt = DateTimeStruct.parseGYear((String)"2007+08:00");
        TestDateTimeParsing.check(dt, null, "2007", null, null, "+08:00");
    }

    @Test
    public void testGYearMonth_1() {
        DateTimeStruct dt = DateTimeStruct.parseGYearMonth((String)"2007-10");
        TestDateTimeParsing.check(dt, null, "2007", "10", null, null);
    }

    @Test
    public void testGYearMonth_2() {
        DateTimeStruct dt = DateTimeStruct.parseGYearMonth((String)"2007-10Z");
        TestDateTimeParsing.check(dt, null, "2007", "10", null, "Z");
    }

    @Test
    public void testGYearMonth_3() {
        DateTimeStruct dt = DateTimeStruct.parseGYearMonth((String)"2007-10-08:00");
        TestDateTimeParsing.check(dt, null, "2007", "10", null, "-08:00");
    }

    @Test
    public void testGMonth_1() {
        DateTimeStruct dt = DateTimeStruct.parseGMonth((String)"--10");
        TestDateTimeParsing.check(dt, null, null, "10", null, null);
    }

    @Test
    public void testGMonth_2() {
        DateTimeStruct dt = DateTimeStruct.parseGMonth((String)"--10Z");
        TestDateTimeParsing.check(dt, null, null, "10", null, "Z");
    }

    @Test
    public void testGMonth_3() {
        DateTimeStruct dt = DateTimeStruct.parseGMonth((String)"--10-08:00");
        TestDateTimeParsing.check(dt, null, null, "10", null, "-08:00");
    }

    @Test
    public void testGMonthDay_1() {
        DateTimeStruct dt = DateTimeStruct.parseGMonthDay((String)"--10-31");
        TestDateTimeParsing.check(dt, null, null, "10", "31", null);
    }

    @Test
    public void testGMonthDay_2() {
        DateTimeStruct dt = DateTimeStruct.parseGMonthDay((String)"--10-31Z");
        TestDateTimeParsing.check(dt, null, null, "10", "31", "Z");
    }

    @Test
    public void testGMonthDay_3() {
        DateTimeStruct dt = DateTimeStruct.parseGMonthDay((String)"--10-31-08:00");
        TestDateTimeParsing.check(dt, null, null, "10", "31", "-08:00");
    }

    @Test
    public void testGDay_1() {
        DateTimeStruct dt = DateTimeStruct.parseGDay((String)"---31");
        TestDateTimeParsing.check(dt, null, null, null, "31", null);
    }

    @Test
    public void testGDay_2() {
        DateTimeStruct dt = DateTimeStruct.parseGDay((String)"---31Z");
        TestDateTimeParsing.check(dt, null, null, null, "31", "Z");
    }

    @Test
    public void testGDay_3() {
        DateTimeStruct dt = DateTimeStruct.parseGDay((String)"---31-08:00");
        TestDateTimeParsing.check(dt, null, null, null, "31", "-08:00");
    }

    private static void dateTimeTest(String str) {
        DateTimeStruct dt = DateTimeStruct.parseDateTime((String)str);
        TestDateTimeParsing.assertTrue((boolean)dt.xsdDateTime);
        TestDateTimeParsing.check(dt);
        TestDateTimeParsing.assertEquals((String)str, (String)dt.toString());
    }

    private static void dateTimeBad(String str) {
        try {
            DateTimeStruct dt = DateTimeStruct.parseDateTime((String)str);
            TestDateTimeParsing.fail((String)("No exception; " + str));
        }
        catch (DateTimeStruct.DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    private static void dateTest(String str) {
        DateTimeStruct dt = DateTimeStruct.parseDate((String)str);
        TestDateTimeParsing.assertFalse((boolean)dt.xsdDateTime);
        TestDateTimeParsing.check(dt);
        TestDateTimeParsing.assertEquals((String)str, (String)dt.toString());
    }

    private static void dateBad(String str) {
        try {
            DateTimeStruct dt = DateTimeStruct.parseDateTime((String)str);
            TestDateTimeParsing.fail((String)("No exception; " + str));
        }
        catch (DateTimeStruct.DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    private static void check(DateTimeStruct dt) {
        TestDateTimeParsing.assertTrue((dt.neg == null || dt.neg.equals("-") ? 1 : 0) != 0);
        if (dt.year != null) {
            TestDateTimeParsing.assertEquals((int)4, (int)dt.year.length());
        }
        if (dt.month != null) {
            TestDateTimeParsing.assertEquals((int)2, (int)dt.month.length());
        }
        if (dt.day != null) {
            TestDateTimeParsing.assertEquals((int)2, (int)dt.day.length());
        }
        if (dt.xsdDateTime) {
            TestDateTimeParsing.assertNotNull((Object)dt.hour);
            TestDateTimeParsing.assertEquals((int)2, (int)dt.hour.length());
            TestDateTimeParsing.assertNotNull((Object)dt.minute);
            TestDateTimeParsing.assertEquals((int)2, (int)dt.minute.length());
            TestDateTimeParsing.assertNotNull((Object)dt.second);
            TestDateTimeParsing.assertTrue((dt.hour.length() >= 0 ? 1 : 0) != 0);
        } else {
            TestDateTimeParsing.assertNull((Object)dt.hour);
            TestDateTimeParsing.assertNull((Object)dt.minute);
            TestDateTimeParsing.assertNull((Object)dt.second);
        }
        TestDateTimeParsing.assertTrue((dt.timezone == null || dt.timezone.equals("Z") || dt.timezone.length() == 6 ? 1 : 0) != 0);
    }

    private static void check(DateTimeStruct dt, String neg, String year, String month, String day, String hour, String minute, String second, String timezone) {
        TestDateTimeParsing.check(dt);
        TestDateTimeParsing.assertEquals((String)neg, (String)dt.neg);
        TestDateTimeParsing.assertEquals((String)year, (String)dt.year);
        TestDateTimeParsing.assertEquals((String)month, (String)dt.month);
        TestDateTimeParsing.assertEquals((String)day, (String)dt.day);
        TestDateTimeParsing.assertEquals((String)hour, (String)dt.hour);
        TestDateTimeParsing.assertEquals((String)minute, (String)dt.minute);
        TestDateTimeParsing.assertEquals((String)second, (String)dt.second);
        TestDateTimeParsing.assertEquals((String)timezone, (String)dt.timezone);
    }

    private static void check(DateTimeStruct dt, String neg, String year, String month, String day, String timezone) {
        TestDateTimeParsing.check(dt, neg, year, month, day, null, null, null, timezone);
    }
}

