/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSSE_Forms
extends TestCase {
    static PrefixMapping pmap = new PrefixMappingImpl();

    @BeforeClass
    public static void beforeClass() {
        SSE.getDefaultPrefixMapRead().removeNsPrefix("");
        SSE.getDefaultPrefixMapRead().removeNsPrefix("ex");
    }

    @AfterClass
    public static void afterClass() {
        SSE.getDefaultPrefixMapRead().setNsPrefix("", "http://example/");
        SSE.getDefaultPrefixMapRead().setNsPrefix("ex", "http://example/ns#");
    }

    @Test
    public void testBase_01() {
        Item r = Item.createNode((Node)Node.createURI((String)"http://example/x"));
        this.testItem("(base <http://example/> <x>)", r);
    }

    @Test
    public void testBase_02() {
        Item r = Item.createNode((Node)Node.createURI((String)"http://example/x"));
        this.testItem("(base <http://HOST/> (base <http://example/xyz> <x>))", r);
    }

    @Test
    public void testBase_03() {
        Item r = SSE.parse((String)"(1 <http://example/xyz>)", null);
        this.testItem("(base <http://example/> (1 <xyz>))", r);
    }

    @Test
    public void testBase_04() {
        Item r = SSE.parse((String)"(1 <http://example/xyz>)", null);
        this.testItem("(1 (base <http://example/> <xyz>))", r);
    }

    @Test
    public void testBase_05() {
        Item r = SSE.parse((String)"(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("((base <http://example/> <xyz>) (base <http://EXAMPLE/other> <#foo>))", r);
    }

    @Test
    public void testBase_06() {
        Item r = SSE.parse((String)"(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("(base <http://example/> (<xyz> (base <http://EXAMPLE/other> <#foo>)))", r);
    }

    @Test
    public void testBase_07() {
        Item r = SSE.parse((String)"(<http://example/xyz> <http://EXAMPLE/other#foo>)", null);
        this.testItem("(base <http://EXAMPLE/other#> ((base <http://example/> <xyz>) <#foo>))", r);
    }

    @Test
    public void testPrefix_01() {
        Item r = Item.createNode((Node)Node.createURI((String)"http://example/abc"));
        this.testItem("(prefix ((ex: <http://example/>)) ex:abc)", r);
    }

    @Test
    public void testPrefix_02() {
        Item r = Item.createNode((Node)Node.createURI((String)"http://EXAMPLE/abc"));
        this.testItem("(prefix ((ex: <http://example/>)) (prefix ((ex: <http://EXAMPLE/>)) ex:abc))", r);
    }

    @Test
    public void testPrefix_03() {
        Item r = SSE.parse((String)"(<http://example/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) (ex:abc))", r);
    }

    @Test
    public void testPrefix_04() {
        Item r = SSE.parse((String)"(<http://EXAMPLE/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) ( (prefix ((ex: <http://EXAMPLE/>)) ex:abc) ))", r);
    }

    @Test
    public void testPrefix_05() {
        Item r = SSE.parse((String)"(<http://example/abc>)", null);
        this.testItem("(prefix ((ex: <http://example/>)) ( (prefix ((x: <http://EXAMPLE/>)) ex:abc) ))", r);
    }

    @Test
    public void testForm_01() {
        Item item = SSE.parse((String)"(prefix ((ex: <http://example/>)))");
        TestSSE_Forms.assertNull((Object)item);
    }

    @Test
    public void testForm_02() {
        Item item = SSE.parse((String)"(base <http://example/>)");
        TestSSE_Forms.assertNull((Object)item);
    }

    @Test
    public void testTypedLit_r1() {
        Node node = Node.createLiteral((String)"3", null, (RDFDatatype)XSDDatatype.XSDinteger);
        this.testItem("'3'^^xsd:integer", Item.createNode((Node)node));
    }

    @Test
    public void testBasePrefix_01() {
        Item r = SSE.parse((String)"<http://example/abc>", null);
        this.testItem("(base <http://example/> (prefix ((x: <>)) x:abc) )", r);
    }

    private void testItem(String str, Item result) {
        Item item = SSE.parse((String)str);
        TestSSE_Forms.assertEquals((Object)result, (Object)item);
    }

    static {
        pmap.setNsPrefix("xsd", XSD.getURI());
        pmap.setNsPrefix("ex", "http://example/");
    }
}

