/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemException;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import junit.framework.TestCase;
import org.junit.Test;

public class TestSSE_Basic
extends TestCase {
    static Node int1 = Node.createLiteral((String)"1", null, (RDFDatatype)XSDDatatype.XSDinteger);
    static Node int2 = Node.createLiteral((String)"2", null, (RDFDatatype)XSDDatatype.XSDinteger);
    static Node int3 = Node.createLiteral((String)"3", null, (RDFDatatype)XSDDatatype.XSDinteger);
    static Node strLangEN = Node.createLiteral((String)"xyz", (String)"en", null);
    static Node typeLit1 = NodeFactory.createLiteralNode((String)"123", null, (String)"http://example/type");
    static Item int1i = Item.createNode((Node)int1);
    static Item int2i = Item.createNode((Node)int2);
    static Item int3i = Item.createNode((Node)int3);

    @Test
    public void testParseTerm_01() {
        this.parse("'xyz'");
    }

    @Test
    public void testParseTerm_02() {
        this.parse("'xyz'@en");
    }

    @Test
    public void testParseTerm_03() {
        this.parseBad("'xyz' @en");
    }

    @Test
    public void testParseSymbol_01() {
        this.parse("a");
    }

    @Test
    public void testParseSymbol_02() {
        this.parseBad("'a");
    }

    @Test
    public void testParseSymbol_04() {
        this.parse("a@");
    }

    @Test
    public void testParseList_01() {
        this.parse("()");
    }

    @Test
    public void testParseList_02() {
        this.parse("(a)");
    }

    @Test
    public void testParseList_03() {
        this.parse(" (a)");
    }

    @Test
    public void testParseList_04() {
        this.parse("( a)");
    }

    @Test
    public void testParseList_05() {
        this.parse("(a )");
    }

    @Test
    public void testParseList_06() {
        this.parse("(a) ");
    }

    @Test
    public void testParseList_07() {
        this.parse("('a') ");
    }

    @Test
    public void testParseList_08() {
        this.parse("(<a>) ");
    }

    @Test
    public void testParse_10() {
        this.parseBad("'foo' @en");
    }

    @Test
    public void testLit_01() {
        this.testNode("'foo'");
    }

    @Test
    public void testLit_02() {
        this.testNode("\"foo\"");
    }

    @Test
    public void testLit_03() {
        this.testNode("''");
    }

    @Test
    public void testLit_04() {
        this.testNode("\"\"");
    }

    @Test
    public void testLit_05() {
        this.testNode("'foo'@en");
    }

    @Test
    public void testLit_06() {
        this.parseBad("'foo' @en");
    }

    @Test
    public void testLit_07() {
        this.parseBad("'");
    }

    @Test
    public void testLit_08() {
        this.parseBad("'\"");
    }

    @Test
    public void testLit_09() {
        this.parseBad("'''");
    }

    @Test
    public void testLit_10() {
        this.parseBad("''@");
    }

    @Test
    public void testLit_11() {
        this.testNode("'''abc\\ndef'''");
    }

    @Test
    public void testLit_12() {
        Node n = Node.createLiteral((String)"A\tB");
        this.testNode("'''A\\tB'''", n);
    }

    @Test
    public void testLit_13() {
        this.testNode("'abc\\ndef'");
    }

    @Test
    public void testNum_1() {
        this.testNode("1");
    }

    @Test
    public void testNum_2() {
        this.testNode("1.1");
    }

    @Test
    public void testNum_3() {
        this.testNode("1.0e6");
    }

    @Test
    public void testNum_4() {
        this.parseBadNode("1 ");
    }

    @Test
    public void testNum_5() {
        this.parseBadNode("1 1");
    }

    @Test
    public void testURI_1() {
        this.testNode("<http://example/base>");
    }

    @Test
    public void testURI_2() {
        this.parseBadNode("http://example/baseNoDelimiters");
    }

    @Test
    public void testURI_3() {
        this.parseBadNode("<http://example/ space>");
    }

    @Test
    public void testVar_01() {
        this.testVar("?x");
    }

    @Test
    public void testVar_02() {
        this.testVar("?");
    }

    @Test
    public void testVar_03() {
        this.testVar("?0");
    }

    @Test
    public void testVar_04() {
        this.testVar("??x");
    }

    @Test
    public void testVar_05() {
        this.testVar("??");
    }

    @Test
    public void testVar_06() {
        this.testVar("??0");
    }

    @Test
    public void testVar_07() {
        this.testVar("?.0");
    }

    @Test
    public void testVar_08() {
        this.testVar("?.");
    }

    @Test
    public void testVar_09() {
        Node v = NodeFactory.parseNode((String)"?");
        TestSSE_Basic.assertTrue((boolean)(v instanceof Var));
        String vn = ((Var)v).getVarName();
        TestSSE_Basic.assertFalse((boolean)vn.equals(""));
    }

    @Test
    public void testVar_10() {
        Node v = NodeFactory.parseNode((String)"??");
        TestSSE_Basic.assertTrue((boolean)(v instanceof Var));
        String vn = ((Var)v).getVarName();
        TestSSE_Basic.assertFalse((boolean)vn.equals("?"));
    }

    @Test
    public void testVar_11() {
        Node v = NodeFactory.parseNode((String)"?.");
        TestSSE_Basic.assertTrue((boolean)(v instanceof Var));
        String vn = ((Var)v).getVarName();
        TestSSE_Basic.assertFalse((boolean)vn.equals("."));
    }

    @Test
    public void testWS_1() {
        this.parseBadNode("?x ");
    }

    @Test
    public void testWS_2() {
        this.parseBadNode(" ?x");
    }

    @Test
    public void testNode_1() {
        this.testNode("3", int3);
    }

    @Test
    public void testNode_2() {
        this.testNode("<http://example/node1>", Node.createURI((String)"http://example/node1"));
    }

    @Test
    public void testTypedLit_1() {
        this.testNode("\"123\"^^<http://example/type>", typeLit1);
    }

    @Test
    public void testTypedLit_2() {
        this.testNode("'123'^^<http://example/type>", typeLit1);
    }

    @Test
    public void testTypedLit_3() {
        this.testNode("'3'^^<" + XSDDatatype.XSDinteger.getURI() + ">", int3);
    }

    @Test
    public void testSymbol_1() {
        this.testSymbol("word");
    }

    @Test
    public void testSymbol_2() {
        this.testSymbol("+");
    }

    @Test
    public void testNil_1() {
        this.testItem("nil", Item.nil);
    }

    @Test
    public void testNil_2() {
        this.testNotItem("null", Item.nil);
    }

    @Test
    public void testNil_3() {
        this.testNotItem("()", Item.nil);
    }

    @Test
    public void testNil_4() {
        Item x = Item.createList();
        x.getList().add(Item.nil);
        this.testItem("(nil)", x);
    }

    @Test
    public void testList_1() {
        Item item = this.parse("()");
        TestSSE_Basic.assertTrue((boolean)item.isList());
        TestSSE_Basic.assertEquals((int)item.getList().size(), (int)0);
    }

    @Test
    public void testList_2() {
        this.testList("(1)", int1i);
    }

    @Test
    public void testList_3() {
        this.testList("(1 2)", int1i, int2i);
    }

    @Test
    public void testList_4() {
        this.testList("(1 a)", int1i, Item.createSymbol((String)"a"));
    }

    @Test
    public void testList_5() {
        Item list = Item.createList();
        list.getList().add(int1i);
        this.testList("((1) a)", list, Item.createSymbol((String)"a"));
    }

    @Test
    public void testList_6() {
        this.testList("(+ 1)", Item.createSymbol((String)"+"), int1i);
    }

    @Test
    public void testList_7() {
        this.testList("[+ 1]", Item.createSymbol((String)"+"), int1i);
    }

    @Test
    public void testNum_01() {
        Item item = SSE.parse((String)"1");
        TestSSE_Basic.assertEquals((int)1, (int)item.getInt());
    }

    @Test
    public void testNum_02() {
        Item item = SSE.parse((String)"3");
        TestSSE_Basic.assertEquals((double)3.0, (double)item.getDouble(), (double)0.0);
    }

    @Test
    public void testNum_03() {
        Item item = SSE.parse((String)"2.5");
        TestSSE_Basic.assertEquals((double)2.5, (double)item.getDouble(), (double)0.0);
    }

    @Test
    public void testNum_04() {
        Item item = SSE.parse((String)"abc");
        try {
            item.getInt();
            TestSSE_Basic.fail((String)"Succeeded where exception expected");
        }
        catch (ItemException itemException) {
            // empty catch block
        }
    }

    @Test
    public void testNum_05() {
        Item item = SSE.parse((String)"<x>");
        try {
            item.getInt();
            TestSSE_Basic.fail((String)"Succeeded where exception expected");
        }
        catch (ItemException itemException) {
            // empty catch block
        }
    }

    @Test
    public void testMisc_01() {
        this.testEquals("()");
    }

    @Test
    public void testMisc_02() {
        this.testEquals("(a)");
    }

    @Test
    public void testMisc_10() {
        this.testNotEquals("(a)", "a");
    }

    @Test
    public void testMisc_11() {
        this.testNotEquals("(a)", "()");
    }

    @Test
    public void testMisc_12() {
        this.testNotEquals("(a)", "(<a>)");
    }

    @Test
    public void testTaggedList_1() {
        Item x = Item.createTagged((String)"TAG");
        TestSSE_Basic.assertTrue((boolean)x.isTagged());
        TestSSE_Basic.assertTrue((boolean)x.isTagged("TAG"));
    }

    @Test
    public void testTaggedList_2() {
        Item x = Item.createTagged((String)"TAG");
        Item.addPair((ItemList)x.getList(), (String)"KEY", (String)"VALUE");
        Item y = Item.find((ItemList)x.getList(), (String)"KEY");
        TestSSE_Basic.assertNotNull((Object)y);
        Item z = Item.find((ItemList)x.getList(), (String)"KEYKEY");
        TestSSE_Basic.assertNull((Object)z);
    }

    private void testEquals(String x) {
        Item item1 = this.parse(x);
        Item item2 = this.parse(x);
        TestSSE_Basic.assertTrue((boolean)item1.equals((Object)item2));
        TestSSE_Basic.assertTrue((boolean)item2.equals((Object)item1));
    }

    private void testNotEquals(String x1, String x2) {
        Item item1 = this.parse(x1);
        Item item2 = this.parse(x2);
        TestSSE_Basic.assertFalse((boolean)item1.equals((Object)item2));
        TestSSE_Basic.assertFalse((boolean)item2.equals((Object)item1));
    }

    private Item parse(String str) {
        Item item = SSE.parse((String)str);
        return item;
    }

    private void testSymbol(String str) {
        Item item = this.parse(str);
        TestSSE_Basic.assertTrue((boolean)item.isSymbol());
        TestSSE_Basic.assertEquals((String)item.getSymbol(), (String)str);
    }

    private void testList(String str, Item item1) {
        Item item = this.parse(str);
        TestSSE_Basic.assertTrue((boolean)item.isList());
        Item i = item.getList().get(0);
        TestSSE_Basic.assertEquals((int)1, (int)item.getList().size());
        TestSSE_Basic.assertEquals((Object)item.getList().get(0), (Object)item1);
    }

    private void testList(String str, Item item1, Item item2) {
        Item item = this.parse(str);
        TestSSE_Basic.assertTrue((boolean)item.isList());
        TestSSE_Basic.assertEquals((int)2, (int)item.getList().size());
        TestSSE_Basic.assertEquals((Object)item.getList().get(0), (Object)item1);
        TestSSE_Basic.assertEquals((Object)item.getList().get(1), (Object)item2);
    }

    private void testList(String str, Item item1, Item item2, Item item3) {
        Item item = this.parse(str);
        TestSSE_Basic.assertTrue((boolean)item.isList());
        TestSSE_Basic.assertEquals((int)3, (int)item.getList().size());
        TestSSE_Basic.assertEquals((Object)item.getList().get(0), (Object)item1);
        TestSSE_Basic.assertEquals((Object)item.getList().get(1), (Object)item2);
        TestSSE_Basic.assertEquals((Object)item.getList().get(2), (Object)item3);
    }

    private void testItem(String str, Item result) {
        Item item = this.parse(str);
        TestSSE_Basic.assertEquals((Object)result, (Object)item);
    }

    private void testNotItem(String str, Item result) {
        Item item = this.parse(str);
        TestSSE_Basic.assertFalse((boolean)result.equals((Object)item));
    }

    private void testNode(String str) {
        Node node = NodeFactory.parseNode((String)str);
    }

    private void testVar(String str) {
        Node node = NodeFactory.parseNode((String)str);
        TestSSE_Basic.assertTrue((boolean)(node instanceof Var));
    }

    private void testNode(String str, Node result) {
        Node node = NodeFactory.parseNode((String)str);
        TestSSE_Basic.assertEquals((Object)result, (Object)node);
    }

    private void parseBad(String str) {
        try {
            Item item = SSE.parse((String)str);
            TestSSE_Basic.fail((String)"Did not get a parse failure");
        }
        catch (SSEParseException ex) {
        }
        catch (ARQException aRQException) {
            // empty catch block
        }
    }

    private void parseBadNode(String str) {
        try {
            Node node = NodeFactory.parseNode((String)str);
            TestSSE_Basic.fail((String)"Did not get a parse failure");
        }
        catch (SSEParseException ex) {
        }
        catch (ARQException aRQException) {
            // empty catch block
        }
    }
}

