/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathEval;
import com.hp.hpl.jena.sparql.path.PathParser;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderPath;
import com.hp.hpl.jena.sparql.sse.writers.WriterPath;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;

public class TestPath {
    static Graph graph1 = GraphFactory.createDefaultGraph();
    static Graph graph2 = GraphFactory.createDefaultGraph();
    static Node n1 = Node.createURI((String)"n1");
    static Node n2 = Node.createURI((String)"n2");
    static Node n3 = Node.createURI((String)"n3");
    static Node n4 = Node.createURI((String)"n4");
    static Node p = Node.createURI((String)"http://example/p");
    static Node q = Node.createURI((String)"http://example/q");
    static PrefixMapping pmap = new PrefixMappingImpl();

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestPath.class);
    }

    @Test
    public void parsePath_01() {
        this.parse(":p");
    }

    @Test
    public void parsePath_02() {
        this.parse("(:p)");
    }

    @Test
    public void parsePath_03() {
        this.parse("^:p");
    }

    @Test
    public void parsePath_04() {
        this.parse(":p*");
    }

    @Test
    public void parsePath_05() {
        this.parse(":p+");
    }

    @Test
    public void parsePath_06() {
        this.parse(":p?");
    }

    @Test
    public void parsePath_10() {
        this.parse(":p/:q");
    }

    @Test
    public void parsePath_11() {
        this.parse(":p|:q");
    }

    @Test
    public void parsePath_12() {
        this.parse(":p{1}");
    }

    @Test
    public void parsePath_13() {
        this.parse(":p{1,}");
    }

    @Test
    public void parsePath_14() {
        this.parse(":p{,1}");
    }

    @Test
    public void parsePath_15() {
        this.parse(":p{1,2}");
    }

    @Test
    public void parsePath_20() {
        this.parse(":p^:q");
    }

    @Test
    public void parsePath_21() {
        this.parse("^:p^:q");
    }

    @Test
    public void parsePath_22() {
        this.parse("^:p/:q");
    }

    @Test
    public void parsePath_23() {
        this.parse("^(:p/:q)");
    }

    @Test
    public void parsePath_24() {
        this.parse("^(:p^:q)");
    }

    @Test
    public void parsePath_25() {
        this.parse(":p^(:q/:r)");
    }

    @Test
    public void parsePath_30() {
        this.parse("!(:q|:r)");
    }

    @Test
    public void parsePath_31() {
        this.parse(":p/!:q/:r");
    }

    @Test
    public void parsePath_32() {
        this.parse("!:q/:r");
    }

    @Test
    public void parsePathErr_01() {
        this.parse("", false);
    }

    @Test
    public void parsePathErr_02() {
        this.parse("()", false);
    }

    @Test
    public void parsePathErr_03() {
        this.parse(":p :q", false);
    }

    @Test
    public void parseEquals_1() {
        TestPath.parse("(:p)", ":p");
    }

    @Test
    public void parseEquals_2() {
        TestPath.parse(":p/:q/:r", "(:p/:q)/:r");
    }

    @Test
    public void parseEquals_3() {
        TestPath.parse("^:p^:q^:r", "(^:p^:q)^:r");
    }

    @Test
    public void parseEquals_4() {
        TestPath.parse(":p/(:q/:r)", ":p/(:q/:r)");
    }

    @Test
    public void parseEquals_5() {
        TestPath.parse("(:p/:q)|:r", ":p/:q|:r");
    }

    @Test
    public void parseEquals_6() {
        TestPath.parse(":p|(:q/:r)", ":p|:q/:r");
    }

    @Test
    public void parseEquals_7() {
        TestPath.parse("^:p/:q", "(^:p)/:q");
    }

    @Test
    public void parseEquals_8() {
        TestPath.parse("!:q/:r", "(!:q)/:r");
    }

    @Test
    public void parseEquals_9() {
        TestPath.parse("!:q/:r", "(!:q)/:r");
    }

    private void parse(String string) {
        this.parse(string, true);
    }

    private void parse(String string, boolean expectLegal) {
        Prologue prologue = new Prologue(pmap);
        Path p = null;
        try {
            p = PathParser.parse((String)string, (Prologue)prologue);
            if (!expectLegal) {
                Assert.fail((String)("Expected error; " + string));
            }
        }
        catch (QueryParseException ex) {
            if (expectLegal) {
                Assert.fail((String)("Expected success: " + string + ": " + ex.getMessage()));
            }
            return;
        }
        String x = p.toString(prologue);
        Path p2 = PathParser.parse((String)x, (Prologue)prologue);
        Assert.assertEquals((Object)p, (Object)p2);
        String sse = WriterPath.asString((Path)p, (Prologue)prologue);
        Item item = SSE.parseItem((String)sse, (PrefixMapping)pmap);
        p2 = BuilderPath.buildPath((Item)item);
        Assert.assertEquals((Object)p, (Object)p2);
    }

    private static void parse(String path1, String path2) {
        Prologue prologue = new Prologue(pmap);
        Path p1 = PathParser.parse((String)path1, (Prologue)prologue);
        Path p2 = PathParser.parse((String)path2, (Prologue)prologue);
        Assert.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void path_01() {
        TestPath.test(graph1, n1, ":p", n2);
    }

    @Test
    public void path_02() {
        TestPath.test(graph1, n1, ":p{0}", n1);
    }

    @Test
    public void path_03() {
        TestPath.test(graph1, n1, ":p{1}", n2);
    }

    @Test
    public void path_04() {
        TestPath.test(graph1, n1, ":p{2}", n3);
    }

    @Test
    public void path_05() {
        TestPath.test(graph1, n1, ":p{0,1}", n1, n2);
    }

    @Test
    public void path_06() {
        TestPath.test(graph1, n1, ":p{0,2}", n1, n2, n3);
    }

    @Test
    public void path_07() {
        TestPath.test(graph1, n1, ":p{1,2}", n2, n3);
    }

    @Test
    public void path_08() {
        TestPath.test(graph1, n1, ":p{9,9}", new Node[0]);
    }

    @Test
    public void path_09() {
        TestPath.test(graph1, n1, ":p{0,9}", n1, n2, n3, n4);
    }

    @Test
    public void path_10() {
        TestPath.test(graph1, n1, ":p*", n1, n2, n3, n4);
    }

    @Test
    public void path_11() {
        TestPath.test(graph1, n1, ":p+", n2, n3, n4);
    }

    @Test
    public void path_12() {
        TestPath.test(graph1, n1, ":p?", n1, n2);
    }

    @Test
    public void path_13() {
        TestPath.test(graph1, n1, ":p/:p", n3);
    }

    @Test
    public void path_14() {
        TestPath.test(graph1, n2, "^:p", n1);
    }

    @Test
    public void path_15() {
        TestPath.test(graph1, n2, "^:p^:p", new Node[0]);
    }

    @Test
    public void path_16() {
        TestPath.test(graph1, n4, "^:p^:p", n2);
    }

    @Test
    public void path_17() {
        TestPath.test(graph1, n4, "^(:p/:p)", n2);
    }

    @Test
    public void path_18() {
        TestPath.test(graph1, n2, "^:p/:p", n2);
    }

    @Test
    public void path_20() {
        TestPath.test(graph2, n1, ":p", n2, n3);
    }

    @Test
    public void path_21() {
        TestPath.test(graph2, n1, ":p/:q", n4);
    }

    @Test
    public void path_22() {
        TestPath.test(graph2, n2, "^:p|:q", n1, n4);
    }

    @Test
    public void path_23() {
        TestPath.test(graph2, n2, "^(:p|^:q)*", n1, n2, n4);
    }

    @Test
    public void path_24() {
        TestPath.testReverse(graph1, n2, ":p", n1);
    }

    @Test
    public void path_25() {
        TestPath.testReverse(graph1, n3, ":p/:p", n1);
    }

    private static void test(Graph graph, Node start, String string, Node ... expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, true);
    }

    private static void testReverse(Graph graph, Node start, String string, Node ... expectedNodes) {
        TestPath.test(graph, start, string, expectedNodes, false);
    }

    private static void test(Graph graph, Node start, String string, Node[] expectedNodes, boolean directionForward) {
        Path p = PathParser.parse((String)string, (PrefixMapping)pmap);
        Iterator resultsIter = directionForward ? PathEval.eval((Graph)graph, (Node)start, (Path)p) : PathEval.evalInverse((Graph)graph, (Node)start, (Path)p);
        HashSet results = new HashSet();
        while (resultsIter.hasNext()) {
            results.add(resultsIter.next());
        }
        HashSet<Node> expected = new HashSet<Node>(Arrays.asList(expectedNodes));
        Assert.assertEquals(expected, results);
    }

    static {
        pmap.setNsPrefixes(PrefixMapping.Standard);
        pmap.setNsPrefix("", "http://example/");
        graph1.add(new Triple(n1, p, n2));
        graph1.add(new Triple(n2, p, n3));
        graph1.add(new Triple(n3, p, n4));
        graph2.add(new Triple(n1, p, n2));
        graph2.add(new Triple(n1, p, n3));
        graph2.add(new Triple(n2, q, n4));
        graph2.add(new Triple(n3, q, n4));
    }
}

