/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.modify.TestUpdateBase;
import com.hp.hpl.jena.sparql.modify.request.QuadAcc;
import com.hp.hpl.jena.sparql.modify.request.QuadDataAcc;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataDelete;
import com.hp.hpl.jena.sparql.modify.request.UpdateDataInsert;
import com.hp.hpl.jena.sparql.modify.request.UpdateDeleteWhere;
import com.hp.hpl.jena.sparql.modify.request.UpdateModify;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;
import org.junit.Test;

public abstract class TestUpdateGraph
extends TestUpdateBase {
    protected static Node s = NodeFactory.parseNode((String)"<http://example/r>");
    protected static Node p = NodeFactory.parseNode((String)"<http://example/p>");
    protected static Node q = NodeFactory.parseNode((String)"<http://example/q>");
    protected static Node v = NodeFactory.parseNode((String)"<http://example/v>");
    protected static Node o1 = NodeFactory.parseNode((String)"2007");
    protected static Triple triple1 = new Triple(s, p, o1);
    protected static Node o2 = NodeFactory.parseNode((String)"1066");
    protected static Triple triple2 = new Triple(s, p, o2);
    protected static Graph graph1 = TestUpdateGraph.data1();
    protected static Node graphIRI = NodeFactory.parseNode((String)"<http://example/graph>");

    @Test
    public void testInsertData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple2);
        UpdateDataInsert insert = new UpdateDataInsert(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)insert, (GraphStore)gStore);
        uProc.execute();
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple2);
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (GraphStore)gStore);
        uProc.execute();
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDeleteData2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        acc.addTriple(triple1);
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        UpdateProcessor uProc = UpdateExecutionFactory.create((Update)delete, (GraphStore)gStore);
        uProc.execute();
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert1() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateModify insert = new UpdateModify();
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testInsert2() {
        GraphStore gStore = this.getEmptyGraphStore();
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addTriple(triple1);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple1));
    }

    @Test
    public void testInsert3() {
        GraphStore gStore = this.getEmptyGraphStore();
        gStore.addGraph(graphIRI, Factory.createDefaultGraph());
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testInsert4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        UpdateModify insert = new UpdateModify();
        insert.getInsertAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> 1066)"));
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> 2007 }");
        insert.setElement(element);
        UpdateAction.execute((Update)insert, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), triple2));
    }

    @Test
    public void testDelete1() {
        GraphStore gStore = this.getEmptyGraphStore();
        QuadAcc acc = new QuadAcc();
        UpdateDeleteWhere delete = new UpdateDeleteWhere(acc);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete2() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadAcc acc = new QuadAcc();
        UpdateDeleteWhere delete = new UpdateDeleteWhere(acc);
        acc.addTriple(SSE.parseTriple((String)"(?s ?p ?o)"));
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((String)"Not empty", (boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete3() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        QuadDataAcc acc = new QuadDataAcc();
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        acc.addTriple(triple1);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.namedGraphData(gStore, graphIRI, TestUpdateGraph.data1());
        QuadDataAcc acc = new QuadDataAcc();
        UpdateDataDelete delete = new UpdateDataDelete(acc);
        acc.setGraph(graphIRI);
        acc.addTriple(triple1);
        UpdateAction.execute((Update)delete, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testDelete5() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, TestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, TestUpdateGraph.data1());
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> 2007 )"));
        UpdateAction.execute((Update)modify, (GraphStore)gStore);
        TestUpdateGraph.assertTrue((String)"Not empty", (boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testModify1() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, TestUpdateGraph.data2());
        this.namedGraphData(gStore, graphIRI, Factory.createDefaultGraph());
        UpdateModify modify = new UpdateModify();
        Element element = QueryFactory.createElement((String)"{ ?s <http://example/p> ?o }");
        modify.setElement(element);
        modify.getInsertAcc().addQuad(new Quad(graphIRI, triple1));
        modify.getDeleteAcc().addTriple(SSE.parseTriple((String)"(?s <http://example/p> ?o)"));
        modify.getDeleteAcc().addQuad(SSE.parseQuad((String)"(<http://example/graph> ?s <http://example/p> ?o)"));
        UpdateAction.execute((Update)modify, (GraphStore)gStore);
        TestUpdateGraph.assertFalse((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(graphIRI)));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), triple1));
    }

    @Test
    public void testUpdateScript1() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-1.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript2() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-2.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(Node.createURI((String)"http://example/g1")), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript3() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "update-3.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getGraph(Node.createURI((String)"http://example/g1"))));
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphEmpty(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript4() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-1.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript5() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-2.ru");
        Graph g = GraphFactory.createPlainGraph();
        Node b = Node.createAnon();
        g.add(new Triple(s, p, b));
        g.add(new Triple(b, q, v));
        TestUpdateGraph.assertTrue((boolean)g.isIsomorphicWith(gStore.getDefaultGraph()));
    }

    @Test
    public void testUpdateScript6() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-3.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
    }

    @Test
    public void testUpdateScript7() {
        GraphStore gStore = this.getEmptyGraphStore();
        TestUpdateGraph.script(gStore, "data-4.ru");
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getDefaultGraph(), new Triple(s, p, NodeFactory.parseNode((String)"123"))));
        Graph g = gStore.getGraph(graphIRI);
        TestUpdateGraph.assertTrue((boolean)TestUpdateGraph.graphContains(gStore.getGraph(graphIRI), new Triple(s, p, o2)));
    }

    @Test
    public void testUpdateInitialBinding4() {
        GraphStore gStore = this.getEmptyGraphStore();
        this.defaultGraphData(gStore, graph1);
        String update = "DELETE WHERE { ?x <http://example/p> 2007 } ; INSERT { ?x <http://example/p> 1999 } WHERE {}";
        UpdateRequest req = UpdateFactory.create((String)update);
        Binding b = BindingFactory.binding((Var)Var.alloc((String)"x"), (Node)s);
        UpdateAction.execute((UpdateRequest)req, (GraphStore)gStore, (Binding)b);
        TestUpdateGraph.assertEquals((int)1, (int)gStore.getDefaultGraph().size());
        TestUpdateGraph.assertTrue((boolean)gStore.getDefaultGraph().contains(s, p, NodeFactory.parseNode((String)"1999")));
    }

    private static Graph data1() {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple1);
        return graph;
    }

    private static Graph data2() {
        Graph graph = Factory.createDefaultGraph();
        graph.add(triple2);
        return graph;
    }
}

