/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.larq;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexBuilderSubject;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.junit.QueryTest;
import com.hp.hpl.jena.sparql.resultset.ResultSetRewindable;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.DC;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;
import org.junit.Test;

public class TestLARQ_Script
extends TestCase {
    static final String root = "testing/LARQ/";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestLARQ_Script.class);
    }

    public TestLARQ_Script(String name) {
        super(name);
    }

    static void runTestScript(String queryFile, String dataFile, String resultsFile, IndexBuilderModel builder) {
        Query query = QueryFactory.read((String)(root + queryFile));
        IndexBuilderString larqBuilder = new IndexBuilderString();
        Model model = ModelFactory.createDefaultModel();
        model.register((ModelChangedListener)builder);
        FileManager.get().readModel(model, root + dataFile);
        model.unregister((ModelChangedListener)builder);
        IndexLARQ index = builder.getIndex();
        LARQ.setDefaultIndex((IndexLARQ)index);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
        com.hp.hpl.jena.query.ResultSetRewindable rsExpected = ResultSetFactory.makeRewindable((ResultSet)ResultSetFactory.load((String)(root + resultsFile)));
        com.hp.hpl.jena.query.ResultSetRewindable rsActual = ResultSetFactory.makeRewindable((ResultSet)qe.execSelect());
        boolean b = QueryTest.resultSetEquivalent(query, (ResultSetRewindable)rsActual, (ResultSetRewindable)rsExpected);
        if (!b) {
            rsActual.reset();
            rsExpected.reset();
            System.out.println("==== Different (LARQ)");
            System.out.println("== Actual");
            ResultSetFormatter.out((ResultSet)rsActual);
            System.out.println("== Expected");
            ResultSetFormatter.out((ResultSet)rsExpected);
        }
        TestLARQ_Script.assertTrue((boolean)b);
        qe.close();
        LARQ.removeDefaultIndex();
    }

    @Test
    public void test_larq_1() {
        TestLARQ_Script.runTestScript("larq-q-1.rq", "data-1.ttl", "results-1.srj", (IndexBuilderModel)new IndexBuilderString());
    }

    @Test
    public void test_larq_2() {
        TestLARQ_Script.runTestScript("larq-q-2.rq", "data-1.ttl", "results-2.srj", (IndexBuilderModel)new IndexBuilderString(DC.title));
    }

    @Test
    public void test_larq_3() {
        TestLARQ_Script.runTestScript("larq-q-3.rq", "data-1.ttl", "results-3.srj", (IndexBuilderModel)new IndexBuilderSubject(DC.title));
    }

    @Test
    public void test_larq_4() {
        TestLARQ_Script.runTestScript("larq-q-4.rq", "data-1.ttl", "results-4.srj", (IndexBuilderModel)new IndexBuilderString());
    }

    @Test
    public void test_larq_5() {
        TestLARQ_Script.runTestScript("larq-q-5.rq", "data-1.ttl", "results-5.srj", (IndexBuilderModel)new IndexBuilderString());
    }

    @Test
    public void test_larq_6() {
        TestLARQ_Script.runTestScript("larq-q-6.rq", "data-1.ttl", "results-6.srj", (IndexBuilderModel)new IndexBuilderString());
    }

    @Test
    public void test_larq_7() {
        TestLARQ_Script.runTestScript("larq-q-7.rq", "data-1.ttl", "results-7.srj", (IndexBuilderModel)new IndexBuilderString());
    }
}

