/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.larq;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.IndexBuilderNode;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexBuilderSubject;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.junit.TestLARQUtils;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;
import org.junit.Test;

public class TestLARQ_Code
extends TestCase {
    static final String datafile = "testing/LARQ/data-1.ttl";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestLARQ_Code.class);
    }

    @Test
    public void test_ext_1() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        b.index((RDFNode)r, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ_Code.assertEquals((int)1, (int)TestLARQUtils.count(nIter));
        nIter = index.searchModelByIndex("foo");
        Resource r2 = (Resource)nIter.nextNode();
        TestLARQ_Code.assertEquals((Object)r, (Object)r2);
    }

    @Test
    public void test_ext_2() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Literal lit = model.createLiteral("example");
        b.index((RDFNode)lit, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ_Code.assertEquals((int)1, (int)TestLARQUtils.count(nIter));
        nIter = index.searchModelByIndex("foo");
        Literal lit2 = (Literal)nIter.nextNode();
        TestLARQ_Code.assertEquals((Object)lit, (Object)lit2);
    }

    @Test
    public void test_ext_3() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource bnode = model.createResource();
        b.index((RDFNode)bnode, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ_Code.assertEquals((int)1, (int)TestLARQUtils.count(nIter));
        nIter = index.searchModelByIndex("foo");
        Resource bnode2 = (Resource)nIter.nextNode();
        TestLARQ_Code.assertEquals((Object)bnode, (Object)bnode2);
        TestLARQ_Code.assertTrue((boolean)bnode2.isAnon());
    }

    @Test
    public void test_ext_4() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        b.index((RDFNode)r, "foo");
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("bah");
        TestLARQ_Code.assertFalse((boolean)nIter.hasNext());
    }

    @Test
    public void test_ext_5() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r = model.createResource("http://example/r");
        StringReader sr = new StringReader("foo");
        b.index((RDFNode)r, (Reader)sr);
        b.closeWriter();
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("foo");
        TestLARQ_Code.assertEquals((int)1, (int)TestLARQUtils.count(nIter));
        nIter = index.searchModelByIndex("foo");
        Resource r2 = (Resource)nIter.nextNode();
        TestLARQ_Code.assertEquals((Object)r, (Object)r2);
    }

    public void not_test_ext_6() {
        IndexBuilderNode b = new IndexBuilderNode();
        Model model = ModelFactory.createDefaultModel();
        Resource r1 = model.createResource("http://example/r1");
        Resource r2 = model.createResource("http://example/r2");
        StringReader sr = new StringReader("R1");
        b.index((RDFNode)r1, (Reader)sr);
        IndexLARQ index = b.getIndex();
        NodeIterator nIter = index.searchModelByIndex("R1");
        TestLARQ_Code.assertEquals((int)1, (int)TestLARQUtils.count(nIter));
        nIter = index.searchModelByIndex("R2");
        TestLARQ_Code.assertEquals((int)0, (int)TestLARQUtils.count(nIter));
        b.index((RDFNode)r2, (Reader)new StringReader("R2"));
        nIter = index.searchModelByIndex("R2");
        TestLARQ_Code.assertEquals((int)0, (int)TestLARQUtils.count(nIter));
        index = b.getIndex();
        nIter = index.searchModelByIndex("R2");
        TestLARQ_Code.assertEquals((int)1, (int)TestLARQUtils.count(nIter));
    }

    @Test
    public void test_index_literal_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ_Code.assertEquals((int)3, (int)TestLARQUtils.count(nIter));
        index.close();
    }

    @Test
    public void test_index_literal_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ_Code.assertEquals((int)2, (int)TestLARQUtils.count(nIter));
    }

    @Test
    public void test_index_literal_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ_Code.assertTrue((boolean)(n instanceof Literal));
            TestLARQ_Code.assertTrue((boolean)model.contains(null, null, n));
            boolean b = model.contains(null, DC.title, n) || model.contains(null, RDFS.label, n);
            TestLARQ_Code.assertTrue((String)"DC.title or RDFS.label", (boolean)b);
        }
    }

    @Test
    public void test_index_literal_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ_Code.assertTrue((boolean)(n instanceof Literal));
            TestLARQ_Code.assertTrue((boolean)model.contains(null, DC.title, n));
            TestLARQ_Code.assertFalse((boolean)model.contains(null, RDFS.label, n));
        }
    }

    @Test
    public void test_index_subject_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ_Code.assertEquals((int)3, (int)TestLARQUtils.count(nIter));
    }

    @Test
    public void test_index_subject_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        TestLARQ_Code.assertEquals((int)2, (int)TestLARQUtils.count(nIter));
    }

    @Test
    public void test_index_subject_3() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject());
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ_Code.assertTrue((boolean)(n instanceof Resource));
            TestLARQ_Code.assertTrue((boolean)model.contains((Resource)n, null, (RDFNode)null));
            boolean b = model.contains((Resource)n, DC.title, (RDFNode)null) || model.contains((Resource)n, RDFS.label, (RDFNode)null);
            TestLARQ_Code.assertTrue((String)"subject with DC.title or RDFS.label", (boolean)b);
        }
    }

    @Test
    public void test_index_subject_4() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        NodeIterator nIter = index.searchModelByIndex(model, "+document");
        while (nIter.hasNext()) {
            RDFNode n = nIter.nextNode();
            TestLARQ_Code.assertTrue((boolean)(n instanceof Resource));
            TestLARQ_Code.assertTrue((boolean)model.contains((Resource)n, null, (RDFNode)null));
            TestLARQ_Code.assertTrue((boolean)model.contains((Resource)n, DC.title, (RDFNode)null));
        }
    }

    @Test
    public void test_negative_1() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ_Code.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    @Test
    public void test_negative_2() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderString(DC.title));
        TestLARQ_Code.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    @Test
    public void test_negative_3() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderSubject());
        TestLARQ_Code.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    @Test
    public void test_negative_4() {
        IndexLARQ index = TestLARQUtils.createIndex(datafile, (IndexBuilderModel)new IndexBuilderSubject(DC.title));
        TestLARQ_Code.assertFalse((boolean)index.hasMatch("+iceberg"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_textMatches_index_registration_1() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ_Code.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        try {
            LARQ.setDefaultIndex((IndexLARQ)index);
            TestLARQ_Code.assertTrue((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
            QueryExecution qExec = TestLARQUtils.query(model, "{ ?lit pf:textMatch '+document' }");
            ResultSet rs = qExec.execSelect();
            TestLARQ_Code.assertEquals((int)3, (int)TestLARQUtils.count(rs));
            qExec.close();
            index.close();
            LARQ.removeDefaultIndex();
            TestLARQ_Code.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        }
        finally {
            LARQ.removeDefaultIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_textMatches_index_registration_2() {
        Model model = ModelFactory.createDefaultModel();
        IndexLARQ index = TestLARQUtils.createIndex(model, datafile, (IndexBuilderModel)new IndexBuilderString());
        TestLARQ_Code.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        QueryExecution qExec = TestLARQUtils.query(model, "{ ?lit pf:textMatch '+document' }");
        try {
            LARQ.setDefaultIndex((Context)qExec.getContext(), (IndexLARQ)index);
            TestLARQ_Code.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
            TestLARQ_Code.assertTrue((boolean)qExec.getContext().isDefined(LARQ.indexKey));
            ResultSet rs = qExec.execSelect();
            TestLARQ_Code.assertEquals((int)3, (int)TestLARQUtils.count(rs));
            qExec.close();
            index.close();
            LARQ.removeDefaultIndex((Context)qExec.getContext());
            TestLARQ_Code.assertFalse((boolean)qExec.getContext().isDefined(LARQ.indexKey));
            TestLARQ_Code.assertFalse((boolean)ARQ.getContext().isDefined(LARQ.indexKey));
        }
        finally {
            LARQ.removeDefaultIndex();
        }
    }
}

