/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.lang.SyntaxVarScope;
import org.junit.Test;
import org.openjena.atlas.junit.BaseTest;

public class TestVarScope
extends BaseTest {
    private static void scope(String queryStr) {
        Query query = QueryFactory.create((String)queryStr);
        SyntaxVarScope.check((Query)query);
    }

    @Test
    public void scope_01() {
        TestVarScope.scope("SELECT ?x { ?s ?p ?o }");
    }

    @Test
    public void scope_02() {
        TestVarScope.scope("SELECT ?s { ?s ?p ?o }");
    }

    @Test
    public void scope_03() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { ?s ?p ?o }");
    }

    @Test(expected=QueryException.class)
    public void scope_04() {
        TestVarScope.scope("SELECT (?o+1 AS ?o) { ?s ?p ?o }");
    }

    @Test(expected=QueryException.class)
    public void scope_05() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) (?o+1 AS ?x) { ?s ?p ?o }");
    }

    @Test
    public void scope_06() {
        TestVarScope.scope("SELECT (?z+1 AS ?x) { ?s ?p ?o } GROUP BY (?o+5 AS ?z)");
    }

    @Test(expected=QueryException.class)
    public void scope_07() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { ?s ?p ?o } GROUP BY (?o+5 AS ?x)");
    }

    @Test
    public void scope_08() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { ?s ?p ?o MINUS { ?s ?p ?x} } ");
    }

    @Test(expected=QueryException.class)
    public void scope_09() {
        TestVarScope.scope("SELECT (?o+1 AS ?x) { { SELECT (123 AS ?x) {?s ?p ?o } } } ");
    }

    @Test
    public void scope_10() {
        TestVarScope.scope("SELECT (?o+1 AS ?o) { { SELECT (123 AS ?x) {?s ?p ?o } } } ");
    }

    @Test
    public void scope_11() {
        TestVarScope.scope("SELECT (?o+1 AS ?o) { { SELECT (123 AS ?x) {?s ?p ?o FILTER(?x > 57)} } } ");
    }

    @Test
    public void scope_20() {
        TestVarScope.scope("SELECT ?x { ?x ?p ?o } GROUP BY ?x");
    }

    @Test(expected=QueryException.class)
    public void scope_21() {
        TestVarScope.scope("SELECT ?o { ?x ?p ?o } GROUP BY ?x");
    }

    @Test
    public void scope_22() {
        TestVarScope.scope("SELECT * { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} BIND(?o2+5 AS ?z) }");
    }

    @Test(expected=QueryException.class)
    public void scope_24() {
        TestVarScope.scope("SELECT * { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} BIND(?o+5 AS ?o2) }");
    }

    @Test(expected=QueryException.class)
    public void scope_25() {
        TestVarScope.scope("SELECT * { ?s ?p ?o OPTIONAL{?s ?p2 ?o2} BIND(5 AS ?o) }");
    }
}

