/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DataFormat;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.QueryTest;
import com.hp.hpl.jena.sparql.junit.QueryTestException;
import com.hp.hpl.jena.sparql.junit.SurpressedTest;
import com.hp.hpl.jena.sparql.junit.SyntaxTest;
import com.hp.hpl.jena.sparql.junit.SyntaxUpdateTest;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.junit.TestQueryUtils;
import com.hp.hpl.jena.sparql.junit.TestSerialization;
import com.hp.hpl.jena.sparql.junit.UpdateTest;
import com.hp.hpl.jena.sparql.vocabulary.TestManifest;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestUpdate_11;
import com.hp.hpl.jena.sparql.vocabulary.TestManifestX;
import com.hp.hpl.jena.sparql.vocabulary.TestManifest_11;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.junit.TestFactoryManifest;
import com.hp.hpl.jena.util.junit.TestUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ScriptTestSuiteFactory
extends TestFactoryManifest {
    private FileManager fileManager = FileManager.get();
    public static EarlReport results = null;

    public static TestSuite make(String filename) {
        ScriptTestSuiteFactory tFact = new ScriptTestSuiteFactory();
        return tFact.process(filename);
    }

    public static TestSuite make(String query, String data, String result) {
        TestItem item = TestItem.create(query, query, data, result);
        QueryTest t = new QueryTest(item.getName(), null, FileManager.get(), item);
        TestSuite ts = new TestSuite();
        ts.setName(TestUtils.safeName((String)query));
        ts.addTest((Test)t);
        return ts;
    }

    public Test makeTest(Resource manifest, Resource entry, String testName, Resource action, Resource result) {
        Resource defaultTestType;
        if (action == null) {
            System.out.println("Null action: " + entry);
            return null;
        }
        Syntax querySyntax = TestQueryUtils.getQuerySyntax(manifest);
        if (!(querySyntax == null || querySyntax.equals((Object)Syntax.syntaxRDQL) || querySyntax.equals((Object)Syntax.syntaxARQ) || querySyntax.equals((Object)Syntax.syntaxSPARQL_10) || querySyntax.equals((Object)Syntax.syntaxSPARQL_11))) {
            throw new QueryTestException("Unknown syntax: " + querySyntax);
        }
        Resource testType = defaultTestType = TestUtils.getResource((Resource)manifest, (Property)TestManifestX.defaultTestType);
        if (entry.hasProperty(RDF.type)) {
            testType = entry.getProperty(RDF.type).getResource();
        }
        TestItem item = null;
        if (testType == null || !testType.equals(TestManifestUpdate_11.UpdateEvaluationTest) && !testType.equals(TestManifest_11.UpdateEvaluationTest)) {
            item = TestItem.create(entry, defaultTestType, querySyntax, DataFormat.langXML);
        }
        QueryTest test = null;
        if (testType != null) {
            if (testType.equals(TestManifest.PositiveSyntaxTest)) {
                return new SyntaxTest(testName, results, item);
            }
            if (testType.equals(TestManifest_11.PositiveSyntaxTest11)) {
                return new SyntaxTest(testName, results, item);
            }
            if (testType.equals(TestManifestX.PositiveSyntaxTestARQ)) {
                return new SyntaxTest(testName, results, item);
            }
            if (testType.equals(TestManifest.NegativeSyntaxTest)) {
                return new SyntaxTest(testName, results, item, false);
            }
            if (testType.equals(TestManifest_11.NegativeSyntaxTest11)) {
                return new SyntaxTest(testName, results, item, false);
            }
            if (testType.equals(TestManifestX.NegativeSyntaxTestARQ)) {
                return new SyntaxTest(testName, results, item, false);
            }
            if (testType.equals(TestManifest_11.PositiveUpdateSyntaxTest11)) {
                return new SyntaxUpdateTest(testName, results, item, true);
            }
            if (testType.equals(TestManifest_11.NegativeUpdateSyntaxTest11)) {
                return new SyntaxUpdateTest(testName, results, item, false);
            }
            if (testType.equals(TestManifestUpdate_11.UpdateEvaluationTest)) {
                return UpdateTest.create(testName, results, entry, action, result);
            }
            if (testType.equals(TestManifest_11.UpdateEvaluationTest)) {
                return UpdateTest.create(testName, results, entry, action, result);
            }
            if (testType.equals(TestManifestX.TestSerialization)) {
                return new TestSerialization(testName, results, item);
            }
            if (testType.equals(TestManifest.QueryEvaluationTest) || testType.equals(TestManifestX.TestQuery)) {
                return new QueryTest(testName, results, this.fileManager, item);
            }
            if (testType.equals(TestManifest.ReducedCardinalityTest)) {
                return new QueryTest(testName, results, this.fileManager, item);
            }
            if (testType.equals(TestManifestX.TestSurpressed)) {
                return new SurpressedTest(testName, results, item);
            }
            System.err.println("Test type '" + testType + "' not recognized");
        }
        test = new QueryTest(testName, results, this.fileManager, item);
        return test;
    }
}

