/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.junit;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.junit.EarlReport;
import com.hp.hpl.jena.sparql.junit.EarlTestCase;
import com.hp.hpl.jena.sparql.junit.QueryTestException;
import com.hp.hpl.jena.sparql.junit.TestItem;
import com.hp.hpl.jena.sparql.resultset.ResultSetCompare;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.sparql.vocabulary.ResultSetGraphVocab;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.junit.TestUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.logging.Log;
import org.openjena.riot.checker.CheckerLiterals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTest
extends EarlTestCase {
    private static int testCounter = 1;
    private int testNumber = testCounter++;
    private TestItem testItem;
    private FileManager queryFileManager;
    private boolean isRDQLtest = false;
    private boolean resetNeeded = false;
    private SPARQLResult results = null;
    private boolean oldWarningFlag;
    String _description = null;

    public QueryTest(String testName, EarlReport earl, FileManager fm, TestItem t) {
        super(TestUtils.safeName((String)testName), t.getURI(), earl);
        this.queryFileManager = fm;
        this.testItem = t;
        this.isRDQLtest = this.testItem.getFileSyntax().equals((Object)Syntax.syntaxRDQL);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isRDQLtest) {
            this.resetNeeded = true;
            ARQ.setTrue((Symbol)ARQ.strictGraph);
        }
        this.oldWarningFlag = CheckerLiterals.WarnOnBadLiterals;
        CheckerLiterals.WarnOnBadLiterals = false;
        this.results = this.testItem.getResults();
    }

    protected void tearDown() throws Exception {
        if (this.resetNeeded) {
            ARQ.setFalse((Symbol)ARQ.strictGraph);
        }
        CheckerLiterals.WarnOnBadLiterals = this.oldWarningFlag;
        super.tearDown();
    }

    private Dataset setUpDataset(Query query, TestItem testItem) {
        try {
            if (QueryTest.doesQueryHaveDataset(query) && QueryTest.doesTestItemHaveDataset(testItem) && testItem.getResultFile() != null) {
                Log.warn((Object)((Object)this), (String)(testItem.getName() + " : query data source and also in test file"));
            }
            if (QueryTest.doesTestItemHaveDataset(testItem)) {
                return QueryTest.createDataset(testItem.getDefaultGraphURIs(), testItem.getNamedGraphURIs());
            }
            if (!QueryTest.doesQueryHaveDataset(query)) {
                QueryTest.fail((String)"No dataset");
            }
            return null;
        }
        catch (JenaException jEx) {
            QueryTest.fail((String)("JenaException creating data source: " + jEx.getMessage()));
            return null;
        }
    }

    private static boolean doesTestItemHaveDataset(TestItem testItem) {
        boolean r = testItem.getDefaultGraphURIs() != null && testItem.getDefaultGraphURIs().size() > 0 || testItem.getNamedGraphURIs() != null && testItem.getNamedGraphURIs().size() > 0;
        return r;
    }

    private static boolean doesQueryHaveDataset(Query query) {
        return query.hasDatasetDescription();
    }

    private static Dataset createDataset(List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return DatasetUtils.createDataset(defaultGraphURIs, namedGraphURIs, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTestForReal() throws Throwable {
        Query query = null;
        try {
            try {
                query = this.queryFromTestItem(this.testItem);
            }
            catch (QueryException qEx) {
                query = null;
                qEx.printStackTrace(System.err);
                QueryTest.fail((String)("Parse failure: " + qEx.getMessage()));
                throw qEx;
            }
            Dataset dataset = this.setUpDataset(query, this.testItem);
            if (dataset == null && !QueryTest.doesQueryHaveDataset(query)) {
                QueryTest.fail((String)"No dataset for query");
            }
            QueryExecution qe = null;
            qe = dataset == null ? QueryExecutionFactory.create((Query)query, (FileManager)this.queryFileManager) : QueryExecutionFactory.create((Query)query, (Dataset)dataset);
            try {
                if (query.isSelectType()) {
                    this.runTestSelect(query, qe);
                } else if (query.isConstructType()) {
                    this.runTestConstruct(query, qe);
                } else if (query.isDescribeType()) {
                    this.runTestDescribe(query, qe);
                } else if (query.isAskType()) {
                    this.runTestAsk(query, qe);
                }
            }
            finally {
                qe.close();
            }
        }
        catch (IOException ioEx) {
            QueryTest.fail((String)("IOException: " + ioEx.getMessage()));
            throw ioEx;
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            QueryTest.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    void runTestSelect(Query query, QueryExecution qe) throws Exception {
        boolean b;
        ResultSetRewindable resultsExpected;
        ResultSetRewindable resultsActual = ResultSetFactory.makeRewindable((ResultSet)qe.execSelect());
        qe.close();
        if (this.results == null) {
            return;
        }
        if (this.results.isResultSet()) {
            resultsExpected = ResultSetFactory.makeRewindable((ResultSet)this.results.getResultSet());
        } else if (this.results.isModel()) {
            resultsExpected = ResultSetFactory.makeRewindable((Model)this.results.getModel());
        } else {
            QueryTest.fail((String)"Wrong result type for SELECT query");
            resultsExpected = null;
        }
        if (query.isReduced()) {
            resultsExpected = QueryTest.unique((com.hp.hpl.jena.sparql.resultset.ResultSetRewindable)resultsExpected);
            resultsActual = QueryTest.unique((com.hp.hpl.jena.sparql.resultset.ResultSetRewindable)resultsActual);
        }
        if (!(b = QueryTest.resultSetEquivalent(query, (com.hp.hpl.jena.sparql.resultset.ResultSetRewindable)resultsExpected, (com.hp.hpl.jena.sparql.resultset.ResultSetRewindable)resultsActual))) {
            this.printFailedResultSetTest(query, qe, (com.hp.hpl.jena.sparql.resultset.ResultSetRewindable)resultsExpected, (com.hp.hpl.jena.sparql.resultset.ResultSetRewindable)resultsActual);
        }
        QueryTest.assertTrue((String)("Results do not match: " + this.testItem.getName()), (boolean)b);
    }

    private static com.hp.hpl.jena.sparql.resultset.ResultSetRewindable unique(com.hp.hpl.jena.sparql.resultset.ResultSetRewindable results) {
        ArrayList<Binding> x = new ArrayList<Binding>();
        HashSet<Binding> seen = new HashSet<Binding>();
        while (results.hasNext()) {
            Binding b = results.nextBinding();
            if (seen.contains(b)) continue;
            seen.add(b);
            x.add(b);
        }
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(x.iterator());
        ResultSetStream rs = new ResultSetStream(results.getResultVars(), ModelFactory.createDefaultModel(), (QueryIterator)qIter);
        return ResultSetFactory.makeRewindable((ResultSet)rs);
    }

    public static boolean resultSetEquivalent(Query query, com.hp.hpl.jena.sparql.resultset.ResultSetRewindable resultsExpected, com.hp.hpl.jena.sparql.resultset.ResultSetRewindable resultsActual) {
        if (query.isOrdered()) {
            return ResultSetCompare.equalsByValueAndOrder((ResultSet)resultsExpected, (ResultSet)resultsActual);
        }
        return ResultSetCompare.equalsByValue((ResultSet)resultsExpected, (ResultSet)resultsActual);
    }

    private boolean checkResultsByModel(Query query, Model expectedModel, com.hp.hpl.jena.sparql.resultset.ResultSetRewindable results) {
        results.reset();
        Model actualModel = ResultSetFormatter.toModel((ResultSet)results);
        expectedModel.removeAll(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        expectedModel.removeAll(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSolution);
        expectedModel.removeAll(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultBinding);
        expectedModel.removeAll(null, ResultSetGraphVocab.size, (RDFNode)null);
        expectedModel.removeAll(null, ResultSetGraphVocab.index, (RDFNode)null);
        actualModel.removeAll(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
        actualModel.removeAll(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSolution);
        actualModel.removeAll(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultBinding);
        actualModel.removeAll(null, ResultSetGraphVocab.size, (RDFNode)null);
        actualModel.removeAll(null, ResultSetGraphVocab.index, (RDFNode)null);
        boolean b = expectedModel.isIsomorphicWith(actualModel);
        if (!b) {
            System.out.println("---- Expected");
            expectedModel.write((OutputStream)System.out, "TTL");
            System.out.println("---- Actual");
            actualModel.write((OutputStream)System.out, "TTL");
            System.out.println("----");
        }
        return b;
    }

    void runTestConstruct(Query query, QueryExecution qe) throws Exception {
        Model resultsActual = qe.execConstruct();
        this.compareGraphResults(resultsActual, query);
    }

    private void compareGraphResults(Model resultsActual, Query query) {
        if (this.results != null) {
            try {
                Model resultsExpected;
                if (!this.results.isGraph()) {
                    QueryTest.fail((String)("Expected results are not a graph: " + this.testItem.getName()));
                }
                if (!(resultsExpected = this.results.getModel()).isIsomorphicWith(resultsActual)) {
                    this.printFailedModelTest(query, resultsExpected, resultsActual);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                String typeName = query.isConstructType() ? "construct" : "describe";
                QueryTest.fail((String)("Exception in result testing (" + typeName + "): " + ex));
            }
        }
    }

    void runTestDescribe(Query query, QueryExecution qe) throws Exception {
        Model resultsActual = qe.execDescribe();
        this.compareGraphResults(resultsActual, query);
    }

    void runTestAsk(Query query, QueryExecution qe) throws Exception {
        boolean result = qe.execAsk();
        if (this.results != null) {
            if (this.results.isBoolean()) {
                boolean b = this.results.getBooleanResult();
                QueryTest.assertEquals((String)"ASK test results do not match", (boolean)b, (boolean)result);
            } else {
                Property p;
                Model resultsAsModel = this.results.getModel();
                StmtIterator sIter = this.results.getModel().listStatements(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
                if (!sIter.hasNext()) {
                    throw new QueryTestException("Can't find the ASK result");
                }
                Statement s = sIter.nextStatement();
                if (sIter.hasNext()) {
                    throw new QueryTestException("Too many result sets in ASK result");
                }
                Resource r = s.getSubject();
                boolean x = r.getRequiredProperty(p = resultsAsModel.createProperty(ResultSetGraphVocab.getURI() + "boolean")).getBoolean();
                if (x != result) {
                    QueryTest.assertEquals((String)"ASK test results do not match", (boolean)x, (boolean)result);
                }
            }
        }
    }

    void printFailedResultSetTest(Query query, QueryExecution qe, com.hp.hpl.jena.sparql.resultset.ResultSetRewindable qrExpected, com.hp.hpl.jena.sparql.resultset.ResultSetRewindable qrActual) {
        PrintStream out = System.out;
        out.println();
        out.println("=======================================");
        out.println("Failure: " + this.description());
        out.println("Query: \n" + query);
        out.println("Got: " + qrActual.size() + " --------------------------------");
        qrActual.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qrActual, (PrefixMapping)query.getPrefixMapping());
        qrActual.reset();
        out.flush();
        out.println("Expected: " + qrExpected.size() + " -----------------------------");
        qrExpected.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qrExpected, (PrefixMapping)query.getPrefixMapping());
        qrExpected.reset();
        out.println();
        out.flush();
    }

    void printFailedModelTest(Query query, Model expected, Model results) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        out.println("=======================================");
        out.println("Failure: " + this.description());
        results.write((Writer)out, "TTL");
        out.println("---------------------------------------");
        expected.write((Writer)out, "TTL");
        out.println();
    }

    public String toString() {
        if (this.testItem.getName() != null) {
            return this.testItem.getName();
        }
        return super.getName();
    }

    private String description() {
        if (this._description == null) {
            this._description = this.makeDescription();
        }
        return this._description;
    }

    private String makeDescription() {
        Iterator<String> iter;
        String tmp = "";
        if (this.testItem.getDefaultGraphURIs() != null) {
            iter = this.testItem.getDefaultGraphURIs().iterator();
            while (iter.hasNext()) {
                tmp = tmp + iter.next();
            }
        }
        if (this.testItem.getNamedGraphURIs() != null) {
            iter = this.testItem.getNamedGraphURIs().iterator();
            while (iter.hasNext()) {
                tmp = tmp + iter.next();
            }
        }
        String d = "Test " + this.testNumber + " :: " + this.testItem.getName();
        return d;
    }
}

