/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;

public class TestOrdering
extends TestCase {
    NodeValue nvInt2 = NodeValue.makeNodeInteger((long)2L);
    NodeValue nvInt3 = NodeValue.makeNodeInteger((String)"3");
    NodeValue nvInt03 = NodeValue.makeNodeInteger((String)"03");
    NodeValue nvStr3 = NodeValue.makeNodeString((String)"3");
    NodeValue nvStr03 = NodeValue.makeNodeString((String)"03");
    NodeValue nvInt9 = NodeValue.makeNodeInteger((long)9L);
    NodeValue nvPosInt9 = NodeValue.makeNode((String)"9", (XSDDatatype)XSDDatatype.XSDpositiveInteger);
    NodeValue nvInt10 = NodeValue.makeNodeInteger((long)10L);
    NodeValue nvDouble9 = NodeValue.makeNodeDouble((double)9.0);
    NodeValue nvFloat8 = NodeValue.makeNode((String)"8.0", (XSDDatatype)XSDDatatype.XSDfloat);
    NodeValue nvByte10 = NodeValue.makeNode((String)"10", (XSDDatatype)XSDDatatype.XSDbyte);
    Node nInt2 = this.nvInt2.getNode();
    Node nInt3 = this.nvInt3.getNode();
    Node nInt03 = this.nvInt03.getNode();
    Node nStr3 = this.nvStr3.getNode();
    Node nStr03 = this.nvStr03.getNode();
    Node nInt9 = this.nvInt9.getNode();
    Node nPosInt9 = this.nvPosInt9.getNode();
    Node nInt10 = this.nvInt10.getNode();
    Node nDouble9 = this.nvDouble9.getNode();
    Node nFloat8 = this.nvFloat8.getNode();
    Node nByte10 = this.nvByte10.getNode();

    public static Test suite() {
        return new JUnit4TestAdapter(TestOrdering.class);
    }

    @org.junit.Test
    public void testComp_2_3() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt2, (NodeValue)this.nvInt3);
        TestOrdering.assertTrue((String)"2 should be value-less than 3", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt2, (Node)this.nInt3);
        TestOrdering.assertTrue((String)"2 should be strict-less than 3", (-1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_3_str3() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt3, (NodeValue)this.nvStr3);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt3, (Node)this.nStr3);
        TestOrdering.assertTrue((String)"3 should be compareAlways greater than \"3\"", (1 == x ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"3 should be syntactic-greater than to \"3\"", (1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_03_str3() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt03, (NodeValue)this.nvStr3);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt03, (Node)this.nStr3);
        TestOrdering.assertTrue((String)"03 (typed) should be compareAlways 'less than' than \"3\"", (-1 == x ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"03 should be syntactic-less than to \"3\"", (-1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_int_double_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt10, (NodeValue)this.nvDouble9);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt10, (Node)this.nDouble9);
        TestOrdering.assertTrue((String)"Int 10 less than double 9", (1 == x ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"Int 10 less than double 9 in syntactic compare", (-1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_byte_double_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvByte10, (NodeValue)this.nvDouble9);
        int y = NodeUtils.compareRDFTerms((Node)this.nByte10, (Node)this.nDouble9);
        TestOrdering.assertTrue((String)"Byte 10 less than double 9", (1 == x ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"Byte 10 greater than double 9 in non-value compare (dataype URIs compare)", (-1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_int_float_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt10, (NodeValue)this.nvFloat8);
        int y = NodeUtils.compareRDFTerms((Node)this.nInt10, (Node)this.nFloat8);
        TestOrdering.assertTrue((String)"Int 10 less than float 8", (1 == x ? 1 : 0) != 0);
        TestOrdering.assertTrue((String)"Int 10 less than float 8 in syntatic compare", (-1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_int_posint_1() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt9, (NodeValue)this.nvPosInt9);
        TestOrdering.assertTrue((String)"Int 9 should be not equals to positive integer 9", (0 != x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComp_int_posint_2() {
        int x = NodeValue.compareAlways((NodeValue)this.nvInt10, (NodeValue)this.nvPosInt9);
        TestOrdering.assertTrue((String)"Int 10 not greater than positive integer 9", (1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_xsd_string1() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", null));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", (RDFDatatype)XSDDatatype.XSDstring))));
        TestOrdering.assertTrue((0 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_xsd_string2() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"", null));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", (RDFDatatype)XSDDatatype.XSDstring))));
        TestOrdering.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_xsd_string3() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", null))));
        TestOrdering.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_xsd_string4() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", null));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"", (RDFDatatype)XSDDatatype.XSDstring))));
        TestOrdering.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_xsd_string5() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compare((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"", null))));
        TestOrdering.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang1() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"en", null));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", null));
        int x = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((String)"Lang tags should sort after plain literal", (1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang2() {
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"en", null));
        NodeValue nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"EN", null));
        int x = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((String)"Lang tags should sort by case", (1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang3() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"ABC", (String)"en", null));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"EN", null))));
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical if tags value-same", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((String)"Lang nodes should sort by case (syntactically)", (-1 == y ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang4() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"ABC", (String)"en", null));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"en", null))));
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical if tags the same", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical form if lang tags the same", (-1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang5() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", null));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"en", null))));
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical form if one is plain", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang6() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"", null));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"en", null))));
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical form if one is plain", (1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang7() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"en", null))));
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical form if other is XSD string", (-1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((-1 == x ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void test_lang8() {
        NodeValue nv2;
        NodeValue nv1 = NodeValue.makeNode((Node)Node.createLiteral((String)"xyz", (String)"", (RDFDatatype)XSDDatatype.XSDstring));
        int x = NodeValue.compareAlways((NodeValue)nv1, (NodeValue)(nv2 = NodeValue.makeNode((Node)Node.createLiteral((String)"abc", (String)"en", null))));
        TestOrdering.assertTrue((String)"Lang nodes should sort by lexical form if other is XSD string", (1 == x ? 1 : 0) != 0);
        int y = NodeUtils.compareRDFTerms((Node)nv1.asNode(), (Node)nv2.asNode());
        TestOrdering.assertTrue((1 == x ? 1 : 0) != 0);
    }
}

