/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import junit.framework.JUnit4TestAdapter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestExpressions {
    public static final int NO_FAILURE = 100;
    public static final int PARSE_FAIL = 250;
    public static final int EVAL_FAIL = 200;
    static boolean flagVerboseWarning;
    static String duration1;
    static String duration2;
    static String duration3;
    static String duration4;
    static String duration5;
    static String duration7;
    static String duration8;
    static String dateTime1;
    static String dateTime2;
    static String dateTime3;
    static String dateTime4;
    static String time1;
    static String time2;
    static String time3;
    static String time4;
    static String exNS;
    static String xNS;
    static String selNS;
    static String dftNS;
    static String baseNS;
    static String rdfNS;
    static Query query;
    static String xsd;
    static Binding env;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestExpressions.class);
    }

    @BeforeClass
    public static void beforeClass() {
        flagVerboseWarning = NodeValue.VerboseWarnings;
        NodeValue.VerboseWarnings = false;
    }

    @AfterClass
    public static void afterClass() {
        NodeValue.VerboseWarnings = flagVerboseWarning;
    }

    @Test
    public void testVar_1() {
        TestExpressions.testVar("?x", "x");
    }

    @Test
    public void testVar_2() {
        TestExpressions.testVar("$x", "x");
    }

    @Test
    public void testVar_3() {
        TestExpressions.testVar("?name", "name");
    }

    @Test
    public void testVar_4() {
        TestExpressions.testVar("$name", "name");
    }

    @Test
    public void testSyntax_1() {
        TestExpressions.testSyntax("?x11");
    }

    @Test
    public void testVar_5() {
        TestExpressions.testVar("?x_", "x_");
    }

    @Test
    public void testVar_6() {
        TestExpressions.testVar("?x.", "x");
    }

    @Test
    public void testVar_7() {
        TestExpressions.testVar("?x.x", "x");
    }

    @Test
    public void testVar_8() {
        TestExpressions.testVar("?0", "0");
    }

    @Test
    public void testVar_9() {
        TestExpressions.testVar("?0x", "0x");
    }

    @Test
    public void testVar_10() {
        TestExpressions.testVar("?x0", "x0");
    }

    @Test
    public void testVar_11() {
        TestExpressions.testVar("?_", "_");
    }

    @Test(expected=QueryParseException.class)
    public void testVar_12() {
        TestExpressions.testVar("?", "");
    }

    @Test(expected=QueryParseException.class)
    public void testSyntax_2() {
        TestExpressions.testSyntax("??");
    }

    @Test(expected=QueryParseException.class)
    public void testSyntax_3() {
        TestExpressions.testSyntax("?.");
    }

    @Test(expected=QueryParseException.class)
    public void testSyntax_4() {
        TestExpressions.testSyntax("?#");
    }

    @Test
    public void testNumeric_1() {
        TestExpressions.testNumeric("7", 7);
    }

    @Test
    public void testNumeric_2() {
        TestExpressions.testNumeric("-3", -3);
    }

    @Test
    public void testNumeric_3() {
        TestExpressions.testNumeric("+2", 2);
    }

    @Test(expected=QueryParseException.class)
    public void testNumeric_4() {
        TestExpressions.testNumeric("0xF", 15);
    }

    @Test(expected=QueryParseException.class)
    public void testNumeric_5() {
        TestExpressions.testNumeric("0x12", 18);
    }

    @Test
    public void testNumeric_6() {
        TestExpressions.testNumeric("3--4", 7);
    }

    @Test
    public void testNumeric_7() {
        TestExpressions.testNumeric("3++4", 7);
    }

    @Test
    public void testNumeric_8() {
        TestExpressions.testNumeric("3-+4", -1);
    }

    @Test
    public void testNumeric_9() {
        TestExpressions.testNumeric("3+-4", -1);
    }

    @Test
    public void testNumeric_10() {
        TestExpressions.testNumeric("3-(-4)", 7);
    }

    @Test
    public void testNumeric_11() {
        TestExpressions.testNumeric("3+4+5", 12);
    }

    @Test
    public void testNumeric_12() {
        TestExpressions.testNumeric("(3+4)+5", 12);
    }

    @Test
    public void testNumeric_13() {
        TestExpressions.testNumeric("3+(4+5)", 12);
    }

    @Test
    public void testNumeric_14() {
        TestExpressions.testNumeric("3*4+5", 17);
    }

    @Test
    public void testNumeric_15() {
        TestExpressions.testNumeric("3*(4+5)", 27);
    }

    @Test
    public void testNumeric_16() {
        TestExpressions.testNumeric("10-3-5", 2);
    }

    @Test
    public void testNumeric_17() {
        TestExpressions.testNumeric("(10-3)-5", 2);
    }

    @Test
    public void testNumeric_18() {
        TestExpressions.testNumeric("10-(3-5)", 12);
    }

    @Test
    public void testNumeric_19() {
        TestExpressions.testNumeric("10-3+5", 12);
    }

    @Test
    public void testNumeric_20() {
        TestExpressions.testNumeric("10-(3+5)", 2);
    }

    @Test(expected=QueryParseException.class)
    public void testNumeric_21() {
        TestExpressions.testNumeric("1<<2", 4);
    }

    @Test(expected=QueryParseException.class)
    public void testNumeric_22() {
        TestExpressions.testNumeric("1<<2<<2", 16);
    }

    @Test(expected=QueryParseException.class)
    public void testNumeric_23() {
        TestExpressions.testNumeric("10000>>2", 2500);
    }

    @Test
    public void testNumeric_24() {
        TestExpressions.testNumeric("1.5 + 2.5", 4.0);
    }

    @Test
    public void testNumeric_25() {
        TestExpressions.testNumeric("1.5 + 2", 3.5);
    }

    @Test
    public void testNumeric_26() {
        TestExpressions.testNumeric("4111222333444", 4.111222333444E12);
    }

    @Test
    public void testNumeric_27() {
        TestExpressions.testNumeric("1234 + 4111222333444", 4.111222334678E12);
    }

    @Test
    public void testBoolean_1() {
        TestExpressions.testBoolean("4111222333444 > 1234", true);
    }

    @Test
    public void testBoolean_2() {
        TestExpressions.testBoolean("4111222333444 < 1234", false);
    }

    @Test
    public void testBoolean_3() {
        TestExpressions.testBoolean("1.5 < 2", true);
    }

    @Test
    public void testBoolean_4() {
        TestExpressions.testBoolean("1.5 > 2", false);
    }

    @Test
    public void testBoolean_5() {
        TestExpressions.testBoolean("1.5 < 2.3", true);
    }

    @Test
    public void testBoolean_6() {
        TestExpressions.testBoolean("1.5 > 2.3", false);
    }

    @Test
    public void testBoolean_7() {
        TestExpressions.testBoolean("'true'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true);
    }

    @Test
    public void testBoolean_8() {
        TestExpressions.testBoolean("'1'^^<" + XSDDatatype.XSDboolean.getURI() + ">", true);
    }

    @Test
    public void testBoolean_9() {
        TestExpressions.testBoolean("'false'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false);
    }

    @Test
    public void testBoolean_10() {
        TestExpressions.testBoolean("'0'^^<" + XSDDatatype.XSDboolean.getURI() + ">", false);
    }

    @Test
    public void testBoolean_11() {
        TestExpressions.testBoolean("1 || false", true);
    }

    @Test
    public void testBoolean_12() {
        TestExpressions.testBoolean("'foo'  || false", true);
    }

    @Test
    public void testBoolean_13() {
        TestExpressions.testBoolean("0 || false", false);
    }

    @Test
    public void testBoolean_14() {
        TestExpressions.testBoolean("'' || false", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_15() {
        TestExpressions.testEval("!'junk'^^<urn:unknown>");
    }

    @Test
    public void testBoolean_16() {
        TestExpressions.testBoolean("2 < 3", true);
    }

    @Test
    public void testBoolean_17() {
        TestExpressions.testBoolean("2 > 3", false);
    }

    @Test
    public void testBoolean_18() {
        TestExpressions.testBoolean("(2 < 3) && (3<4)", true);
    }

    @Test
    public void testBoolean_19() {
        TestExpressions.testBoolean("(2 < 3) && (3>=4)", false);
    }

    @Test
    public void testBoolean_20() {
        TestExpressions.testBoolean("(2 < 3) || (3>=4)", true);
    }

    @Test
    public void testBoolean_21() {
        TestExpressions.testBoolean("(2 < 3) || ?x > 2", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_22() {
        TestExpressions.testEval("(2 > 3) || ?x > 2");
    }

    @Test
    public void testBoolean_23() {
        TestExpressions.testBoolean("(2 > 3) && ?x > 2", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_24() {
        TestExpressions.testEval("(2 < 3) && ?x > 2");
    }

    @Test
    public void testBoolean_25() {
        TestExpressions.testBoolean("?x > 2 || (2 < 3)", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_26() {
        TestExpressions.testEval("?x > 2 || (2 > 3)");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_27() {
        TestExpressions.testEval("?x > 2 && (2 < 3)");
    }

    @Test
    public void testBoolean_28() {
        TestExpressions.testBoolean("?x > 2 && (2 > 3)", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_29() {
        TestExpressions.testEval("! ?x ");
    }

    @Test
    public void testBoolean_30() {
        TestExpressions.testBoolean("! true ", false);
    }

    @Test
    public void testBoolean_31() {
        TestExpressions.testBoolean("! false ", true);
    }

    @Test
    public void testBoolean_32() {
        TestExpressions.testBoolean("2 = 3", false);
    }

    @Test
    public void testBoolean_33() {
        TestExpressions.testBoolean("!(2 = 3)", true);
    }

    @Test
    public void testBoolean_34() {
        TestExpressions.testBoolean("'2' = 2", false);
    }

    @Test
    public void testBoolean_35() {
        TestExpressions.testBoolean("2 = '2'", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_36() {
        TestExpressions.testEval("2 < '3'");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_37() {
        TestExpressions.testEval("'2' < 3");
    }

    @Test
    public void testBoolean_38() {
        TestExpressions.testBoolean("\"fred\" != \"joe\"", true);
    }

    @Test
    public void testBoolean_39() {
        TestExpressions.testBoolean("\"fred\" = \"joe\"", false);
    }

    @Test
    public void testBoolean_40() {
        TestExpressions.testBoolean("\"fred\" = \"fred\"", true);
    }

    @Test
    public void testBoolean_41() {
        TestExpressions.testBoolean("\"fred\" = 'fred'", true);
    }

    @Test
    public void testBoolean_42() {
        TestExpressions.testBoolean("true = true", true);
    }

    @Test
    public void testBoolean_43() {
        TestExpressions.testBoolean("false = false", true);
    }

    @Test
    public void testBoolean_44() {
        TestExpressions.testBoolean("true = false", false);
    }

    @Test
    public void testBoolean_45() {
        TestExpressions.testBoolean("true > true", false);
    }

    @Test
    public void testBoolean_46() {
        TestExpressions.testBoolean("true >= false", true);
    }

    @Test
    public void testBoolean_47() {
        TestExpressions.testBoolean("false > false", false);
    }

    @Test
    public void testBoolean_48() {
        TestExpressions.testBoolean("false >= false", true);
    }

    @Test
    public void testBoolean_49() {
        TestExpressions.testBoolean("true > false", true);
    }

    @Test
    public void testBoolean_50() {
        TestExpressions.testBoolean("1 = true", false);
    }

    @Test
    public void testBoolean_51() {
        TestExpressions.testBoolean("1 != true", true);
    }

    @Test
    public void testBoolean_52() {
        TestExpressions.testBoolean("'a' != false", true);
    }

    @Test
    public void testBoolean_53() {
        TestExpressions.testBoolean("0 != false", true);
    }

    @Test
    public void testBoolean_54() {
        TestExpressions.testBoolean(dateTime1 + " = " + dateTime2, true);
    }

    @Test
    public void testBoolean_55() {
        TestExpressions.testBoolean(dateTime1 + " <= " + dateTime2, true);
    }

    @Test
    public void testBoolean_56() {
        TestExpressions.testBoolean(dateTime1 + " >= " + dateTime2, true);
    }

    @Test
    public void testBoolean_57() {
        TestExpressions.testBoolean(dateTime3 + " < " + dateTime1, true);
    }

    @Test
    public void testBoolean_58() {
        TestExpressions.testBoolean(dateTime3 + " > " + dateTime1, false);
    }

    @Test
    public void testBoolean_59() {
        TestExpressions.testBoolean(dateTime4 + " < " + dateTime1, false);
    }

    @Test
    public void testBoolean_60() {
        TestExpressions.testBoolean(dateTime4 + " > " + dateTime1, true);
    }

    @Test
    public void testBoolean_61() {
        TestExpressions.testBoolean(time1 + " = " + time2, true);
    }

    @Test
    public void testBoolean_62() {
        TestExpressions.testBoolean(time1 + " <= " + time2, true);
    }

    @Test
    public void testBoolean_63() {
        TestExpressions.testBoolean(time1 + " >= " + time2, true);
    }

    @Test
    public void testBoolean_64() {
        TestExpressions.testBoolean(time3 + " < " + time2, false);
    }

    @Test
    public void testBoolean_65() {
        TestExpressions.testBoolean(time3 + " > " + time2, true);
    }

    @Test
    public void testBoolean_66() {
        TestExpressions.testBoolean(time4 + " < " + time2, true);
    }

    @Test
    public void testBoolean_67() {
        TestExpressions.testBoolean(time4 + " > " + time2, false);
    }

    @Test
    public void testBoolean_68() {
        TestExpressions.testBoolean("isNumeric(12)", true);
    }

    @Test
    public void testBoolean_69() {
        TestExpressions.testBoolean("isNumeric('12')", false);
    }

    @Test
    public void testBoolean_70() {
        TestExpressions.testBoolean("isNumeric('12'^^<" + XSDDatatype.XSDbyte.getURI() + ">)", true);
    }

    @Test
    public void testBoolean_71() {
        TestExpressions.testBoolean("isNumeric('1200'^^<" + XSDDatatype.XSDbyte.getURI() + ">)", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_72() {
        TestExpressions.testBoolean("isNumeric(?x)", true);
    }

    @Test
    public void testDuration_01() {
        TestExpressions.testBoolean(duration1 + " = " + duration1, true);
    }

    @Test
    public void testDuration_02() {
        TestExpressions.testBoolean(duration1 + " < " + duration2, true);
    }

    @Test
    public void testDuration_03() {
        TestExpressions.testBoolean(duration1 + " > " + duration2, false);
    }

    @Test
    public void testDuration_04() {
        TestExpressions.testBoolean(duration1 + " < " + duration2, true);
    }

    @Test
    public void testDuration_05() {
        TestExpressions.testBoolean(duration1 + " = " + duration3, true);
    }

    @Test
    public void testDuration_06() {
        TestExpressions.testBoolean(duration1 + " <= " + duration3, true);
    }

    @Test
    public void testDuration_07() {
        TestExpressions.testBoolean(duration1 + " >= " + duration3, true);
    }

    @Test
    public void testDuration_09() {
        TestExpressions.testBoolean(duration7 + " < " + duration8, true);
    }

    @Test
    public void testURI_1() {
        TestExpressions.testURI("<a>", baseNS + "a");
    }

    @Test
    public void testURI_2() {
        TestExpressions.testURI("<a\\u00E9>", baseNS + "a\u00e9");
    }

    @Test
    public void testURI_3() {
        TestExpressions.testURI("ex:b", exNS + "b");
    }

    @Test
    public void testURI_4() {
        TestExpressions.testURI("ex:b_", exNS + "b_");
    }

    @Test
    public void testURI_5() {
        TestExpressions.testURI("ex:a_b", exNS + "a_b");
    }

    @Test
    public void testURI_6() {
        TestExpressions.testURI("ex:", exNS);
    }

    @Test(expected=QueryParseException.class)
    public void testURI_7() {
        TestExpressions.testURI("x.:", xNS);
    }

    @Test
    public void testURI_8() {
        TestExpressions.testURI("rdf:_2", rdfNS + "_2");
    }

    @Test
    public void testURI_9() {
        TestExpressions.testURI("rdf:__2", rdfNS + "__2");
    }

    @Test
    public void testURI_10() {
        TestExpressions.testURI(":b", dftNS + "b");
    }

    @Test
    public void testURI_11() {
        TestExpressions.testURI(":", dftNS);
    }

    @Test
    public void testURI_12() {
        TestExpressions.testURI(":\\u00E9", dftNS + "\u00e9");
    }

    @Test
    public void testURI_13() {
        TestExpressions.testURI("\\u0065\\u0078:", exNS);
    }

    @Test
    public void testURI_14() {
        TestExpressions.testURI("select:a", selNS + "a");
    }

    @Test(expected=QueryParseException.class)
    public void testSyntax_5() {
        TestExpressions.testSyntax("_:");
    }

    @Test
    public void testURI_15() {
        TestExpressions.testURI("ex:a.", exNS + "a");
    }

    @Test
    public void testURI_16() {
        TestExpressions.testURI("ex:a.a", exNS + "a.a");
    }

    @Test(expected=QueryParseException.class)
    public void testURI_17() {
        TestExpressions.testURI("x.:a.a", xNS + "a.a");
    }

    @Test
    public void testNumeric_28() {
        TestExpressions.testNumeric("1:b", 1);
    }

    @Test
    public void testURI_18() {
        TestExpressions.testURI("ex:2", exNS + "2");
    }

    @Test
    public void testURI_19() {
        TestExpressions.testURI("ex:2ab_c", exNS + "2ab_c");
    }

    @Test
    public void testBoolean_76() {
        TestExpressions.testBoolean("'fred'@en = 'fred'", false);
    }

    @Test
    public void testBoolean_77() {
        TestExpressions.testBoolean("'fred'@en = 'bert'", false);
    }

    @Test
    public void testBoolean_78() {
        TestExpressions.testBoolean("'fred'@en != 'fred'", true);
    }

    @Test
    public void testBoolean_79() {
        TestExpressions.testBoolean("'fred'@en != 'bert'", true);
    }

    @Test
    public void testBoolean_80() {
        TestExpressions.testBoolean("'chat'@en = 'chat'@fr", false);
    }

    @Test
    public void testBoolean_81() {
        TestExpressions.testBoolean("'chat'@en = 'maison'@fr", false);
    }

    @Test
    public void testBoolean_82() {
        TestExpressions.testBoolean("'chat'@en != 'chat'@fr", true);
    }

    @Test
    public void testBoolean_83() {
        TestExpressions.testBoolean("'chat'@en != 'maison'@fr", true);
    }

    @Test
    public void testBoolean_84() {
        TestExpressions.testBoolean("'chat'@en = 'chat'@EN", true);
    }

    @Test
    public void testBoolean_85() {
        TestExpressions.testBoolean("'chat'@en = 'chat'@en-uk", false);
    }

    @Test
    public void testBoolean_86() {
        TestExpressions.testBoolean("'chat'@en != 'chat'@EN", false);
    }

    @Test
    public void testBoolean_87() {
        TestExpressions.testBoolean("'chat'@en != 'chat'@en-uk", true);
    }

    @Test
    public void testBoolean_88() {
        TestExpressions.testBoolean("'chat'@en = <http://example/>", false);
    }

    @Test(expected=QueryParseException.class)
    public void testURI_20() {
        TestExpressions.testURI("()", RDF.nil.getURI());
    }

    @Test(expected=QueryParseException.class)
    public void testSyntax_6() {
        TestExpressions.testSyntax("[]");
    }

    @Test
    public void testBoolean_89() {
        TestExpressions.testBoolean("'fred'^^<type1> = 'fred'^^<type1>", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_90() {
        TestExpressions.testEval("'fred'^^<type1> != 'joe'^^<type1>");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_91() {
        TestExpressions.testEval("'fred'^^<type1> = 'fred'^^<type2>");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_92() {
        TestExpressions.testEval("'fred'^^<type1> != 'joe'^^<type2>");
    }

    @Test
    public void testBoolean_93() {
        TestExpressions.testBoolean("'fred'^^<" + XSDDatatype.XSDstring.getURI() + "> = 'fred'", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_94() {
        TestExpressions.testEval("'fred'^^<type1> = 'fred'");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_95() {
        TestExpressions.testEval("'fred'^^<type1> != 'fred'");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_96() {
        TestExpressions.testBoolean("'21'^^<int> = '21'", true);
    }

    @Test
    public void testNumeric_29() {
        TestExpressions.testNumeric("'21'^^<" + XSDDatatype.XSDinteger.getURI() + ">", 21);
    }

    @Test
    public void testBoolean_97() {
        TestExpressions.testBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 21", true);
    }

    @Test
    public void testBoolean_98() {
        TestExpressions.testBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> = 22", false);
    }

    @Test
    public void testBoolean_99() {
        TestExpressions.testBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> != 21", false);
    }

    @Test
    public void testBoolean_100() {
        TestExpressions.testBoolean("'21'^^<" + XSDDatatype.XSDinteger.getURI() + "> != 22", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_101() {
        TestExpressions.testEval("'x'^^<type1>  = 21");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_102() {
        TestExpressions.testEval("'x'^^<type1> != 21");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_103() {
        TestExpressions.testEval("'x'^^<http://example/unknown> = true");
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_104() {
        TestExpressions.testEval("'x'^^<http://example/unknown> != true");
    }

    @Test
    public void testBoolean_105() {
        TestExpressions.testBoolean("'x'^^<http://example/unknown> = 'x'^^<http://example/unknown>", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_106() {
        TestExpressions.testEval("'x'^^<http://example/unknown> = 'y'^^<http://example/unknown>");
    }

    @Test
    public void testBoolean_107() {
        TestExpressions.testBoolean("'x'^^<http://example/unknown> != 'x'^^<http://example/unknown>", false);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_108() {
        TestExpressions.testEval("'x'^^<http://example/unknown> != 'y'^^<http://example/unknown>");
    }

    @Test
    public void testString_1() {
        TestExpressions.testString("'a\\nb'", "a\nb");
    }

    @Test
    public void testString_2() {
        TestExpressions.testString("'a\\n'", "a\n");
    }

    @Test
    public void testString_3() {
        TestExpressions.testString("'\\nb'", "\nb");
    }

    @Test
    public void testString_4() {
        TestExpressions.testString("'a\\tb'", "a\tb");
    }

    @Test
    public void testString_5() {
        TestExpressions.testString("'a\\bb'", "a\bb");
    }

    @Test
    public void testString_6() {
        TestExpressions.testString("'a\\rb'", "a\rb");
    }

    @Test
    public void testString_7() {
        TestExpressions.testString("'a\\fb'", "a\fb");
    }

    @Test
    public void testString_8() {
        TestExpressions.testString("'a\\\\b'", "a\\b");
    }

    @Test
    public void testString_9() {
        TestExpressions.testString("'a\\u0020a'", "a a");
    }

    @Test
    public void testString_10() {
        TestExpressions.testString("'a\\uF021'", "a\uf021");
    }

    @Test(expected=QueryParseException.class)
    public void testString_11() {
        TestExpressions.testString("'a\\X'");
    }

    @Test(expected=QueryParseException.class)
    public void testString_12() {
        TestExpressions.testString("'aaa\\'");
    }

    @Test(expected=QueryParseException.class)
    public void testString_13() {
        TestExpressions.testString("'\\u'");
    }

    @Test(expected=QueryParseException.class)
    public void testString_14() {
        TestExpressions.testString("'\\u111'");
    }

    @Test
    public void testBoolean_111() {
        TestExpressions.testBoolean("'fred\\\\3' != \"fred3\"", true);
    }

    @Test
    public void testBoolean_112() {
        TestExpressions.testBoolean("'urn:fred' = <urn:fred>", false);
    }

    @Test
    public void testBoolean_113() {
        TestExpressions.testBoolean("'urn:fred' != <urn:fred>", true);
    }

    @Test
    public void testBoolean_114() {
        TestExpressions.testBoolean("'urn:fred' = <urn:fred>", false);
    }

    @Test
    public void testBoolean_115() {
        TestExpressions.testBoolean("'urn:fred' != <urn:fred>", true);
    }

    @Test
    public void testBoolean_116() {
        TestExpressions.testBoolean("REGEX('aabbcc', 'abbc')", true);
    }

    @Test
    public void testBoolean_117() {
        TestExpressions.testBoolean("REGEX('aabbcc' , 'a..c')", true);
    }

    @Test
    public void testBoolean_118() {
        TestExpressions.testBoolean("REGEX('aabbcc' , '^aabb')", true);
    }

    @Test
    public void testBoolean_119() {
        TestExpressions.testBoolean("REGEX('aabbcc' , 'cc$')", true);
    }

    @Test
    public void testBoolean_120() {
        TestExpressions.testBoolean("! REGEX('aabbcc' , 'abbc')", false);
    }

    @Test
    public void testBoolean_121() {
        TestExpressions.testBoolean("REGEX('aa\\\\cc', '\\\\\\\\')", true);
    }

    @Test
    public void testBoolean_122() {
        TestExpressions.testBoolean("REGEX('aab*bcc', 'ab\\\\*bc')", true);
    }

    @Test
    public void testBoolean_123() {
        TestExpressions.testBoolean("REGEX('aabbcc', 'ab\\\\\\\\*bc')", true);
    }

    @Test
    public void testBoolean_124() {
        TestExpressions.testBoolean("REGEX('aabbcc', 'B.*B', 'i')", true);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_125() {
        TestExpressions.testEval("2 < 'fred'");
    }

    @Test
    public void testBoolean_126() {
        TestExpressions.testBoolean("datatype('fred') = <" + XSD.xstring.getURI() + ">", true);
    }

    @Test
    public void testBoolean_127() {
        TestExpressions.testBoolean("datatype('fred'^^<urn:foo>) = <urn:foo>", true);
    }

    @Test
    public void testBoolean_128() {
        TestExpressions.testBoolean("datatype('fred'^^<foo>) = <Foo>", false);
    }

    @Test
    public void testString_15() {
        TestExpressions.testString("lang('fred'@en)", "en");
    }

    @Test
    public void testString_16() {
        TestExpressions.testString("lang('fred'@en-uk)", "en-uk");
    }

    @Test
    public void testString_17() {
        TestExpressions.testString("lang('fred')", "");
    }

    @Test
    public void testBoolean_129() {
        TestExpressions.testBoolean("isURI(?x)", true, env);
    }

    @Test
    public void testBoolean_130() {
        TestExpressions.testBoolean("isURI(?a)", false, env);
    }

    @Test
    public void testBoolean_131() {
        TestExpressions.testBoolean("isURI(?b)", false, env);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_132() {
        TestExpressions.testBoolean("isURI(?y)", false, env);
    }

    @Test
    public void testBoolean_133() {
        TestExpressions.testBoolean("isURI(<urn:foo>)", true, env);
    }

    @Test
    public void testBoolean_134() {
        TestExpressions.testBoolean("isURI('bar')", false, env);
    }

    @Test
    public void testBoolean_135() {
        TestExpressions.testBoolean("isLiteral(?x)", false, env);
    }

    @Test
    public void testBoolean_136() {
        TestExpressions.testBoolean("isLiteral(?a)", true, env);
    }

    @Test
    public void testBoolean_137() {
        TestExpressions.testBoolean("isLiteral(?b)", false, env);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_138() {
        TestExpressions.testBoolean("isLiteral(?y)", false, env);
    }

    @Test
    public void testBoolean_139() {
        TestExpressions.testBoolean("isBlank(?x)", false, env);
    }

    @Test
    public void testBoolean_140() {
        TestExpressions.testBoolean("isBlank(?a)", false, env);
    }

    @Test
    public void testBoolean_141() {
        TestExpressions.testBoolean("isBlank(?b)", true, env);
    }

    @Test(expected=ExprEvalException.class)
    public void testBoolean_142() {
        TestExpressions.testBoolean("isBlank(?y)", false, env);
    }

    @Test
    public void testBoolean_143() {
        TestExpressions.testBoolean("bound(?a)", true, env);
    }

    @Test
    public void testBoolean_144() {
        TestExpressions.testBoolean("bound(?b)", true, env);
    }

    @Test
    public void testBoolean_145() {
        TestExpressions.testBoolean("bound(?x)", true, env);
    }

    @Test
    public void testBoolean_146() {
        TestExpressions.testBoolean("bound(?y)", false, env);
    }

    @Test
    public void testString_18() {
        TestExpressions.testString("str(<urn:x>)", "urn:x");
    }

    @Test
    public void testString_19() {
        TestExpressions.testString("str('')", "");
    }

    @Test
    public void testString_20() {
        TestExpressions.testString("str(15)", "15");
    }

    @Test
    public void testString_21() {
        TestExpressions.testString("str('15.20'^^<" + XSDDatatype.XSDdouble.getURI() + ">)", "15.20");
    }

    @Test
    public void testString_22() {
        TestExpressions.testString("str('lex'^^<x:unknown>)", "lex");
    }

    @Test
    public void testBoolean_147() {
        TestExpressions.testBoolean("sameTerm(1, 1)", true, env);
    }

    @Test
    public void testBoolean_148() {
        TestExpressions.testBoolean("sameTerm(1, 1.0)", false, env);
    }

    @Test
    public void testNumeric_30() {
        TestExpressions.testNumeric("<" + xsd + "integer>('3')", 3);
    }

    @Test
    public void testNumeric_31() {
        TestExpressions.testNumeric("<" + xsd + "byte>('3')", 3);
    }

    @Test
    public void testNumeric_32() {
        TestExpressions.testNumeric("<" + xsd + "int>('3')", 3);
    }

    @Test
    public void testBoolean_149() {
        TestExpressions.testBoolean("<" + xsd + "double>('3') = 3", true);
    }

    @Test
    public void testBoolean_150() {
        TestExpressions.testBoolean("<" + xsd + "float>('3') = 3", true);
    }

    @Test
    public void testBoolean_151() {
        TestExpressions.testBoolean("<" + xsd + "double>('3') = <" + xsd + "float>('3')", true);
    }

    @Test
    public void testBoolean_152() {
        TestExpressions.testBoolean("<" + xsd + "double>(str('3')) = 3", true);
    }

    @Test
    public void testString_23() {
        TestExpressions.testString("'a'+'b'", "ab");
    }

    @Test(expected=ExprEvalException.class)
    public void testString_24() {
        TestExpressions.testString("'a'+12");
    }

    public void testString_25() {
        TestExpressions.testString("12+'a'");
    }

    public void testString_26() {
        TestExpressions.testString("<uri>+'a'");
    }

    private static Expr parse(String exprString) {
        return ExprUtils.parse((Query)query, (String)exprString, (boolean)false);
    }

    private static void testVar(String string, String rightVarName) {
        Expr expr = TestExpressions.parse(string);
        Assert.assertTrue((String)("Not a NodeVar: " + expr), (boolean)expr.isVariable());
        ExprVar v = (ExprVar)expr;
        Assert.assertEquals((String)"Different variable names", (Object)rightVarName, (Object)v.getVarName());
    }

    private static void testSyntax(String exprString) {
        ExprUtils.parse((Query)query, (String)exprString, (boolean)false);
    }

    private static void testNumeric(String string, int i) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(BindingFactory.binding(), (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((boolean)v.isInteger());
        Assert.assertEquals((long)i, (long)v.getInteger().intValue());
    }

    private static void testNumeric(String string, double d) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(BindingFactory.binding(), (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((boolean)v.isDouble());
        Assert.assertEquals((double)d, (double)v.getDouble(), (double)0.0);
    }

    private static void testEval(String string) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(BindingFactory.binding(), (FunctionEnv)new FunctionEnvBase());
    }

    private static void testBoolean(String string, boolean b) {
        TestExpressions.testBoolean(string, b, BindingFactory.binding());
    }

    private static void testBoolean(String string, boolean b, Binding env) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(env, (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((boolean)v.isBoolean());
        Assert.assertEquals((Object)b, (Object)v.getBoolean());
    }

    private static void testURI(String string, String uri) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(env, (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((boolean)v.isIRI());
        Assert.assertEquals((Object)uri, (Object)v.getNode().getURI());
    }

    private static void testString(String string, String string2) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(env, (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((boolean)v.isString());
        Assert.assertEquals((Object)string2, (Object)v.getString());
    }

    private static void testString(String string) {
        Expr expr = TestExpressions.parse(string);
        NodeValue v = expr.eval(env, (FunctionEnv)new FunctionEnvBase());
        Assert.assertTrue((boolean)v.isString());
    }

    static {
        duration1 = "'P1Y1M1DT1H1M1S'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        duration2 = "'P2Y1M1DT1H1M1S'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        duration3 = "'P1Y1M1DT1H1M1S'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        duration4 = "'PT1H1M1S'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        duration5 = "'PT1H1M1.1S'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        duration7 = "'-PT1H'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        duration8 = "'PT0H0M0S'^^<" + XSDDatatype.XSDduration.getURI() + ">";
        dateTime1 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        dateTime2 = "'2005-02-25T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        dateTime3 = "'2005-01-01T12:03:34Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        dateTime4 = "'2005-02-25T13:00:00Z'^^<" + XSDDatatype.XSDdateTime.getURI() + ">";
        time1 = "'12:03:34Z'^^<" + XSDDatatype.XSDtime.getURI() + ">";
        time2 = "'12:03:34Z'^^<" + XSDDatatype.XSDtime.getURI() + ">";
        time3 = "'13:00:00Z'^^<" + XSDDatatype.XSDtime.getURI() + ">";
        time4 = "'11:03:34Z'^^<" + XSDDatatype.XSDtime.getURI() + ">";
        exNS = "http://example.org/";
        xNS = "http://example.org/dot#";
        selNS = "http://select/";
        dftNS = "http://default/";
        baseNS = "http://base/";
        rdfNS = RDF.getURI();
        query = QueryFactory.make();
        query.setBaseURI(baseNS);
        query.setPrefix("ex", exNS);
        query.setPrefix("rdf", RDF.getURI());
        query.setPrefix("x.", xNS);
        query.setPrefix("", dftNS);
        query.setPrefix("select", selNS);
        xsd = "http://www.w3.org/2001/XMLSchema#";
        env = new BindingMap();
        env.add(Var.alloc((String)"a"), Node.createLiteral((String)"A"));
        env.add(Var.alloc((String)"b"), Node.createAnon());
        env.add(Var.alloc((String)"x"), Node.createURI((String)"urn:x"));
    }
}

