/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.lang.ParserBase;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;

public class TestEsc
extends TestCase {
    public static Test suite() {
        return new JUnit4TestAdapter(TestEsc.class);
    }

    @org.junit.Test
    public void testEsc01() {
        this.execTest("x\\uabcd", "x\uabcd");
    }

    @org.junit.Test
    public void testEsc02() {
        this.execTest("\\uabcdx", "\uabcdx");
    }

    @org.junit.Test
    public void testEsc03() {
        this.execTest("1234\\uabcd1234", "1234\uabcd1234");
    }

    @org.junit.Test
    public void testEsc04() {
        this.execTestFail("\\X");
    }

    @org.junit.Test
    public void testEsc05() {
        this.execTestFail("\\Xz");
    }

    @org.junit.Test
    public void testEsc06() {
        this.execTestFail("a\\X");
    }

    @org.junit.Test
    public void testEscUni01() {
        this.execTestFail("\\uabck");
    }

    @org.junit.Test
    public void testEscUni02() {
        this.execTestFail("\\uab");
    }

    @org.junit.Test
    public void testEscUni03() {
        this.execTestFail("\\uabc");
    }

    @org.junit.Test
    public void testEscUni04() {
        this.execTestFail("\\ua");
    }

    @org.junit.Test
    public void testEscUni05() {
        this.execTestFail("\\u");
    }

    @org.junit.Test
    public void testEscUni06() {
        this.execTestFail("\\");
    }

    @org.junit.Test
    public void testEscUni07() {
        this.execTest("\\u0020", " ");
    }

    @org.junit.Test
    public void testEscUni08() {
        this.execTest("\\uFFFF", "\uffff");
    }

    @org.junit.Test
    public void testEscUni09() {
        this.execTest("\\u0000", "\u0000");
    }

    @org.junit.Test
    public void testEscUni10() {
        this.execTestFail("\\U0000");
    }

    @org.junit.Test
    public void testEscUni11() {
        this.execTestFail("\\U0000A");
    }

    @org.junit.Test
    public void testEscUni12() {
        this.execTestFail("\\U0000AB");
    }

    @org.junit.Test
    public void testEscUni13() {
        this.execTestFail("\\U0000ABC");
    }

    @org.junit.Test
    public void testEscUni14() {
        this.execTest("\\U0000ABCD", "\uabcd");
    }

    @org.junit.Test
    public void testEscUni15() {
        this.execTestFail("\\U0000");
    }

    @org.junit.Test
    public void testEscUni16() {
        this.execTest("\\U00000000", "\u0000");
    }

    @org.junit.Test
    public void testEscUni17() {
        this.execTest("x\\tx\\nx\\r", "x\tx\nx\r");
    }

    @org.junit.Test
    public void testEscUni18() {
        this.execTest("x\\t\\n\\r", "x\t\n\r");
    }

    private void execTestFail(String input) {
        try {
            String s = ParserBase.unescapeStr((String)input);
            TestEsc.fail((String)("Unescaping succeeded on " + input));
        }
        catch (QueryParseException ex) {
            return;
        }
    }

    private void execTest(String input, String outcome) {
        String result = ParserBase.unescapeStr((String)input);
        TestEsc.assertEquals((String)("Unescaped string does not match (" + input + ")"), (String)outcome, (String)result);
    }
}

