/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openjena.atlas.iterator.Iter;

public abstract class DatasetGraphTests {
    protected abstract DatasetGraph emptyDataset();

    @Test
    public void create_1() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Assert.assertNotNull((Object)dsg.getDefaultGraph());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
    }

    @Test
    public void quad_01() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        Assert.assertTrue((boolean)dsg.contains(quad));
        Iterator iter = dsg.find(quad);
        Assert.assertTrue((boolean)iter.hasNext());
        Quad quad2 = (Quad)iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)quad, (Object)quad2);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertFalse((boolean)dsg.getGraph(Node.createURI((String)"g")).isEmpty());
    }

    @Test
    public void quad_02() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        dsg.containsGraph(Node.createURI((String)"g"));
        dsg.delete(quad);
        Assert.assertTrue((boolean)dsg.isEmpty());
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(Node.createURI((String)"g")).isEmpty());
    }

    @Test
    public void quad_03() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad((String)"(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g> <s> <p> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        dsg.deleteAny(Node.createURI((String)"g"), Node.createURI((String)"s"), null, null);
        Assert.assertFalse((boolean)dsg.contains(quad1));
        Assert.assertFalse((boolean)dsg.contains(quad2));
    }

    @Test
    public void quad_04() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad1 = SSE.parseQuad((String)"(quad <g> <s> <p> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g> <s> <p> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        Iterator iter = dsg.find(Node.createURI((String)"g"), Node.createURI((String)"s"), null, null);
        Assert.assertTrue((boolean)iter.hasNext());
        Set x = Iter.iter((Iterator)iter).toSet();
        Assert.assertEquals((long)2L, (long)x.size());
        Assert.assertTrue((boolean)x.contains(quad1));
        Assert.assertTrue((boolean)x.contains(quad2));
    }

    @Test
    public void graph_01() {
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Node g = Node.createURI((String)"g");
        dsg.addGraph(g, GraphFactory.createDefaultGraph());
        Assert.assertTrue((boolean)dsg.containsGraph(g));
        Triple t = SSE.parseTriple((String)"(<s> <p> <o>)");
        dsg.getGraph(g).add(t);
        Assert.assertTrue((boolean)dsg.getGraph(g).contains(t));
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        Iterator iter = dsg.find(null, null, null, null);
        Assert.assertTrue((boolean)iter.hasNext());
        Quad quad2 = (Quad)iter.next();
        Assert.assertFalse((boolean)iter.hasNext());
        Assert.assertEquals((Object)quad, (Object)quad2);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertFalse((boolean)dsg.getGraph(Node.createURI((String)"g")).isEmpty());
    }

    @Test
    public void graph_02() {
        Node g = Node.createURI((String)"g");
        DatasetGraph dsg = this.emptyDataset();
        Assert.assertNotNull((Object)dsg);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        dsg.add(quad);
        Triple t = SSE.parseTriple((String)"(<s> <p> <o>)");
        dsg.getGraph(g).delete(t);
        Assert.assertTrue((boolean)dsg.getDefaultGraph().isEmpty());
        Assert.assertTrue((boolean)dsg.getGraph(Node.createURI((String)"g")).isEmpty());
        Assert.assertFalse((boolean)dsg.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY).hasNext());
    }

    @Test
    public void graph_03() {
        Node g = Node.createURI((String)"g");
        DatasetGraph dsg = this.emptyDataset();
        Graph data = SSE.parseGraph((String)"(graph (<s> <p> <o>))");
        dsg.addGraph(g, data);
        Quad quad = SSE.parseQuad((String)"(quad <g> <s> <p> <o>)");
        Assert.assertTrue((boolean)dsg.contains(quad));
    }

    @Test
    public void find_01() {
        Node g1 = Node.createURI((String)"g1");
        DatasetGraph dsg = this.emptyDataset();
        Quad quad1 = SSE.parseQuad((String)"(quad <g1> <s1> <p1> <o1>)");
        Quad quad2 = SSE.parseQuad((String)"(quad <g2> <s2> <p2> <o2>)");
        dsg.add(quad1);
        dsg.add(quad2);
        List quads = Iter.toList((Iterator)dsg.find(g1, null, null, null));
        Assert.assertEquals((long)1L, (long)quads.size());
        Quad q = (Quad)quads.get(0);
        Assert.assertEquals((Object)quad1, (Object)q);
    }

    @Test
    public void deleteAny_01() {
        DatasetGraph dsg = this.emptyDataset();
        Node subject = Node.createURI((String)"http://example/s");
        Node predicate = Node.createURI((String)"http://example/p");
        Node object = Node.createAnon();
        dsg.add(new Quad(Quad.defaultGraphIRI, subject, predicate, object));
        dsg.deleteAny(Node.ANY, subject, null, null);
    }
}

