/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.VarRename;
import com.hp.hpl.jena.sparql.sse.SSE;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.openjena.atlas.junit.BaseTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestVarRename
extends BaseTest {
    public static Test suite() {
        return new JUnit4TestAdapter(TestVarRename.class);
    }

    @org.junit.Test
    public void rename_01() {
        TestVarRename.rename("(bgp (<s> <p> <o>))", "(bgp (<s> <p> <o>))", true, new String[0]);
    }

    @org.junit.Test
    public void rename_02() {
        TestVarRename.rename("(bgp (<s> ?p <o>))", "(bgp (<s> ?/p <o>))", true, new String[0]);
    }

    @org.junit.Test
    public void rename_03() {
        TestVarRename.rename("(bgp (?s ?p <o>))", "(bgp (?s ?/p <o>))", true, "s");
    }

    @org.junit.Test
    public void rename_04() {
        TestVarRename.rename("(filter (+ ?s ?x) (bgp (?s ?p <o>)))", "(filter (+ ?s ?/x) (bgp (?s ?/p <o>)))", true, "s");
    }

    @org.junit.Test
    public void rename_05() {
        TestVarRename.rename("(group ((?.1 (str ?x))) ((?.0 (count))) (bgp (triple ?x :p ?v)))", "(group ((?/.1 (str ?x))) ((?/.0 (count))) (bgp (triple ?x :p ?/v)))", true, "x");
    }

    @org.junit.Test
    public void rename_06() {
        TestVarRename.rename("(group ((?.1 (str ?x))) ((?.0 (max ?v))) (bgp (triple ?x :p ?v)))", "(group ((?/.1 (str ?x))) ((?/.0 (max ?/v))) (bgp (triple ?x :p ?/v)))", true, "x");
    }

    @org.junit.Test
    public void rename_07() {
        TestVarRename.rename("(assign ((?x (+ ?/a ?/b))) (table unit))", "(assign ((?/x (+ ?//a ?//b))) (table unit))", true, new String[0]);
    }

    @org.junit.Test
    public void rename_08() {
        TestVarRename.rename("(assign ((?x (+ ?/a ?/b))) (table unit))", "(assign ((?/x (+ ?/a ?//b))) (table unit))", false, "/a");
    }

    @org.junit.Test
    public void rename_09() {
        TestVarRename.rename("(project (?s ?p) (bgp (?s ?p ?o)))", "(project (?s ?/p) (bgp (?s ?/p ?/o)))", true, "s");
    }

    @org.junit.Test
    public void rename_reverse_01() {
        TestVarRename.reverse("(project (?s ?/p) (bgp (?s ?/p ?/o)))", "(project (?s ?p) (bgp (?s ?p ?o)))", true);
    }

    @org.junit.Test
    public void rename_reverse_02() {
        TestVarRename.reverse("(assign ((?/x (+ ?//a ?///b))) (table unit))", "(assign ((?x (+ ?a ?b))) (table unit))", true);
    }

    private static void reverse(String string, String string2, boolean repeatedly) {
        Op opOrig = SSE.parseOp((String)string);
        Op opExpected = SSE.parseOp((String)string2);
        Op opActual = VarRename.reverseRename((Op)opOrig, (boolean)repeatedly);
        TestVarRename.assertEquals((Object)opExpected, (Object)opActual);
    }

    private static void rename(String string, String string2, boolean reversable, String ... varNames) {
        HashSet<Var> s = new HashSet<Var>();
        for (String vn : varNames) {
            s.add(Var.alloc((String)vn));
        }
        TestVarRename.rename(string, string2, reversable, s);
    }

    private static void rename(String string, String string2, boolean reversable, Set<Var> constant) {
        Op opOrig = SSE.parseOp((String)string);
        Op opExpected = SSE.parseOp((String)string2);
        Op opActual = VarRename.rename((Op)opOrig, constant);
        TestVarRename.assertEquals((Object)opExpected, (Object)opActual);
        if (reversable) {
            Op opRebuilt = VarRename.reverseRename((Op)opActual, (boolean)false);
            TestVarRename.assertEquals((Object)opOrig, (Object)opRebuilt);
        }
    }
}

