/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformExpandOneOf;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterDisjunction;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterEquality;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterPlacement;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.sse.SSE;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.openjena.atlas.lib.StrUtils;

public class TestFilterTransform {
    private Transform t_equality = new TransformFilterEquality(false);
    private Transform t_disjunction = new TransformFilterDisjunction();
    private Transform t_placement = new TransformFilterPlacement();
    private Transform t_expandOneOf = new TransformExpandOneOf();

    public static Test suite() {
        return new JUnit4TestAdapter(TestFilterTransform.class);
    }

    @org.junit.Test
    public void equality01() {
        TestFilterTransform.test("(filter (= ?x <x>) (bgp ( ?s ?p ?x)) )", this.t_equality, "(extend ((?x <x>)) (bgp ( ?s ?p <x>)) )");
    }

    @org.junit.Test
    public void equality02() {
        TestFilterTransform.test("(filter (= ?x 'x') (bgp ( ?s ?p ?x)) )", this.t_equality, null);
    }

    @org.junit.Test
    public void equality03() {
        TestFilterTransform.test("(filter (= ?x 123) (bgp ( ?s ?p ?x)) )", this.t_equality, null);
    }

    @org.junit.Test
    public void equality04() {
        TestFilterTransform.test("(filter (= ?UNUSED <x>) (bgp ( ?s ?p ?x)) )", this.t_equality, null);
    }

    @org.junit.Test
    public void disjunction01() {
        TestFilterTransform.test("(filter (|| (= ?x <x>) (= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(disjunction ", "(extend ((?x <x>)) (bgp ( ?s ?p <x>)))", "(extend ((?x <y>)) (bgp ( ?s ?p <y>)))", ")");
    }

    @org.junit.Test
    public void disjunction02() {
        TestFilterTransform.test("(filter (|| (= ?x <x>) (!= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(disjunction ", "(extend ((?x <x>)) (bgp ( ?s ?p <x>)))", "(filter (!= ?x <y>) (bgp ( ?s ?p ?x)))", ")");
    }

    @org.junit.Test
    public void disjunction03() {
        TestFilterTransform.test("(filter (|| (!= ?x <x>) (= ?x <y>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(disjunction ", "(extend ((?x <y>)) (bgp ( ?s ?p <y>)))", "(filter (!= ?x <x>) (bgp ( ?s ?p ?x)))", ")");
    }

    @org.junit.Test
    public void disjunction04() {
        TestFilterTransform.test("(filter (|| (!= ?x <y>) (!= ?x <x>)) (bgp ( ?s ?p ?x)) )", this.t_disjunction, null);
    }

    @org.junit.Test
    public void disjunction05() {
        TestFilterTransform.test("(filter (exprlist (|| (= ?x <y>) (!= ?x <x>)) (lang ?x))    (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(filter (exprlist (|| (= ?x <y>) (!= ?x <x>)) (lang ?x))    (bgp ( ?s ?p ?x)) )");
    }

    @org.junit.Test
    public void disjunction06() {
        TestFilterTransform.test("(filter (exprlist (lang ?x) (|| (= ?x <y>) (!= ?x <x>)))    (bgp ( ?s ?p ?x)) )", this.t_disjunction, "(filter (exprlist (lang ?x) (|| (= ?x <y>) (!= ?x <x>)))    (bgp ( ?s ?p ?x)) )");
    }

    @org.junit.Test
    public void placement01() {
        TestFilterTransform.test("(filter (= ?x 1) (bgp ( ?s ?p ?x)))", this.t_placement, "(filter (= ?x 1) (bgp ( ?s ?p ?x)))");
    }

    @org.junit.Test
    public void placement02() {
        TestFilterTransform.test("(filter (= ?x 1) (bgp (?s ?p ?x) (?s1 ?p1 ?x1) ))", this.t_placement, "(sequence (filter (= ?x 1) (bgp ( ?s ?p ?x))) (bgp (?s1 ?p1 ?x1)))");
    }

    @org.junit.Test
    public void placement03() {
        TestFilterTransform.test("(filter (= ?x 1) (bgp (?s ?p ?x) (?s1 ?p1 ?x) ))", this.t_placement, "(sequence (filter (= ?x 1) (bgp ( ?s ?p ?x))) (bgp (?s1 ?p1 ?x)))");
    }

    @org.junit.Test
    public void placement04() {
        TestFilterTransform.test("(filter (= ?XX 1) (bgp (?s ?p ?x) (?s1 ?p1 ?XX) ))", this.t_placement, "(filter (= ?XX 1) (bgp (?s ?p ?x) (?s1 ?p1 ?XX) ))");
    }

    @org.junit.Test
    public void placement10() {
        TestFilterTransform.test("(filter (= ?x ?unbound) (bgp (?s ?p ?x)))", this.t_placement, "(filter (= ?x ?unbound) (bgp (?s ?p ?x)))");
    }

    @org.junit.Test
    public void placement11() {
        Op op1 = SSE.parseOp((String)"(filter (= ?x ?unbound) (bgp (?s ?p ?x)))");
        OpFilter f = (OpFilter)op1;
        Op op2 = TransformFilterPlacement.transform((ExprList)f.getExprs(), (BasicPattern)((OpBGP)f.getSubOp()).getPattern());
        Op op3 = SSE.parseOp((String)"(filter (= ?x ?unbound) (bgp (?s ?p ?x)))");
        Assert.assertEquals((Object)op3, (Object)op2);
    }

    @org.junit.Test
    public void placement12() {
        Op op1 = SSE.parseOp((String)"(filter (= ?x ?unbound) (bgp (?s ?p ?x) (?s1 ?p1 ?XX)))");
        OpFilter f = (OpFilter)op1;
        Op op2 = TransformFilterPlacement.transform((ExprList)f.getExprs(), (BasicPattern)((OpBGP)f.getSubOp()).getPattern());
        Op op3 = SSE.parseOp((String)"(filter (= ?x ?unbound) (bgp (?s ?p ?x) (?s1 ?p1 ?XX)))");
        Assert.assertEquals((Object)op3, (Object)op2);
    }

    @org.junit.Test
    public void placement20() {
        TestFilterTransform.test("(filter (= ?x 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", this.t_placement, "(conditional (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?z)) )");
    }

    @org.junit.Test
    public void placement21() {
        TestFilterTransform.test("(filter (= ?z 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))", this.t_placement, "(filter (= ?z 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?z)) ))");
    }

    @org.junit.Test
    public void placement22() {
        TestFilterTransform.test("(filter (= ?x 123) (conditional (bgp (?s ?p ?x)) (bgp (?s ?p ?x)) ))", this.t_placement, "(conditional (filter (= ?x 123) (bgp (?s ?p ?x))) (bgp (?s ?p ?x)) )");
    }

    @org.junit.Test
    public void oneOf1() {
        TestFilterTransform.test("(filter (in ?x <x> 2 3) (bgp (?s ?p ?x)))", this.t_expandOneOf, "(filter (|| ( || (= ?x <x>) (= ?x 2)) (= ?x 3)) (bgp (?s ?p ?x)))");
    }

    @org.junit.Test
    public void oneOf2() {
        TestFilterTransform.test("(filter (exprlist (= ?x 99) (in ?x <x> 2 3)) (bgp (?s ?p ?x)))", this.t_expandOneOf, "(filter (exprlist (= ?x 99) (|| ( || (= ?x <x>) (= ?x 2)) (= ?x 3))) (bgp (?s ?p ?x)))");
    }

    @org.junit.Test
    public void oneOf3() {
        TestFilterTransform.test("(filter (notin ?x <x> 2 3) (bgp (?s ?p ?x)))", this.t_expandOneOf, "(filter (exprlist (!= ?x <x>) (!= ?x 2) (!= ?x 3)) (bgp (?s ?p ?x)))");
    }

    static void test(String input, Transform transform, String ... output) {
        Op op1 = SSE.parseOp((String)input);
        Op op2 = Transformer.transform((Transform)transform, (Op)op1);
        if (output == null) {
            Assert.assertEquals((Object)op1, (Object)op2);
            return;
        }
        Op op3 = SSE.parseOp((String)StrUtils.strjoinNL((String[])output));
        Assert.assertEquals((Object)op3, (Object)op2);
    }
}

