/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.LeftJoinClassifier;
import com.hp.hpl.jena.sparql.syntax.Element;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;

public class TestClassify
extends TestCase {
    public static Test suite() {
        return new JUnit4TestAdapter(TestClassify.class);
    }

    @org.junit.Test
    public void testClassify_Join_01() {
        this.classifyJ("{?s :p :o . { ?s :p :o FILTER(true) } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_02() {
        this.classifyJ("{?s :p :o . { ?s :p :o FILTER(?s) } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_03() {
        this.classifyJ("{?s :p :o . { ?s :p ?o FILTER(?o) } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_04() {
        this.classifyJ("{?s :p :o . { ?s :p :o FILTER(?o) } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_05() {
        this.classifyJ("{?s :p :o . { ?x :p :o FILTER(?s) } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_06() {
        this.classifyJ("{ { ?s :p :o FILTER(true) } ?s :p :o }", true);
    }

    @org.junit.Test
    public void testClassify_Join_07() {
        this.classifyJ("{ { ?s :p :o FILTER(?s) }   ?s :p :o }", true);
    }

    @org.junit.Test
    public void testClassify_Join_08() {
        this.classifyJ("{ { ?s :p ?o FILTER(?o) }   ?s :p :o }", true);
    }

    @org.junit.Test
    public void testClassify_Join_09() {
        this.classifyJ("{ { ?s :p :o FILTER(?o) }   ?s :p :o }", true);
    }

    @org.junit.Test
    public void testClassify_Join_10() {
        this.classifyJ("{ { ?x :p :o FILTER(?s) }   ?s :p :o }", true);
    }

    @org.junit.Test
    public void testClassify_Join_11() {
        this.classifyJ("{?s :p :o . { OPTIONAL { ?s :p :o } } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_12() {
        this.classifyJ("{?s :p :o . { OPTIONAL { ?s :p :o FILTER(?s) } } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_13() {
        this.classifyJ("{?s :p :o . { ?x :p :o OPTIONAL { :s :p :o FILTER(?x) } } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_14() {
        this.classifyJ("{?s :p :o . { OPTIONAL { :s :p :o FILTER(?o) } } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_15() {
        this.classifyJ("{?s :p :o . { OPTIONAL { ?x :p :o FILTER(?s) } } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_20() {
        this.classifyJ("{ {?s :p ?x } . { {} OPTIONAL { :s :p ?x } } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_21() {
        this.classifyJ("{ { {} OPTIONAL { :s :p ?x } } {?s :p ?x } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_31() {
        this.classifyJ("{ ?x ?y ?z {SELECT ?s { ?s ?p ?o} } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_32() {
        this.classifyJ("{ GRAPH ?g { ?x ?y ?z } { FILTER (?a) } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_33() {
        this.classifyJ("{ GRAPH ?g { ?x ?y ?z } { FILTER (?z) } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_34() {
        this.classifyJ("{ GRAPH ?g { ?x ?y ?z } { ?a ?b ?z FILTER (?z) } }", true);
    }

    @org.junit.Test
    public void testClassify_Join_35() {
        this.classifyJ("{ GRAPH ?g { ?x ?y ?z } { OPTIONAL{?a ?b ?z} FILTER (?z) } }", false);
    }

    @org.junit.Test
    public void testClassify_Join_40() {
        this.classifyJ("{ ?x ?y ?z { ?x ?y ?z } UNION { ?x1 ?y1 ?z1 }}", true);
    }

    @org.junit.Test
    public void testClassify_Join_41() {
        this.classifyJ("{ ?x ?y ?z { ?x1 ?y1 ?z1 BIND(?z+2 AS ?A) } UNION { ?x1 ?y1 ?z1 }}", false);
    }

    @org.junit.Test
    public void testClassify_Join_42() {
        this.classifyJ("{ ?x ?y ?z { BIND(?z+2 AS ?A) } UNION { BIND(?z+2 AS ?B) }}", false);
    }

    @org.junit.Test
    public void testClassify_Join_43() {
        this.classifyJ("{ ?x ?y ?z { LET(?A := ?z+2) } UNION { }}", false);
    }

    private void classifyJ(String pattern, boolean expected) {
        String qs1 = "PREFIX : <http://example/>\n";
        String qs = qs1 + "SELECT * " + pattern;
        Query query = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        Op op = Algebra.compile((Element)query.getQueryPattern());
        if (!(op instanceof OpJoin)) {
            TestClassify.fail((String)("Not a join: " + pattern));
        }
        boolean nonLinear = JoinClassifier.isLinear((OpJoin)((OpJoin)op));
        TestClassify.assertEquals((String)("Join: " + pattern), (boolean)expected, (boolean)nonLinear);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_01() {
        this.classifyLJ("{ ?s ?p ?o OPTIONAL { ?s1 ?p2 ?x} }", true);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_02() {
        this.classifyLJ("{ ?s ?p ?o OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 ?p2 ?x} } }", true);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_03() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 :p ?o3} } }", true);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_04() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s1 ?p2 ?o3 OPTIONAL { ?s1 :p ?x} } }", false);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_05() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s ?p ?x OPTIONAL { ?s ?p ?x } } }", true);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_06() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { { ?s ?p ?o FILTER(?x) } } }", false);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_07() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { ?s ?p ?x1 OPTIONAL { ?s ?p ?x2 FILTER(?x) } } }", false);
    }

    @org.junit.Test
    public void testClassify_LeftJoin_10() {
        this.classifyLJ("{ ?s ?p ?x OPTIONAL { SELECT ?s { ?s ?p ?o } } }", false);
    }

    private void classifyLJ(String pattern, boolean expected) {
        String qs1 = "PREFIX : <http://example/>\n";
        String qs = qs1 + "SELECT * " + pattern;
        Query query = QueryFactory.create((String)qs, (Syntax)Syntax.syntaxARQ);
        Op op = Algebra.compile((Element)query.getQueryPattern());
        if (!(op instanceof OpLeftJoin)) {
            TestClassify.fail((String)("Not a leftjoin: " + pattern));
        }
        boolean nonLinear = LeftJoinClassifier.isLinear((OpLeftJoin)((OpLeftJoin)op));
        TestClassify.assertEquals((String)("LeftJoin: " + pattern), (boolean)expected, (boolean)nonLinear);
    }
}

